/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.expression.exception.EvaluationException;
import org.noear.solon.expression.snel.PropertyHolder;

public class ReflectionUtil {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_MAP = new HashMap();
    private final Map<MethodKey, Method> cache = new ConcurrentHashMap<MethodKey, Method>();
    private final Map<Class<?>, Method[]> methodsCache = new ConcurrentHashMap();
    private static final Map<String, PropertyHolder> PROPERTY_CACHE;

    private Method[] getMethods(Class<?> clazz) {
        return this.methodsCache.computeIfAbsent(clazz, Class::getMethods);
    }

    public Method getMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        MethodKey key = new MethodKey(clazz, methodName, argTypes);
        return this.cache.computeIfAbsent(key, k -> this.findMethod(clazz, methodName, argTypes));
    }

    private Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        Method method = Arrays.stream(this.getMethods(clazz)).filter(m -> m.getName().equals(methodName)).filter(m -> this.isMethodMatch((Method)m, argTypes)).findFirst().orElse(null);
        if (method != null) {
            method.setAccessible(true);
        }
        return method;
    }

    private boolean isMethodMatch(Method method, Class<?>[] argTypes) {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length != argTypes.length) {
            return false;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            if (this.isAssignable(paramTypes[i], argTypes[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isAssignable(Class<?> targetType, Class<?> sourceType) {
        if (targetType.isPrimitive()) {
            Class<?> wrapperType = PRIMITIVE_WRAPPER_MAP.get(targetType);
            return wrapperType != null && wrapperType.isAssignableFrom(sourceType);
        }
        if (sourceType.isPrimitive()) {
            Class<?> targetWrapper = PRIMITIVE_WRAPPER_MAP.get(sourceType);
            return targetType.isAssignableFrom(targetWrapper);
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        return sourceType == Void.class;
    }

    public static PropertyHolder getProperty(Class<?> clazz, String propName) {
        String key = clazz.getName() + ":" + propName;
        return PROPERTY_CACHE.computeIfAbsent(key, k -> {
            try {
                String name = "get" + ReflectionUtil.capitalize(propName);
                Method method = clazz.getMethod(name, new Class[0]);
                method.setAccessible(true);
                return new PropertyHolder(method, null);
            }
            catch (NoSuchMethodException e) {
                try {
                    Field field = clazz.getField(propName);
                    field.setAccessible(true);
                    return new PropertyHolder(null, field);
                }
                catch (NoSuchFieldException ex) {
                    throw new EvaluationException("Missing property: " + propName, e);
                }
            }
        });
    }

    private static String capitalize(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    static {
        PRIMITIVE_WRAPPER_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPER_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_WRAPPER_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPER_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPER_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_WRAPPER_MAP.put(Double.TYPE, Double.class);
        PRIMITIVE_WRAPPER_MAP.put(Boolean.TYPE, Boolean.class);
        PROPERTY_CACHE = new ConcurrentHashMap<String, PropertyHolder>();
    }

    private static class MethodKey {
        private final Class<?> clazz;
        private final String methodName;
        private final Class<?>[] argTypes;

        public MethodKey(Class<?> clazz, String methodName, Class<?>[] argTypes) {
            this.clazz = clazz;
            this.methodName = methodName;
            this.argTypes = argTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodKey methodKey = (MethodKey)o;
            return this.clazz.equals(methodKey.clazz) && this.methodName.equals(methodKey.methodName) && Arrays.equals(this.argTypes, methodKey.argTypes);
        }

        public int hashCode() {
            int result = this.clazz.hashCode();
            result = 31 * result + this.methodName.hashCode();
            result = 31 * result + Arrays.hashCode(this.argTypes);
            return result;
        }
    }
}

