/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.docs.openapi2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.models.ArrayModel;
import io.swagger.models.Contact;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UntypedProperty;
import io.swagger.models.refs.RefFormat;
import io.swagger.solon.annotation.ApiNoAuthorize;
import io.swagger.solon.annotation.ApiRes;
import io.swagger.solon.annotation.ApiResProperty;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.Collator;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Gateway;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.route.Routing;
import org.noear.solon.core.util.NameUtil;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.FieldWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.core.wrap.TypeWrap;
import org.noear.solon.docs.DocDocket;
import org.noear.solon.docs.exception.DocException;
import org.noear.solon.docs.models.ApiContact;
import org.noear.solon.docs.models.ApiLicense;
import org.noear.solon.docs.models.ApiScheme;
import org.noear.solon.docs.openapi2.impl.ActionHolder;
import org.noear.solon.docs.openapi2.impl.BuilderHelper;
import org.noear.solon.docs.openapi2.impl.ParamHolder;
import org.noear.solon.docs.openapi2.wrap.ApiImplicitParamImpl;

public class OpenApi2Builder {
    private final Swagger swagger = new Swagger();
    private final DocDocket docket;
    private ModelImpl globalResultModel;

    public OpenApi2Builder(DocDocket docket) {
        this.docket = docket;
    }

    public Swagger build(String description) {
        if (this.docket.globalResult() != null) {
            this.globalResultModel = (ModelImpl)this.parseSwaggerModel(this.docket.globalResult(), this.docket.globalResult());
        }
        this.parseGroupPackage();
        ApiLicense apiLicense = this.docket.info().license();
        ApiContact apiContact = this.docket.info().contact();
        if (Utils.isEmpty((String)description)) {
            description = this.docket.info().description();
        }
        this.swagger.setSwagger(this.docket.version());
        this.swagger.info(new Info().title(this.docket.info().title()).description(description).termsOfService(this.docket.info().termsOfService()).version(this.docket.info().version()));
        if (apiLicense != null) {
            License license = new License().url(apiLicense.url()).name(apiLicense.name());
            license.setVendorExtensions(apiLicense.vendorExtensions());
            this.swagger.getInfo().setLicense(license);
        }
        if (apiContact != null) {
            Contact contact = new Contact().email(apiContact.email()).name(apiContact.name()).url(apiContact.url());
            contact.setVendorExtensions(apiContact.vendorExtensions());
            this.swagger.getInfo().contact(contact);
        }
        this.swagger.host(BuilderHelper.getHost(this.docket));
        this.swagger.basePath(this.docket.basePath());
        if (this.docket.schemes() != null) {
            for (ApiScheme scheme : this.docket.schemes()) {
                this.swagger.scheme(Scheme.forValue((String)scheme.toValue()));
            }
        }
        if (this.docket.externalDocs() != null) {
            this.swagger.externalDocs(new ExternalDocs(this.docket.externalDocs().description(), this.docket.externalDocs().url()));
        }
        this.swagger.vendorExtensions(this.docket.vendorExtensions());
        this.docket.securityExtensions().forEach((key, val) -> {
            if (val instanceof SecuritySchemeDefinition) {
                this.swagger.addSecurityDefinition(key, (SecuritySchemeDefinition)val);
            }
        });
        if (this.swagger.getTags() != null) {
            this.swagger.getTags().sort((t1, t2) -> {
                String name1 = t1.getDescription();
                String name2 = t2.getDescription();
                return Collator.getInstance(Locale.UK).compare(name1, name2);
            });
        }
        if (this.swagger.getDefinitions() != null) {
            ArrayList definitionKeys = new ArrayList(this.swagger.getDefinitions().keySet());
            LinkedHashMap definitionMap = new LinkedHashMap();
            definitionKeys.sort((name1, name2) -> Collator.getInstance(Locale.UK).compare((String)name1, (String)name2));
            for (String name : definitionKeys) {
                definitionMap.put(name, this.swagger.getDefinitions().get(name));
            }
            this.swagger.setDefinitions(definitionMap);
        }
        return this.swagger;
    }

    private void parseGroupPackage() {
        Map<Class<?>, List<ActionHolder>> classMap = this.getApiAction();
        for (Map.Entry<Class<?>, List<ActionHolder>> kv : classMap.entrySet()) {
            this.parseController(kv.getKey(), kv.getValue());
        }
    }

    private Map<Class<?>, List<ActionHolder>> getApiAction() {
        HashMap apiMap = new HashMap(16);
        Collection routingCollection = Solon.app().router().getAll();
        for (Routing routing : routingCollection) {
            if (routing.target() instanceof Action) {
                this.resolveAction(apiMap, (Routing<Handler>)routing);
            }
            if (!(routing.target() instanceof Gateway)) continue;
            for (Routing routing2 : ((Gateway)routing.target()).getMainRouting().getAll()) {
                if (!(routing2.target() instanceof Action)) continue;
                this.resolveAction(apiMap, (Routing<Handler>)routing2);
            }
        }
        ArrayList ctlList = new ArrayList(apiMap.keySet());
        ctlList.sort(Comparator.comparingInt(clazz -> clazz.getAnnotation(Api.class).position()));
        LinkedHashMap result = new LinkedHashMap();
        ctlList.forEach(i -> {
            List actionHolders = (List)apiMap.get(i);
            actionHolders.sort(Comparator.comparingInt(ah -> ah.getAnnotation(ApiOperation.class).position()));
            result.put((Class<?>)i, actionHolders);
        });
        return result;
    }

    private void resolveAction(Map<Class<?>, List<ActionHolder>> apiMap, Routing<Handler> routing) {
        Action action = (Action)routing.target();
        Class controller = action.controller().clz();
        boolean matched = this.docket.apis().stream().anyMatch(res -> res.test(action));
        if (!matched) {
            return;
        }
        ActionHolder actionHolder = new ActionHolder(routing, action);
        if (apiMap.containsKey(controller)) {
            List<ActionHolder> actionHolders;
            if (action.method().isAnnotationPresent(ApiOperation.class) && !(actionHolders = apiMap.get(controller)).contains(actionHolder)) {
                actionHolders.add(actionHolder);
                apiMap.put(controller, actionHolders);
            }
        } else if (controller.isAnnotationPresent(Api.class) && action.method().isAnnotationPresent(ApiOperation.class)) {
            ArrayList<ActionHolder> actionHolders = new ArrayList<ActionHolder>();
            actionHolders.add(actionHolder);
            apiMap.put(controller, actionHolders);
        }
    }

    private void parseController(Class<?> clazz, List<ActionHolder> actionHolders) {
        Api api = clazz.getAnnotation(Api.class);
        boolean hidden = api.hidden();
        if (hidden) {
            return;
        }
        String controllerKey = BuilderHelper.getControllerKey(clazz);
        LinkedHashSet<String> apiTags = new LinkedHashSet<String>();
        apiTags.add(api.value());
        apiTags.addAll(Arrays.asList(api.tags()));
        apiTags.remove("");
        for (String tagName : apiTags) {
            Tag tag = new Tag();
            tag.setName(tagName);
            tag.setDescription(controllerKey + " (" + clazz.getSimpleName() + ")");
            this.swagger.addTag(tag);
        }
        this.parseAction(actionHolders);
    }

    private void parseAction(List<ActionHolder> actionHolders) {
        for (ActionHolder actionHolder : actionHolders) {
            ApiOperation apiAction = actionHolder.getAnnotation(ApiOperation.class);
            if (apiAction.hidden()) {
                return;
            }
            String controllerKey = BuilderHelper.getControllerKey(actionHolder.controllerClz());
            String actionName = actionHolder.action().name();
            Method actionMethod = actionHolder.action().method().getMethod();
            Set<String> actionTags = actionHolder.getTags(apiAction);
            String pathKey = actionHolder.routing().path();
            pathKey = PathUtil.mergePath((String)Solon.cfg().serverContextPath(), (String)pathKey);
            Path path = this.swagger.getPath(pathKey);
            if (path == null) {
                path = new Path();
                this.swagger.path(pathKey, path);
            }
            Operation operation = new Operation();
            operation.setTags(new ArrayList<String>(actionTags));
            operation.setSummary(apiAction.value());
            operation.setDescription(apiAction.notes());
            operation.setDeprecated(Boolean.valueOf(actionHolder.isAnnotationPresent(Deprecated.class)));
            if (!(actionHolder.isAnnotationPresent(ApiNoAuthorize.class) || actionHolder.controllerClz().isAnnotationPresent(ApiNoAuthorize.class))) {
                for (String securityName : this.docket.securityExtensions().keySet()) {
                    operation.security(new SecurityRequirement(securityName).scope("global"));
                }
            }
            String operationMethod = BuilderHelper.getHttpMethod(actionHolder, apiAction);
            String operationConsumes = Utils.annoAlias((String)apiAction.consumes(), (String)actionHolder.action().consumes());
            String operationProduces = Utils.annoAlias((String)apiAction.produces(), (String)actionHolder.action().produces());
            boolean isRequiredBody = false;
            if (operationConsumes != null && operationConsumes.contains("json") && !operationMethod.equals("get")) {
                isRequiredBody = true;
            }
            operation.setParameters(this.parseActionParameters(actionHolder, isRequiredBody));
            operation.setResponses(this.parseActionResponse(controllerKey, actionName, actionMethod));
            operation.setVendorExtension("controllerKey", (Object)controllerKey);
            operation.setVendorExtension("actionName", (Object)actionName);
            for (Object p1 : this.docket.globalParams()) {
                if (!(p1 instanceof Parameter)) continue;
                operation.addParameter((Parameter)p1);
            }
            if (Utils.isEmpty((String)operationConsumes)) {
                if (operationMethod.equals("get")) {
                    operation.consumes("application/x-www-form-urlencoded");
                } else if (operation.getParameters().stream().anyMatch(parameter -> parameter instanceof BodyParameter)) {
                    operation.consumes("application/json");
                } else {
                    operation.consumes("application/x-www-form-urlencoded");
                }
            } else {
                operation.consumes(operationConsumes);
            }
            if (Utils.isEmpty((String)operationProduces)) {
                operation.produces("*/*");
            } else {
                operation.produces(operationProduces);
            }
            operation.setOperationId(operationMethod + "_" + pathKey.replace("/", "_"));
            path.set(operationMethod, operation);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<Parameter> parseActionParameters(ActionHolder actionHolder, boolean isRequiredBody) {
        LinkedHashMap<String, ParamHolder> actionParamMap = new LinkedHashMap<String, ParamHolder>();
        for (ParamWrap p1 : actionHolder.action().method().getParamWraps()) {
            actionParamMap.put(p1.spec().getName(), new ParamHolder(p1));
        }
        ArrayList<ApiImplicitParam> apiParams = new ArrayList<ApiImplicitParam>();
        if (actionHolder.isAnnotationPresent(ApiImplicitParams.class)) {
            apiParams.addAll(Arrays.asList(actionHolder.getAnnotation(ApiImplicitParams.class).value()));
        }
        if (actionHolder.isAnnotationPresent(ApiImplicitParams.class)) {
            ApiImplicitParam[] paramArray = (ApiImplicitParam[])actionHolder.getAnnotationsByType(ApiImplicitParam.class);
            apiParams.addAll(Arrays.asList(paramArray));
        }
        for (ApiImplicitParam a1 : apiParams) {
            ParamHolder paramHolder = (ParamHolder)actionParamMap.get(a1.name());
            if (paramHolder == null) {
                paramHolder = new ParamHolder(null);
                actionParamMap.put(a1.name(), paramHolder);
            }
            paramHolder.binding(new ApiImplicitParamImpl(a1));
        }
        ArrayList<Parameter> paramList = new ArrayList<Parameter>();
        Iterator<Object> iterator = actionParamMap.values().iterator();
        while (true) {
            HeaderParameter parameter;
            ParamHolder paramHolder;
            block33: {
                FormParameter formParameter;
                BodyParameter modelParameter;
                String dataType;
                String paramSchema;
                block34: {
                    ObjectProperty objectProperty;
                    block38: {
                        block37: {
                            block36: {
                                block35: {
                                    if (!iterator.hasNext()) {
                                        return this.mergeBodyParamList(actionHolder, paramList);
                                    }
                                    paramHolder = (ParamHolder)iterator.next();
                                    if (paramHolder.isIgnore()) continue;
                                    paramSchema = null;
                                    if (isRequiredBody || paramHolder.isRequiredBody()) {
                                        paramSchema = this.getParameterSchema(paramHolder);
                                    }
                                    dataType = paramHolder.dataType();
                                    if (!paramHolder.allowMultiple()) break block34;
                                    if (!Utils.isNotEmpty((String)paramSchema)) break block35;
                                    modelParameter = new BodyParameter();
                                    modelParameter.setSchema((Model)new ArrayModel().items((Property)new RefProperty(paramSchema)));
                                    if (!isRequiredBody && paramHolder.getParam() != null && !paramHolder.getParam().spec().isRequiredBody()) {
                                        modelParameter.setIn("query");
                                    }
                                    parameter = modelParameter;
                                    break block33;
                                }
                                if (!"file".equals(dataType)) break block36;
                                formParameter = new FormParameter();
                                formParameter.type("array");
                                formParameter.items((Property)new FileProperty());
                                parameter = formParameter;
                                break block33;
                            }
                            objectProperty = new ObjectProperty();
                            objectProperty.setType(dataType);
                            if (!paramHolder.isRequiredHeader()) break block37;
                            parameter = new HeaderParameter().type("array");
                            break block33;
                        }
                        if (!paramHolder.isRequiredCookie()) break block38;
                        parameter = new CookieParameter().type("array");
                        break block33;
                    }
                    if (paramHolder.isRequiredPath()) {
                        parameter = new PathParameter().type("array");
                        break block33;
                    } else if (isRequiredBody || paramHolder.isRequiredBody()) {
                        BodyParameter bodyParameter = new BodyParameter();
                        if (Utils.isNotEmpty((String)dataType)) {
                            bodyParameter.setSchema((Model)new ArrayModel().items((Property)objectProperty));
                        }
                        parameter = bodyParameter;
                        break block33;
                    } else {
                        parameter = ((QueryParameter)new QueryParameter().type("array")).items((Property)objectProperty);
                    }
                    break block33;
                }
                if (Utils.isNotEmpty((String)paramSchema)) {
                    if (isRequiredBody || paramHolder.isRequiredBody() || paramHolder.getParam() == null) {
                        modelParameter = new BodyParameter();
                        if (paramHolder.isMap()) {
                            modelParameter.setSchema((Model)new ModelImpl().type("object"));
                        } else {
                            modelParameter.setSchema((Model)new RefModel(paramSchema));
                        }
                        if (paramHolder.getParam() != null && !paramHolder.getParam().spec().isRequiredBody()) {
                            modelParameter.setIn("query");
                        }
                        parameter = modelParameter;
                        break block33;
                    } else {
                        this.parseActionParametersByFields(paramHolder, paramList);
                        continue;
                    }
                }
                if ("file".equals(dataType)) {
                    formParameter = new FormParameter();
                    formParameter.items((Property)new FileProperty());
                    parameter = formParameter;
                } else if (paramHolder.isRequiredHeader()) {
                    parameter = new HeaderParameter();
                } else if (paramHolder.isRequiredCookie()) {
                    parameter = new CookieParameter();
                } else if (paramHolder.isRequiredPath()) {
                    parameter = new PathParameter();
                } else if (isRequiredBody || paramHolder.isRequiredBody()) {
                    BodyParameter bodyParameter = new BodyParameter();
                    if (Utils.isNotEmpty((String)dataType)) {
                        bodyParameter.setSchema((Model)new ModelImpl().type(dataType));
                    }
                    parameter = bodyParameter;
                } else {
                    QueryParameter queryParameter = new QueryParameter();
                    queryParameter.setType(dataType);
                    if (paramHolder.getAnno() != null) {
                        queryParameter.setFormat(paramHolder.getAnno().format());
                        queryParameter.setDefaultValue(paramHolder.getAnno().defaultValue());
                    }
                    parameter = queryParameter;
                }
            }
            parameter.setName(paramHolder.getName());
            parameter.setDescription(paramHolder.getDescription());
            parameter.setRequired(paramHolder.isRequired());
            parameter.setReadOnly(Boolean.valueOf(paramHolder.isReadOnly()));
            if (Utils.isEmpty((String)parameter.getIn())) {
                parameter.setIn(paramHolder.paramType());
            }
            paramList.add((Parameter)parameter);
        }
    }

    private List<Parameter> mergeBodyParamList(ActionHolder actionHolder, List<Parameter> paramList) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if ("application/json-type".equals(actionHolder.action().consumes()) || paramList.stream().map(Parameter::getIn).anyMatch(in -> in.equals("body"))) {
            BodyParameter finalBodyParameter = new BodyParameter();
            finalBodyParameter.setIn("body");
            finalBodyParameter.name("data");
            ModelImpl model = new ModelImpl();
            model.setDescription("mineBody");
            model.setName("mineBody");
            for (Parameter parameter : paramList) {
                if (parameter instanceof BodyParameter) {
                    BodyParameter bodyParameter = (BodyParameter)parameter;
                    Model schema = bodyParameter.getSchema();
                    if (schema instanceof RefModel) {
                        RefModel refModel = (RefModel)schema;
                        model.setProperties(((Model)this.swagger.getDefinitions().get(refModel.getSimpleRef())).getProperties());
                        continue;
                    }
                    if (schema instanceof ModelImpl) {
                        ModelImpl schemaModelImpl = (ModelImpl)schema;
                        ObjectProperty property = new ObjectProperty();
                        property.setType(schemaModelImpl.getType());
                        property.setDescription(schemaModelImpl.getDescription());
                        model.setProperties(Collections.singletonMap(bodyParameter.getName(), property));
                        continue;
                    }
                    parameters.add(parameter);
                    continue;
                }
                parameters.add(parameter);
            }
            String key = String.format("Map[%s]", actionHolder.action().fullName().replace("/", "_").replace("${", "").replace("}", ""));
            this.swagger.addDefinition(key, (Model)model);
            finalBodyParameter.setSchema((Model)new RefModel(key));
            parameters.add((Parameter)finalBodyParameter);
        } else {
            parameters.addAll(paramList);
        }
        return parameters;
    }

    private void parseActionParametersByFields(ParamHolder paramHolder, List<Parameter> paramList) {
        ClassWrap classWrap = ClassWrap.get((Class)paramHolder.getParam().getType());
        for (FieldWrap fw : classWrap.getAllFieldWraps()) {
            if (Modifier.isTransient(fw.getField().getModifiers())) continue;
            QueryParameter parameter = new QueryParameter();
            if (Collection.class.isAssignableFrom(fw.getType())) {
                parameter.setType("array");
            } else if (Map.class.isAssignableFrom(fw.getType())) {
                parameter.setType("object");
            } else {
                parameter.setType(fw.getType().getSimpleName());
            }
            ApiModelProperty anno = fw.getField().getAnnotation(ApiModelProperty.class);
            if (anno != null) {
                parameter.setName(anno.name());
                parameter.setDescription(anno.value());
                parameter.setRequired(anno.required());
                parameter.setReadOnly(Boolean.valueOf(anno.readOnly()));
                if (Utils.isNotEmpty((String)anno.dataType())) {
                    parameter.setType(anno.dataType());
                }
            }
            if (Utils.isEmpty((String)parameter.getName())) {
                parameter.setName(fw.getName());
            }
            paramList.add((Parameter)parameter);
        }
    }

    private Map<String, Response> parseActionResponse(String controllerKey, String actionName, Method method) {
        LinkedHashMap<String, Response> responseMap = new LinkedHashMap<String, Response>();
        this.docket.globalResponseCodes().forEach((key, value) -> {
            String schema;
            Response response = new Response();
            response.description(value);
            if (key == 200 && (schema = this.parseResponse(controllerKey, actionName, method)) != null) {
                response.setResponseSchema((Model)new RefModel(schema));
            }
            responseMap.put(String.valueOf(key), response);
        });
        return responseMap;
    }

    private String parseResponse(String controllerKey, String actionName, Method method) {
        Class<?> apiResClz;
        String swaggerModelName = null;
        ArrayList<ApiResProperty> responses = new ArrayList<ApiResProperty>();
        if (method.isAnnotationPresent(ApiRes.class)) {
            responses.addAll(Arrays.asList(method.getAnnotation(ApiRes.class).value()));
        }
        if (method.isAnnotationPresent(ApiRes.class)) {
            ApiResProperty[] paramArray = (ApiResProperty[])method.getAnnotationsByType(ApiResProperty.class);
            responses.addAll(Arrays.asList(paramArray));
        }
        if ((apiResClz = method.getReturnType()) != Void.class && BuilderHelper.isModel(apiResClz)) {
            try {
                ModelImpl commonResKv = (ModelImpl)this.parseSwaggerModel(apiResClz, method.getGenericReturnType());
                swaggerModelName = commonResKv.getName();
                return swaggerModelName;
            }
            catch (Exception e) {
                String hint = method.getDeclaringClass().getName() + ":" + method.getName() + "->" + apiResClz.getSimpleName();
                throw new DocException("Response model parsing failure: " + hint, (Throwable)e);
            }
        }
        if (responses.size() == 0) {
            if (this.globalResultModel != null) {
                swaggerModelName = this.globalResultModel.getName();
            }
        } else {
            ModelImpl swaggerModelKv = (ModelImpl)this.parseSwaggerModel(controllerKey, actionName, responses);
            swaggerModelName = swaggerModelKv.getName();
            if (this.docket.globalResponseInData()) {
                swaggerModelName = this.toResponseInData(swaggerModelName);
            }
        }
        return swaggerModelName;
    }

    private String toResponseInData(String swaggerModelName) {
        if (this.globalResultModel != null) {
            LinkedHashMap<String, RefProperty> propertyMap = new LinkedHashMap<String, RefProperty>();
            propertyMap.putAll(this.globalResultModel.getProperties());
            RefProperty property = new RefProperty(swaggerModelName, RefFormat.INTERNAL);
            property.setDescription("\u8fd4\u56de\u503c");
            propertyMap.put("data", property);
            swaggerModelName = this.globalResultModel.getName() + "\u00ab" + swaggerModelName + "\u00bb";
            ModelImpl model = new ModelImpl();
            model.setTitle(swaggerModelName);
            model.setProperties(propertyMap);
            this.swagger.addDefinition(swaggerModelName, (Model)model);
        }
        return swaggerModelName;
    }

    private Model parseSwaggerModel(Class<?> clazz, Type type) {
        Model model;
        String modelName = BuilderHelper.getModelName(clazz, type);
        if (this.swagger.getDefinitions() != null && null != (model = (Model)this.swagger.getDefinitions().get(modelName))) {
            return model;
        }
        ApiModel apiModel = clazz.getAnnotation(ApiModel.class);
        String title = apiModel != null ? apiModel.description() : modelName;
        LinkedHashMap<String, Property> propertyList = new LinkedHashMap<String, Property>();
        ModelImpl model2 = new ModelImpl();
        model2.setName(modelName);
        model2.setTitle(title);
        model2.setType("object");
        this.swagger.addDefinition(modelName, (Model)model2);
        if (clazz.isEnum()) {
            model2.setType("string");
            return model2;
        }
        ClassWrap classWrap = ClassWrap.get(clazz);
        if (clazz.isInterface()) {
            TypeWrap propType;
            ApiModelProperty propAnno;
            String propName;
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.getParameterTypes().length != 0 || !method.getName().startsWith("get") || Modifier.isStatic(method.getModifiers())) continue;
                propName = NameUtil.getFieldName((String)method.getName());
                propAnno = method.getAnnotation(ApiModelProperty.class);
                propType = new TypeWrap(clazz, method.getReturnType(), method.getGenericReturnType());
                this.parseSwaggerModelProperty(type, modelName, propertyList, propName, propType.getType(), propType.getGenericType(), propAnno);
            }
            for (Method method : clazz.getMethods()) {
                if (method.getParameterTypes().length != 0 || !method.getName().startsWith("get") || Modifier.isStatic(method.getModifiers()) || propertyList.containsKey(propName = NameUtil.getFieldName((String)method.getName()))) continue;
                propAnno = method.getAnnotation(ApiModelProperty.class);
                propType = new TypeWrap(clazz, method.getReturnType(), method.getGenericReturnType());
                this.parseSwaggerModelProperty(type, modelName, propertyList, propName, propType.getType(), propType.getGenericType(), propAnno);
            }
        } else {
            for (FieldWrap fw : classWrap.getAllFieldWraps()) {
                if (Modifier.isStatic(fw.getField().getModifiers())) continue;
                String propName = fw.getName();
                ApiModelProperty propAnno = fw.getField().getAnnotation(ApiModelProperty.class);
                TypeWrap fwTypeWrap = fw.typeWrapOf(type);
                this.parseSwaggerModelProperty(type, modelName, propertyList, propName, fwTypeWrap.getType(), fwTypeWrap.getGenericType(), propAnno);
            }
        }
        model2.setProperties(propertyList);
        return model2;
    }

    private void parseSwaggerModelProperty(Type type, String modelName, Map<String, Property> propertyList, String propName, Class<?> propType, ParameterizedType propGenericType, ApiModelProperty propAnno) {
        if (propAnno != null && propAnno.hidden()) {
            return;
        }
        if (Collection.class.isAssignableFrom(propType)) {
            Type itemClazz;
            if (propGenericType == null) {
                return;
            }
            ArrayProperty fieldPr = new ArrayProperty();
            if (propAnno != null) {
                fieldPr.setDescription(propAnno.value());
                fieldPr.setRequired(propAnno.required());
            }
            if ((itemClazz = propGenericType.getActualTypeArguments()[0]) instanceof Class) {
                if (itemClazz.equals(type)) {
                    RefProperty itemPr = new RefProperty(modelName, RefFormat.INTERNAL);
                    fieldPr.setItems((Property)itemPr);
                } else {
                    Property itemPr = this.getPrimitiveProperty((Class)itemClazz);
                    if (itemPr != null) {
                        fieldPr.setItems(itemPr);
                    } else {
                        ModelImpl swaggerModel = (ModelImpl)this.parseSwaggerModel((Class)itemClazz, itemClazz);
                        itemPr = new RefProperty(swaggerModel.getName(), RefFormat.INTERNAL);
                        fieldPr.setItems(itemPr);
                    }
                }
            }
            propertyList.put(propName, (Property)fieldPr);
            return;
        }
        if (BuilderHelper.isModel(propType)) {
            if (propType.equals(type)) {
                RefProperty propPr = new RefProperty(modelName, RefFormat.INTERNAL);
                if (propAnno != null) {
                    propPr.setDescription(propAnno.value());
                    propPr.setRequired(propAnno.required());
                    propPr.setExample(propAnno.example());
                }
                propertyList.put(propName, (Property)propPr);
            } else {
                ModelImpl swaggerModel = (ModelImpl)this.parseSwaggerModel(propType, propGenericType);
                RefProperty propPr = new RefProperty(swaggerModel.getName(), RefFormat.INTERNAL);
                if (propAnno != null) {
                    propPr.setDescription(propAnno.value());
                    propPr.setRequired(propAnno.required());
                    propPr.setExample(propAnno.example());
                }
                propertyList.put(propName, (Property)propPr);
            }
        } else {
            ObjectProperty propPr = new ObjectProperty();
            propPr.setName(propName);
            if (propAnno != null) {
                propPr.setDescription(propAnno.value());
                propPr.setRequired(propAnno.required());
                propPr.setExample(propAnno.example());
                propPr.setType(Utils.isBlank((String)propAnno.dataType()) ? propType.getSimpleName().toLowerCase() : propAnno.dataType());
            } else {
                propPr.setType(propType.getSimpleName().toLowerCase());
            }
            propertyList.put(propName, (Property)propPr);
        }
    }

    private Model parseSwaggerModel(String controllerKey, String actionName, List<ApiResProperty> responses) {
        String modelName = controllerKey + "_" + actionName;
        LinkedHashMap<String, ArrayProperty> propertiesList = new LinkedHashMap<String, ArrayProperty>();
        ModelImpl model = new ModelImpl();
        model.setName(modelName);
        this.swagger.addDefinition(modelName, (Model)model);
        if (!this.docket.globalResponseInData() && this.globalResultModel != null) {
            propertiesList.putAll(this.globalResultModel.getProperties());
        }
        for (ApiResProperty apiResponse : responses) {
            ArrayProperty propPr;
            if (apiResponse.dataTypeClass() != Void.class) {
                ArrayProperty propPr2;
                ModelImpl swaggerModel = (ModelImpl)this.parseSwaggerModel(apiResponse.dataTypeClass(), apiResponse.dataTypeClass());
                if (apiResponse.allowMultiple()) {
                    propPr2 = new ArrayProperty();
                    propPr2.setName(swaggerModel.getName());
                    propPr2.setDescription(apiResponse.value());
                    propPr2.items((Property)new RefProperty(swaggerModel.getName(), RefFormat.INTERNAL));
                    propertiesList.put(apiResponse.name(), propPr2);
                    continue;
                }
                propPr2 = new RefProperty(swaggerModel.getName(), RefFormat.INTERNAL);
                propPr2.setDescription(apiResponse.value());
                propertiesList.put(apiResponse.name(), propPr2);
                continue;
            }
            if (apiResponse.allowMultiple()) {
                propPr = new ArrayProperty();
                propPr.setName(apiResponse.name());
                propPr.setDescription(apiResponse.value());
                propPr.setFormat(Utils.isBlank((String)apiResponse.format()) ? "" : apiResponse.format());
                propPr.setExample(apiResponse.example());
                UntypedProperty itemsProperty = new UntypedProperty();
                itemsProperty.setType(Utils.isBlank((String)apiResponse.dataType()) ? "string" : apiResponse.dataType());
                propPr.items((Property)itemsProperty);
                propertiesList.put(apiResponse.name(), propPr);
                continue;
            }
            propPr = new UntypedProperty();
            propPr.setName(apiResponse.name());
            propPr.setDescription(apiResponse.value());
            propPr.setType(Utils.isBlank((String)apiResponse.dataType()) ? "string" : apiResponse.dataType());
            propPr.setFormat(Utils.isBlank((String)apiResponse.format()) ? "" : apiResponse.format());
            propPr.setExample(apiResponse.example());
            propertiesList.put(apiResponse.name(), propPr);
        }
        model.setProperties(propertiesList);
        return model;
    }

    private String getParameterSchema(ParamHolder paramHolder) {
        Class<?> dataTypeClass = paramHolder.dataTypeClass();
        if (dataTypeClass != null) {
            if (dataTypeClass.isPrimitive()) {
                return null;
            }
            if (UploadedFile.class.equals(dataTypeClass)) {
                return null;
            }
            if (dataTypeClass.getName().startsWith("java.lang")) {
                return null;
            }
            Type dataGenericType = paramHolder.dataGenericType();
            if (dataTypeClass != Void.class) {
                Type itemType;
                if (Collection.class.isAssignableFrom(dataTypeClass) && dataGenericType instanceof ParameterizedType && (itemType = ((ParameterizedType)dataGenericType).getActualTypeArguments()[0]) instanceof Class) {
                    ModelImpl swaggerModel = (ModelImpl)this.parseSwaggerModel((Class)itemType, itemType);
                    return swaggerModel.getName();
                }
                ModelImpl swaggerModel = (ModelImpl)this.parseSwaggerModel(dataTypeClass, dataGenericType);
                return swaggerModel.getName();
            }
        }
        return null;
    }

    private Property getPrimitiveProperty(Class<?> clz) {
        if (clz == Integer.class || clz == Integer.TYPE) {
            return new IntegerProperty();
        }
        if (clz == Long.class || clz == Long.TYPE) {
            return new LongProperty();
        }
        if (clz == Float.class || clz == Float.TYPE) {
            return new FloatProperty();
        }
        if (clz == Double.class || clz == Double.TYPE) {
            return new DoubleProperty();
        }
        if (clz == Boolean.class || clz == Boolean.TYPE) {
            return new BooleanProperty();
        }
        if (clz == Date.class) {
            return new DateProperty();
        }
        if (clz == LocalDateTime.class) {
            return new DateTimeProperty();
        }
        if (clz == String.class || clz.isEnum()) {
            return new StringProperty();
        }
        return null;
    }
}

