/*
 * Decompiled with CFR 0.152.
 */
package com.layjava.docs.javadoc.solon.impl;

import com.layjava.docs.javadoc.solon.impl.ActionHolder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.docs.DocDocket;

public class BuilderHelper {
    public static boolean isModel(Class<?> clz) {
        if (clz.isAnnotationPresent(ApiModel.class)) {
            return true;
        }
        if (clz.getName().startsWith("java")) {
            return false;
        }
        if (clz.isPrimitive() || clz.isEnum()) {
            return false;
        }
        return !Map.class.isAssignableFrom(clz) && !Collection.class.isAssignableFrom(clz);
    }

    public static String getModelName(Class<?> clazz, Type type) {
        Type[] typeArguments;
        String modelName = clazz.getSimpleName();
        if (type instanceof ParameterizedType && (typeArguments = ((ParameterizedType)type).getActualTypeArguments()) != null && typeArguments.length > 0) {
            StringBuilder buf = new StringBuilder();
            for (Type v : typeArguments) {
                ParameterizedType v2;
                Type v22;
                if (v instanceof Class) {
                    buf.append(((Class)v).getSimpleName()).append(",");
                }
                if (!(v instanceof ParameterizedType) || !((v22 = (v2 = (ParameterizedType)v).getRawType()) instanceof Class)) continue;
                String name2 = BuilderHelper.getModelName((Class)v22, v2);
                buf.append(name2).append(",");
            }
            if (buf.length() > 0) {
                buf.setLength(buf.length() - 1);
                modelName = modelName + "\u00ab" + buf + "\u00bb";
            }
        }
        return modelName;
    }

    public static String getHttpMethod(ActionHolder actionHolder, ApiOperation apiAction) {
        if (apiAction == null || Utils.isBlank((String)apiAction.httpMethod())) {
            MethodType methodType = actionHolder.routing().method();
            if (methodType == null) {
                return "get";
            }
            if (actionHolder.isGet()) {
                return "get";
            }
            if (methodType.ordinal() < MethodType.UNKNOWN.ordinal()) {
                return methodType.name.toLowerCase();
            }
            return "post";
        }
        return apiAction.httpMethod();
    }

    public static String getHost(DocDocket swaggerDock) {
        String host = swaggerDock.host();
        if (Utils.isBlank((String)host)) {
            host = "localhost";
            if (Solon.cfg().serverPort() != 80) {
                host = host + ":" + Solon.cfg().serverPort();
            }
        }
        return host;
    }

    public static String getControllerKey(Class<?> controllerClz) {
        Mapping mapping = controllerClz.getAnnotation(Mapping.class);
        if (mapping == null) {
            return "";
        }
        String path = Utils.annoAlias((String)mapping.value(), (String)mapping.path());
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }
}

