/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.noear.solon.Utils;

public class UnpooledDataSource
implements DataSource {
    private PrintWriter logWriter;
    private String url;
    private String username;
    private String password;
    private String driverClassName;

    public UnpooledDataSource(Properties props) {
        this.url = props.getProperty("url");
        if (Utils.isEmpty((String)this.url)) {
            this.url = props.getProperty("jdbcUrl");
        }
        if (Utils.isEmpty((String)this.url)) {
            throw new IllegalArgumentException("Invalid ds url parameter");
        }
        this.logWriter = new PrintWriter(System.out);
        this.username = props.getProperty("username");
        this.password = props.getProperty("password");
        this.driverClassName = props.getProperty("driverClassName");
        this.setDriverClassName(this.driverClassName);
    }

    public UnpooledDataSource(String url, String username, String password, String driverClassName) {
        if (Utils.isEmpty((String)url)) {
            throw new IllegalArgumentException("Invalid ds url parameter");
        }
        this.logWriter = new PrintWriter(System.out);
        this.url = url;
        this.username = username;
        this.password = password;
        this.driverClassName = driverClassName;
        this.setDriverClassName(driverClassName);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDriverClassName(String driverClassName) {
        if (driverClassName == null) {
            return;
        }
        try {
            this.driverClassName = driverClassName;
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("driverClassName", e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.username == null) {
            return DriverManager.getConnection(this.url);
        }
        return DriverManager.getConnection(this.url, this.username, this.password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return DriverManager.getConnection(this.url, username, password);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnpooledDataSource that = (UnpooledDataSource)o;
        return Objects.equals(this.url, that.url) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.username, this.password);
    }
}

