/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.tran;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.noear.solon.core.FactoryManager;
import org.noear.solon.data.datasource.RoutingDataSourceMapping;
import org.noear.solon.data.tran.impl.DbTran;

public final class TranManager {
    private static final Map<Class<?>, RoutingDataSourceMapping> DS_ROUTING = new HashMap();
    private static final ThreadLocal<DbTran> TL_TRAN = FactoryManager.getGlobal().newThreadLocal(TranManager.class, false);

    public static <T> void routing(Class<T> dsClz, RoutingDataSourceMapping<T> mapping) {
        DS_ROUTING.put(dsClz, mapping);
    }

    public static RoutingDataSourceMapping routingGet(DataSource original) {
        Class<?> originalClz = original.getClass();
        for (Map.Entry<Class<?>, RoutingDataSourceMapping> entry : DS_ROUTING.entrySet()) {
            if (!entry.getKey().isAssignableFrom(originalClz)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void currentSet(DbTran tran) {
        TL_TRAN.set(tran);
    }

    public static DbTran current() {
        return TL_TRAN.get();
    }

    public static void currentRemove() {
        TL_TRAN.remove();
    }

    public static DbTran trySuspend() {
        DbTran tran = TranManager.current();
        if (tran != null) {
            TranManager.currentRemove();
        }
        return tran;
    }

    public static void tryResume(DbTran tran) {
        if (tran != null) {
            TranManager.currentSet(tran);
        }
    }
}

