/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.datasource;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.sql.DataSource;
import org.noear.solon.Solon;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.VarHolder;
import org.noear.solon.data.annotation.Ds;
import org.noear.solon.data.datasource.DsInjectHandler;
import org.noear.solon.data.datasource.DsUtils;
import org.noear.solon.lang.Preview;

@Preview(value="3.2")
public class DsInjector<T extends Annotation>
implements BeanInjector<T> {
    private static final DsInjector<Ds> _default = new DsInjector<Ds>(Ds::value);
    protected final List<DsInjectHandler> handlers = new ArrayList<DsInjectHandler>();
    protected final Function<T, String> nameMapper;

    public static DsInjector<Ds> getDefault() {
        return _default;
    }

    public DsInjector(Function<T, String> nameMapper) {
        this.nameMapper = nameMapper;
    }

    public void addHandler(DsInjectHandler handler) {
        this.handlers.add(handler);
    }

    public void doInject(VarHolder vh, T anno) {
        vh.required(true);
        String annoValue = this.nameMapper.apply(anno);
        String name = Solon.cfg().getByTmpl(annoValue);
        DsUtils.observeDs(vh.context(), name, dsWrap -> this.doInjectHandle(vh, (BeanWrap)dsWrap));
    }

    protected void doInjectHandle(VarHolder vh, BeanWrap dsWrap) {
        for (DsInjectHandler handler : this.handlers) {
            handler.doHandle(vh, dsWrap);
            if (!vh.isDone()) continue;
            return;
        }
        if (DataSource.class.isAssignableFrom(vh.getType())) {
            vh.setValue(dsWrap.get());
            return;
        }
    }
}

