/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sql.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.noear.solon.Solon;
import org.noear.solon.data.sql.Row;
import org.noear.solon.data.sql.RowList;
import org.noear.solon.data.sql.SqlExecutor;
import org.noear.solon.data.sql.bound.RowConverter;
import org.noear.solon.data.sql.bound.RowIterator;
import org.noear.solon.data.sql.bound.StatementBinder;
import org.noear.solon.data.sql.impl.CommandHolder;
import org.noear.solon.data.sql.impl.DefaultBinder;
import org.noear.solon.data.sql.impl.DefaultConverter;
import org.noear.solon.data.sql.impl.MetaHolder;
import org.noear.solon.data.sql.impl.SimpleRow;
import org.noear.solon.data.sql.impl.SimpleRowIterator;
import org.noear.solon.data.sql.impl.SimpleRowList;
import org.noear.solon.data.tran.TranUtils;

public class SimpleSqlExecutor
implements SqlExecutor {
    private final DataSource dataSource;
    private final String sql;
    private final Object[] argsDef;
    private static final DefaultBinder binderDef = new DefaultBinder();

    public SimpleSqlExecutor(DataSource dataSource, String sql, Object[] args) {
        this.dataSource = dataSource;
        this.sql = sql;
        this.argsDef = args;
    }

    @Override
    public <T> T queryValue() throws SQLException {
        return (T)this.queryRow((ResultSet rs) -> rs.getObject(1));
    }

    @Override
    public <T> List<T> queryValueList() throws SQLException {
        return this.queryRowList((ResultSet rs) -> rs.getObject(1));
    }

    @Override
    public <T> T queryRow(Class<T> tClass) throws SQLException {
        return this.queryRow(DefaultConverter.getInstance().create(tClass));
    }

    @Override
    public <T> T queryRow(RowConverter<T> converter) throws SQLException {
        try (CommandHolder holder = this.buildCommand(this.sql, false, false);){
            binderDef.setValues(holder.stmt, this.argsDef);
            holder.rsts = holder.stmt.executeQuery();
            if (holder.rsts.next()) {
                T t = converter.convert(holder.rsts);
                return t;
            }
            T t = null;
            return t;
        }
    }

    @Override
    public <T> List<T> queryRowList(Class<T> tClass) throws SQLException {
        return this.queryRowList(DefaultConverter.getInstance().create(tClass));
    }

    @Override
    public <T> List<T> queryRowList(RowConverter<T> converter) throws SQLException {
        try (CommandHolder holder = this.buildCommand(this.sql, false, false);){
            binderDef.setValues(holder.stmt, this.argsDef);
            holder.rsts = holder.stmt.executeQuery();
            ArrayList<T> list = new ArrayList<T>();
            while (holder.rsts.next()) {
                list.add(converter.convert(holder.rsts));
            }
            ArrayList<T> arrayList = list.size() > 0 ? list : null;
            return arrayList;
        }
    }

    @Override
    public <T> RowIterator<T> queryRowIterator(int fetchSize, Class<T> tClass) throws SQLException {
        return this.queryRowIterator(fetchSize, DefaultConverter.getInstance().create(tClass));
    }

    @Override
    public <T> RowIterator<T> queryRowIterator(int fetchSize, RowConverter<T> converter) throws SQLException {
        CommandHolder holder = this.buildCommand(this.sql, false, true);
        binderDef.setValues(holder.stmt, this.argsDef);
        holder.stmt.setFetchSize(fetchSize);
        holder.rsts = holder.stmt.executeQuery();
        return new SimpleRowIterator<T>(holder, converter);
    }

    @Override
    public int update() throws SQLException {
        return this.update(this.argsDef, binderDef);
    }

    @Override
    public <S> int update(S args, StatementBinder<S> binder) throws SQLException {
        try (CommandHolder holder = this.buildCommand(this.sql, false, false);){
            binder.setValues(holder.stmt, args);
            int n = holder.stmt.executeUpdate();
            return n;
        }
    }

    @Override
    public int[] updateBatch(Collection<Object[]> argsList) throws SQLException {
        return this.updateBatch((Collection)argsList, (StatementBinder<T>)binderDef);
    }

    public <T> int[] updateBatch(Collection<T> argsList, StatementBinder<T> binder) throws SQLException {
        try (CommandHolder holder = this.buildCommand(this.sql, false, false);){
            for (T row : argsList) {
                binder.setValues(holder.stmt, row);
                holder.stmt.addBatch();
            }
            Object object = holder.stmt.executeBatch();
            return object;
        }
    }

    @Override
    public <T> T updateReturnKey() throws SQLException {
        return this.updateReturnKey(this.argsDef, binderDef);
    }

    @Override
    public <T, S> T updateReturnKey(S args, StatementBinder<S> binder) throws SQLException {
        try (CommandHolder holder = this.buildCommand(this.sql, true, false);){
            binder.setValues(holder.stmt, args);
            holder.stmt.executeUpdate();
            holder.rsts = holder.stmt.getGeneratedKeys();
            if (holder.rsts.next()) {
                Object object = holder.rsts.getObject(1);
                return (T)object;
            }
            T t = null;
            return t;
        }
    }

    protected CommandHolder buildCommand(String sql, boolean returnKeys, boolean isStream) throws SQLException {
        CommandHolder holder = new CommandHolder();
        holder.conn = this.getConnection();
        holder.stmt = isStream ? (sql.startsWith("{call") ? holder.conn.prepareCall(sql, 1003, 1007) : holder.conn.prepareStatement(sql, 1003, 1007)) : (returnKeys ? holder.conn.prepareStatement(sql, 1) : (sql.startsWith("{call") ? holder.conn.prepareCall(sql) : holder.conn.prepareStatement(sql)));
        return holder;
    }

    protected Connection getConnection() throws SQLException {
        if (Solon.app() == null) {
            return this.dataSource.getConnection();
        }
        return TranUtils.getConnectionProxy((DataSource)this.dataSource);
    }

    @Override
    @Deprecated
    public Row queryRow() throws SQLException {
        try (CommandHolder holder = this.buildCommand(this.sql, false, false);){
            binderDef.setValues(holder.stmt, this.argsDef);
            holder.rsts = holder.stmt.executeQuery();
            MetaHolder metaHolder = new MetaHolder(holder.rsts.getMetaData());
            if (holder.rsts.next()) {
                Object[] values = new Object[metaHolder.size];
                for (int i = 1; i <= values.length; ++i) {
                    values[i - 1] = holder.rsts.getObject(i);
                }
                SimpleRow simpleRow = new SimpleRow(metaHolder, values);
                return simpleRow;
            }
            Row row = null;
            return row;
        }
    }

    @Override
    @Deprecated
    public RowList queryRowList() throws SQLException {
        try (CommandHolder holder = this.buildCommand(this.sql, false, false);){
            binderDef.setValues(holder.stmt, this.argsDef);
            holder.rsts = holder.stmt.executeQuery();
            MetaHolder metaHolder = new MetaHolder(holder.rsts.getMetaData());
            SimpleRowList rowList = new SimpleRowList();
            while (holder.rsts.next()) {
                Object[] values = new Object[metaHolder.size];
                for (int i = 1; i <= values.length; ++i) {
                    values[i - 1] = holder.rsts.getObject(i);
                }
                SimpleRow row = new SimpleRow(metaHolder, values);
                rowList.add(row);
            }
            SimpleRowList simpleRowList = rowList.size() > 0 ? rowList : null;
            return simpleRowList;
        }
    }
}

