/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.dynamicds;

import org.noear.solon.core.util.RunnableEx;
import org.noear.solon.core.util.ScopeLocal;
import org.noear.solon.core.util.SupplierEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicDsKey {
    private static final Logger log = LoggerFactory.getLogger(DynamicDsKey.class);
    private static final ScopeLocal<String> LOCAL = ScopeLocal.newInstance(DynamicDsKey.class);

    public static void with(String name, RunnableEx runnable) throws Throwable {
        LOCAL.with((Object)name, () -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T with(String name, SupplierEx<T> supplier) throws Throwable {
        return (T)LOCAL.with((Object)name, () -> supplier.get());
    }

    public static String current() {
        return (String)LOCAL.get();
    }

    @Deprecated
    public static void remove() {
        log.warn("DynamicDsKey.remove will be removed, please use DynamicDsKey.with");
        LOCAL.remove();
    }

    @Deprecated
    public static void use(String name) {
        log.warn("DynamicDsKey.use will be removed, please use DynamicDsKey.with");
        if (name == null) {
            LOCAL.remove();
        } else {
            LOCAL.set((Object)name);
        }
    }

    @Deprecated
    public static String getCurrent() {
        return DynamicDsKey.current();
    }

    @Deprecated
    public static void setCurrent(String name) {
        DynamicDsKey.use(name);
    }
}

