/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.cache;

import java.lang.reflect.Type;
import org.noear.solon.Utils;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.util.SnelUtil;
import org.noear.solon.core.util.SupplierEx;
import org.noear.solon.data.annotation.Cache;
import org.noear.solon.data.annotation.CachePut;
import org.noear.solon.data.annotation.CacheRemove;
import org.noear.solon.data.cache.CacheLib;
import org.noear.solon.data.cache.CacheService;
import org.noear.solon.data.cache.CacheTags;
import org.noear.solon.data.util.InvKeys;
import org.noear.solon.data.util.StringMutexLock;

public class CacheExecutorImp {
    public static final CacheExecutorImp global = new CacheExecutorImp();
    private final StringMutexLock LOCK = new StringMutexLock();

    public Object cache(Cache anno, Invocation inv, SupplierEx executor) throws Throwable {
        Object result;
        if (anno == null) {
            return executor.get();
        }
        String key = anno.key();
        key = Utils.isEmpty((String)key) ? InvKeys.buildByInv(inv) : SnelUtil.evalTmpl((String)key, (Invocation)inv);
        CacheService cs = CacheLib.cacheServiceGet(anno.service());
        Type type = inv.method().getGenericReturnType();
        if (type == null) {
            type = inv.method().getReturnType();
        }
        if ((result = cs.get(key, type)) != null) {
            return result;
        }
        try (AutoCloseable entry = this.LOCK.lockEntry(key);){
            result = cs.get(key, type);
            if (result == null && (result = executor.get()) != null) {
                cs.store(key, result, anno.seconds());
                if (Utils.isNotEmpty((String)anno.tags())) {
                    String tags = SnelUtil.evalTmpl((String)anno.tags(), (Invocation)inv);
                    CacheTags ct = new CacheTags(cs);
                    for (String tag : tags.split(",")) {
                        ct.add(tag, key, anno.seconds());
                    }
                }
            }
            Object t = result;
            return t;
        }
    }

    public void cacheRemove(CacheRemove anno, Invocation inv, Object rstValue) {
        if (anno == null) {
            return;
        }
        CacheService cs = CacheLib.cacheServiceGet(anno.service());
        if (Utils.isNotEmpty((String)anno.keys())) {
            String keys = SnelUtil.evalTmpl((String)anno.keys(), (Invocation)inv);
            for (String key : keys.split(",")) {
                cs.remove(key);
            }
        }
        if (Utils.isNotEmpty((String)anno.tags())) {
            String tags = SnelUtil.evalTmpl((String)anno.tags(), (Invocation)inv);
            CacheTags ct = new CacheTags(cs);
            for (String tag : tags.split(",")) {
                ct.remove(tag);
            }
        }
    }

    public void cachePut(CachePut anno, Invocation inv, Object rstValue) {
        if (anno == null) {
            return;
        }
        CacheService cs = CacheLib.cacheServiceGet(anno.service());
        if (Utils.isNotEmpty((String)anno.key())) {
            String key = SnelUtil.evalTmpl((String)anno.key(), (Invocation)inv);
            cs.store(key, rstValue, anno.seconds());
        }
        if (Utils.isNotEmpty((String)anno.tags())) {
            String tags = SnelUtil.evalTmpl((String)anno.tags(), (Invocation)inv);
            CacheTags ct = new CacheTags(cs);
            for (String tag : tags.split(",")) {
                ct.update(tag, rstValue, anno.seconds());
            }
        }
    }
}

