/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.vertx.integration;

import io.vertx.core.Vertx;
import io.vertx.solon.VertxHolder;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.prop.impl.HttpServerProps;
import org.noear.solon.boot.prop.impl.WebSocketServerProps;
import org.noear.solon.boot.vertx.VxHttpServerComb;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.LogUtil;

public class VxHttpPlugin
implements Plugin {
    private static Signal _signal;
    private VxHttpServerComb _server;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "vertx-http/" + Solon.version();
    }

    public void start(AppContext context) throws Throwable {
        if (!context.app().enableHttp()) {
            return;
        }
        context.wrapAndPut(Vertx.class, (Object)VertxHolder.getVertx());
        context.lifecycle(99, () -> this.start0(context));
    }

    private void start0(AppContext context) throws Throwable {
        ServerProps.init();
        HttpServerProps props = new HttpServerProps();
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        long time_start = System.currentTimeMillis();
        this._server = new VxHttpServerComb(props, context);
        this._server.enableWebSocket(context.app().enableWebSocket());
        if (props.isIoBound()) {
            this._server.setExecutor(props.newWorkExecutor("vertxhttp-"));
        }
        this._server.setHandler(arg_0 -> ((SolonApp)context.app()).tryHandle(arg_0));
        EventBus.publish((Object)this._server);
        this._server.start(_host, _port);
        String _wrapHost = props.getWrapHost();
        int _wrapPort = props.getWrapPort();
        _signal = new SignalSim(_name, _wrapHost, _wrapPort, "http", SignalType.HTTP);
        context.app().signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        String connectorInfo = "solon.connector:main: vertx-http: Started ServerConnector@{HTTP/1.1,[http/1.1]";
        if (context.app().enableWebSocket()) {
            WebSocketServerProps wsProps = WebSocketServerProps.getInstance();
            if (Utils.isNotEmpty((String)wsProps.getName())) {
                SignalSim wsSignal = new SignalSim(wsProps.getName(), _wrapHost, _wrapPort, "ws", SignalType.WEBSOCKET);
                context.app().signalAdd((Signal)wsSignal);
            }
            String wsServerUrl = props.buildWsServerUrl(this._server.isSecure());
            LogUtil.global().info(connectorInfo + "[WebSocket]}{" + wsServerUrl + "}");
        }
        String httpServerUrl = props.buildHttpServerUrl(this._server.isSecure());
        LogUtil.global().info(connectorInfo + "}{" + httpServerUrl + "}");
        LogUtil.global().info("Server:main: vertx-http: Started (" + VxHttpPlugin.solon_boot_ver() + ") @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
        }
        VertxHolder.tryClose();
    }
}

