/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.util.Map;
import java.util.function.Supplier;
import org.smartboot.http.common.enums.HttpProtocolEnum;
import org.smartboot.http.server.impl.AbstractResponse;
import org.smartboot.http.server.impl.HttpOutputStream;
import org.smartboot.http.server.impl.HttpRequestImpl;

class HttpResponseImpl
extends AbstractResponse {
    private final HttpRequestImpl request;

    public HttpResponseImpl(HttpRequestImpl request) {
        this.init(request.request.getAioSession(), new HttpOutputStream(request, this));
        this.request = request;
    }

    @Override
    public void setTrailerFields(Supplier<Map<String, String>> supplier) {
        if (this.outputStream.isCommitted()) {
            throw new IllegalStateException();
        }
        if (this.request.getProtocol() == HttpProtocolEnum.HTTP_10) {
            throw new IllegalStateException("HTTP/1.0 request");
        }
        if (this.request.getProtocol() == HttpProtocolEnum.HTTP_11 && !this.outputStream.isChunkedSupport()) {
            throw new IllegalStateException("unSupport trailer");
        }
        this.outputStream.setTrailerFields(supplier);
    }
}

