/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.coder.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.noear.nami.Context;
import org.noear.nami.Decoder;
import org.noear.nami.Result;
import org.noear.nami.coder.kryo.KryoPool;

public class KryoDecoder
extends KryoPool
implements Decoder {
    public static final KryoDecoder instance = new KryoDecoder();

    public String enctype() {
        return "application/kryo";
    }

    /*
     * Loose catch block
     */
    public <T> T decode(Result rst, Type clz) {
        if (rst.body().length == 0) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(rst.body());
        Kryo tmp = this.obtain();
        try {
            Object object;
            try (Input input = new Input((InputStream)inputStream);){
                object = tmp.readClassAndObject(input);
            }
            return (T)object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.free(tmp);
        }
    }

    public void pretreatment(Context ctx) {
        ctx.headers.put("X-Serialization", "@kryo");
        ctx.headers.put("Accept", "application/kryo");
    }
}

