/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.coder.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class TimestampAdapter
implements JsonDeserializer<Date>,
JsonSerializer<Date> {
    private static final List<String> PATTERNS = Arrays.asList("yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss");

    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
        long seconds;
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
            String v = json.getAsString();
            for (String p : PATTERNS) {
                try {
                    return new SimpleDateFormat(p, Locale.CHINA).parse(v);
                }
                catch (ParseException ignore) {
                }
            }
            seconds = Long.parseLong(v);
        } else if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            seconds = json.getAsLong();
        } else {
            throw new JsonParseException("\u65f6\u95f4\u6233\u5fc5\u987b\u662f\u6570\u5b57\u6216\u7eaf\u6570\u5b57\u5b57\u7b26\u4e32\uff0c\u5f53\u524d=" + json);
        }
        return new Date(seconds);
    }

    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive((Number)src.getTime());
    }
}

