/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.coder.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.Date;
import org.noear.nami.Context;
import org.noear.nami.Decoder;
import org.noear.nami.EncoderTyped;
import org.noear.nami.Result;
import org.noear.nami.coder.gson.TimestampAdapter;
import org.noear.nami.exception.NamiDecodeException;
import org.noear.solon.Utils;

public class GsonDecoder
implements Decoder {
    public static final GsonDecoder instance = new GsonDecoder();
    private Gson gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new TimestampAdapter()).create();

    public String enctype() {
        return "application/json";
    }

    public <T> T decode(Result rst, Type type) throws Exception {
        if (rst.body().length == 0) {
            return null;
        }
        String str = rst.bodyAsString();
        if ("null".equals(str)) {
            return null;
        }
        try {
            if (str.contains("\"stackTrace\":[{")) {
                return (T)this.gson.fromJson(str, RuntimeException.class);
            }
            if (String.class == type && Utils.isNotEmpty((String)str) && str.charAt(0) != '\'' && str.charAt(0) != '\"') {
                return (T)str;
            }
            return (T)this.gson.fromJson(str, type);
        }
        catch (Throwable ex) {
            throw new NamiDecodeException("Decoding failure, type: " + type.getTypeName() + ", data: " + str, ex);
        }
    }

    public void pretreatment(Context ctx) {
        if (ctx.config.getEncoder() instanceof EncoderTyped) {
            ctx.headers.put("X-Serialization", "@json");
        }
        ctx.headers.put("Accept", "application/json");
    }
}

