/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.query.maker;

import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.join.query.JoinQueryBuilders;
import org.nlpcn.es4sql.domain.Condition;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.query.maker.Maker;

public class QueryMaker
extends Maker {
    public static BoolQueryBuilder explan(Where where) throws SqlParseException {
        return QueryMaker.explan(where, true);
    }

    public static BoolQueryBuilder explan(Where where, boolean isQuery) throws SqlParseException {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        while (where.getWheres().size() == 1) {
            where = where.getWheres().getFirst();
        }
        new QueryMaker().explanWhere(boolQuery, where);
        if (isQuery) {
            return boolQuery;
        }
        return QueryBuilders.boolQuery().filter((QueryBuilder)boolQuery);
    }

    private QueryMaker() {
        super(true);
    }

    private void explanWhere(BoolQueryBuilder boolQuery, Where where) throws SqlParseException {
        if (where instanceof Condition) {
            this.addSubQuery(boolQuery, where, (QueryBuilder)this.make((Condition)where));
        } else {
            BoolQueryBuilder subQuery = QueryBuilders.boolQuery();
            this.addSubQuery(boolQuery, where, (QueryBuilder)subQuery);
            for (Where subWhere : where.getWheres()) {
                this.explanWhere(subQuery, subWhere);
            }
        }
    }

    private void addSubQuery(BoolQueryBuilder boolQuery, Where where, QueryBuilder subQuery) {
        if (where instanceof Condition) {
            Condition condition = (Condition)where;
            if (condition.isNested()) {
                if ("missing".equalsIgnoreCase(String.valueOf(condition.getValue())) && (condition.getOpear() == Condition.OPEAR.IS || condition.getOpear() == Condition.OPEAR.EQ)) {
                    boolQuery.mustNot((QueryBuilder)QueryBuilders.nestedQuery((String)condition.getNestedPath(), (QueryBuilder)QueryBuilders.boolQuery().mustNot(subQuery), (ScoreMode)ScoreMode.None));
                    return;
                }
                subQuery = QueryBuilders.nestedQuery((String)condition.getNestedPath(), (QueryBuilder)subQuery, (ScoreMode)ScoreMode.None);
            } else if (condition.isChildren()) {
                subQuery = JoinQueryBuilders.hasChildQuery((String)condition.getChildType(), (QueryBuilder)subQuery, (ScoreMode)ScoreMode.None);
            }
        }
        if (where.getConn() == Where.CONN.AND) {
            boolQuery.must(subQuery);
        } else {
            boolQuery.should(subQuery);
        }
    }
}

