/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.parse;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlSelectGroupByExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nlpcn.es4sql.domain.Condition;
import org.nlpcn.es4sql.domain.Delete;
import org.nlpcn.es4sql.domain.Field;
import org.nlpcn.es4sql.domain.From;
import org.nlpcn.es4sql.domain.JoinSelect;
import org.nlpcn.es4sql.domain.Select;
import org.nlpcn.es4sql.domain.TableOnJoinSelect;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.domain.hints.Hint;
import org.nlpcn.es4sql.domain.hints.HintFactory;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.parse.FieldMaker;
import org.nlpcn.es4sql.parse.SQLParensIdentifierExpr;
import org.nlpcn.es4sql.parse.WhereParser;
import org.nlpcn.es4sql.query.multi.MultiQuerySelect;

public class SqlParser {
    public Select parseSelect(SQLQueryExpr mySqlExpr) throws SqlParseException {
        MySqlSelectQueryBlock query = (MySqlSelectQueryBlock)mySqlExpr.getSubQuery().getQuery();
        Select select = this.parseSelect(query);
        return select;
    }

    public Select parseSelect(MySqlSelectQueryBlock query) throws SqlParseException {
        Select select = new Select();
        WhereParser whereParser = new WhereParser(this, query);
        this.findSelect(query, select, query.getFrom().getAlias());
        select.getFrom().addAll(this.findFrom(query.getFrom()));
        select.setWhere(whereParser.findWhere());
        select.fillSubQueries();
        select.getHints().addAll(this.parseHints(query.getHints()));
        this.findLimit(query.getLimit(), select);
        this.findOrderBy(query, select);
        this.findGroupBy(query, select);
        return select;
    }

    public Delete parseDelete(SQLDeleteStatement deleteStatement) throws SqlParseException {
        Delete delete = new Delete();
        WhereParser whereParser = new WhereParser(this, deleteStatement);
        delete.getFrom().addAll(this.findFrom(deleteStatement.getTableSource()));
        delete.setWhere(whereParser.findWhere());
        return delete;
    }

    public MultiQuerySelect parseMultiSelect(SQLUnionQuery query) throws SqlParseException {
        Select firstTableSelect = this.parseSelect((MySqlSelectQueryBlock)query.getLeft());
        Select secondTableSelect = this.parseSelect((MySqlSelectQueryBlock)query.getRight());
        return new MultiQuerySelect(query.getOperator(), firstTableSelect, secondTableSelect);
    }

    private void findSelect(MySqlSelectQueryBlock query, Select select, String tableAlias) throws SqlParseException {
        List selectList = query.getSelectList();
        for (SQLSelectItem sqlSelectItem : selectList) {
            Field field = FieldMaker.makeField(sqlSelectItem.getExpr(), sqlSelectItem.getAlias(), tableAlias);
            select.addField(field);
        }
    }

    private void findGroupBy(MySqlSelectQueryBlock query, Select select) throws SqlParseException {
        SQLSelectGroupByClause groupBy = query.getGroupBy();
        SQLTableSource sqlTableSource = query.getFrom();
        if (groupBy == null) {
            return;
        }
        List items = groupBy.getItems();
        ArrayList<SQLExpr> standardGroupBys = new ArrayList<SQLExpr>();
        for (SQLExpr sqlExpr : items) {
            if (sqlExpr instanceof MySqlSelectGroupByExpr) {
                MySqlSelectGroupByExpr sqlSelectGroupByExpr = (MySqlSelectGroupByExpr)sqlExpr;
                sqlExpr = sqlSelectGroupByExpr.getExpr();
            }
            if ((sqlExpr instanceof SQLParensIdentifierExpr || !(sqlExpr instanceof SQLIdentifierExpr) && !(sqlExpr instanceof SQLMethodInvokeExpr)) && !standardGroupBys.isEmpty()) {
                select.addGroupBy(this.convertExprsToFields(standardGroupBys, sqlTableSource));
                standardGroupBys = new ArrayList();
            }
            if (sqlExpr instanceof SQLParensIdentifierExpr) {
                select.addGroupBy(FieldMaker.makeField(sqlExpr, null, sqlTableSource.getAlias()));
                continue;
            }
            if (sqlExpr instanceof SQLListExpr) {
                SQLListExpr listExpr = (SQLListExpr)sqlExpr;
                select.addGroupBy(this.convertExprsToFields(listExpr.getItems(), sqlTableSource));
                continue;
            }
            standardGroupBys.add(sqlExpr);
        }
        if (!standardGroupBys.isEmpty()) {
            select.addGroupBy(this.convertExprsToFields(standardGroupBys, sqlTableSource));
        }
    }

    private List<Field> convertExprsToFields(List<? extends SQLExpr> exprs, SQLTableSource sqlTableSource) throws SqlParseException {
        ArrayList<Field> fields = new ArrayList<Field>(exprs.size());
        for (SQLExpr sQLExpr : exprs) {
            fields.add(FieldMaker.makeField(sQLExpr, null, sqlTableSource.getAlias()));
        }
        return fields;
    }

    private String sameAliasWhere(Where where, String ... aliases) throws SqlParseException {
        if (where == null) {
            return null;
        }
        if (where instanceof Condition) {
            Condition condition = (Condition)where;
            String fieldName = condition.getName();
            for (String alias : aliases) {
                String prefix = alias + ".";
                if (!fieldName.startsWith(prefix)) continue;
                return alias;
            }
            throw new SqlParseException(String.format("fieldName : %s on codition:%s does not contain alias", fieldName, condition.toString()));
        }
        ArrayList<String> sameAliases = new ArrayList<String>();
        if (where.getWheres() != null && where.getWheres().size() > 0) {
            for (Where innerWhere : where.getWheres()) {
                sameAliases.add(this.sameAliasWhere(innerWhere, aliases));
            }
        }
        if (sameAliases.contains(null)) {
            return null;
        }
        String firstAlias = (String)sameAliases.get(0);
        for (String alias : sameAliases) {
            if (alias.equals(firstAlias)) continue;
            return null;
        }
        return firstAlias;
    }

    private void findOrderBy(MySqlSelectQueryBlock query, Select select) throws SqlParseException {
        SQLOrderBy orderBy = query.getOrderBy();
        if (orderBy == null) {
            return;
        }
        List items = orderBy.getItems();
        this.addOrderByToSelect(select, items, null);
    }

    private void addOrderByToSelect(Select select, List<SQLSelectOrderByItem> items, String alias) throws SqlParseException {
        for (SQLSelectOrderByItem sqlSelectOrderByItem : items) {
            SQLExpr expr = sqlSelectOrderByItem.getExpr();
            Field f = FieldMaker.makeField(expr, null, null);
            String orderByName = f.toString();
            if (sqlSelectOrderByItem.getType() == null) {
                sqlSelectOrderByItem.setType(SQLOrderingSpecification.ASC);
            }
            String type = sqlSelectOrderByItem.getType().toString();
            orderByName = orderByName.replace("`", "");
            if (alias != null) {
                orderByName = orderByName.replaceFirst(alias + "\\.", "");
            }
            select.addOrderBy(f.getNestedPath(), orderByName, type);
        }
    }

    private void findLimit(MySqlSelectQueryBlock.Limit limit, Select select) {
        if (limit == null) {
            return;
        }
        select.setRowCount(Integer.parseInt(limit.getRowCount().toString()));
        if (limit.getOffset() != null) {
            select.setOffset(Integer.parseInt(limit.getOffset().toString()));
        }
    }

    private List<From> findFrom(SQLTableSource from) {
        boolean isSqlExprTable = from.getClass().isAssignableFrom(SQLExprTableSource.class);
        if (isSqlExprTable) {
            SQLExprTableSource fromExpr = (SQLExprTableSource)from;
            String[] split = fromExpr.getExpr().toString().split(",");
            ArrayList<From> fromList = new ArrayList<From>();
            for (String source : split) {
                fromList.add(new From(source.trim(), fromExpr.getAlias()));
            }
            return fromList;
        }
        SQLJoinTableSource joinTableSource = (SQLJoinTableSource)from;
        ArrayList<From> fromList = new ArrayList<From>();
        fromList.addAll(this.findFrom(joinTableSource.getLeft()));
        fromList.addAll(this.findFrom(joinTableSource.getRight()));
        return fromList;
    }

    public JoinSelect parseJoinSelect(SQLQueryExpr sqlExpr) throws SqlParseException {
        MySqlSelectQueryBlock query = (MySqlSelectQueryBlock)sqlExpr.getSubQuery().getQuery();
        List<From> joinedFrom = this.findJoinedFrom(query.getFrom());
        if (joinedFrom.size() != 2) {
            throw new RuntimeException("currently supports only 2 tables join");
        }
        JoinSelect joinSelect = this.createBasicJoinSelectAccordingToTableSource((SQLJoinTableSource)query.getFrom());
        List<Hint> hints = this.parseHints(query.getHints());
        joinSelect.setHints(hints);
        String firstTableAlias = joinedFrom.get(0).getAlias();
        String secondTableAlias = joinedFrom.get(1).getAlias();
        Map<String, Where> aliasToWhere = this.splitAndFindWhere(query.getWhere(), firstTableAlias, secondTableAlias);
        Map<String, List<SQLSelectOrderByItem>> aliasToOrderBy = this.splitAndFindOrder(query.getOrderBy(), firstTableAlias, secondTableAlias);
        List<Condition> connectedConditions = this.getConditionsFlatten(joinSelect.getConnectedWhere());
        joinSelect.setConnectedConditions(connectedConditions);
        this.fillTableSelectedJoin(joinSelect.getFirstTable(), query, joinedFrom.get(0), aliasToWhere.get(firstTableAlias), aliasToOrderBy.get(firstTableAlias), connectedConditions);
        this.fillTableSelectedJoin(joinSelect.getSecondTable(), query, joinedFrom.get(1), aliasToWhere.get(secondTableAlias), aliasToOrderBy.get(secondTableAlias), connectedConditions);
        this.updateJoinLimit(query.getLimit(), joinSelect);
        return joinSelect;
    }

    private Map<String, List<SQLSelectOrderByItem>> splitAndFindOrder(SQLOrderBy orderBy, String firstTableAlias, String secondTableAlias) throws SqlParseException {
        HashMap<String, List<SQLSelectOrderByItem>> aliasToOrderBys = new HashMap<String, List<SQLSelectOrderByItem>>();
        aliasToOrderBys.put(firstTableAlias, new ArrayList());
        aliasToOrderBys.put(secondTableAlias, new ArrayList());
        if (orderBy == null) {
            return aliasToOrderBys;
        }
        List orderByItems = orderBy.getItems();
        for (SQLSelectOrderByItem orderByItem : orderByItems) {
            if (orderByItem.getExpr().toString().startsWith(firstTableAlias + ".")) {
                ((List)aliasToOrderBys.get(firstTableAlias)).add(orderByItem);
                continue;
            }
            if (orderByItem.getExpr().toString().startsWith(secondTableAlias + ".")) {
                ((List)aliasToOrderBys.get(secondTableAlias)).add(orderByItem);
                continue;
            }
            throw new SqlParseException("order by field on join request should have alias before, got " + orderByItem.getExpr().toString());
        }
        return aliasToOrderBys;
    }

    private void updateJoinLimit(MySqlSelectQueryBlock.Limit limit, JoinSelect joinSelect) {
        if (limit != null && limit.getRowCount() != null) {
            int sizeLimit = Integer.parseInt(limit.getRowCount().toString());
            joinSelect.setTotalLimit(sizeLimit);
        }
    }

    private List<Hint> parseHints(List<SQLCommentHint> sqlHints) throws SqlParseException {
        ArrayList<Hint> hints = new ArrayList<Hint>();
        for (SQLCommentHint sqlHint : sqlHints) {
            Hint hint = HintFactory.getHintFromString(sqlHint.getText());
            if (hint == null) continue;
            hints.add(hint);
        }
        return hints;
    }

    private JoinSelect createBasicJoinSelectAccordingToTableSource(SQLJoinTableSource joinTableSource) throws SqlParseException {
        JoinSelect joinSelect = new JoinSelect();
        if (joinTableSource.getCondition() != null) {
            Where where = Where.newInstance();
            WhereParser whereParser = new WhereParser(this, joinTableSource.getCondition());
            whereParser.parseWhere(joinTableSource.getCondition(), where);
            joinSelect.setConnectedWhere(where);
        }
        SQLJoinTableSource.JoinType joinType = joinTableSource.getJoinType();
        joinSelect.setJoinType(joinType);
        return joinSelect;
    }

    private Map<String, Where> splitAndFindWhere(SQLExpr whereExpr, String firstTableAlias, String secondTableAlias) throws SqlParseException {
        WhereParser whereParser = new WhereParser(this, whereExpr);
        Where where = whereParser.findWhere();
        return this.splitWheres(where, firstTableAlias, secondTableAlias);
    }

    private void fillTableSelectedJoin(TableOnJoinSelect tableOnJoin, MySqlSelectQueryBlock query, From tableFrom, Where where, List<SQLSelectOrderByItem> orderBys, List<Condition> conditions) throws SqlParseException {
        String alias = tableFrom.getAlias();
        this.fillBasicTableSelectJoin(tableOnJoin, tableFrom, where, orderBys, query);
        tableOnJoin.setConnectedFields(this.getConnectedFields(conditions, alias));
        tableOnJoin.setSelectedFields(new ArrayList<Field>(tableOnJoin.getFields()));
        tableOnJoin.setAlias(alias);
        tableOnJoin.fillSubQueries();
    }

    private List<Field> getConnectedFields(List<Condition> conditions, String alias) throws SqlParseException {
        ArrayList<Field> fields = new ArrayList<Field>();
        String prefix = alias + ".";
        for (Condition condition : conditions) {
            int indexOfDot;
            if (condition.getName().startsWith(prefix)) {
                fields.add(new Field(condition.getName().replaceFirst(prefix, ""), null));
                continue;
            }
            if (!(condition.getValue() instanceof SQLPropertyExpr || condition.getValue() instanceof SQLIdentifierExpr || condition.getValue() instanceof String)) {
                throw new SqlParseException("conditions on join should be one side is firstTable second Other , condition was:" + condition.toString());
            }
            String aliasDotValue = condition.getValue().toString();
            String owner = aliasDotValue.substring(0, indexOfDot = aliasDotValue.indexOf("."));
            if (!owner.equals(alias)) continue;
            fields.add(new Field(aliasDotValue.substring(indexOfDot + 1), null));
        }
        return fields;
    }

    private void fillBasicTableSelectJoin(TableOnJoinSelect select, From from, Where where, List<SQLSelectOrderByItem> orderBys, MySqlSelectQueryBlock query) throws SqlParseException {
        select.getFrom().add(from);
        this.findSelect(query, select, from.getAlias());
        select.setWhere(where);
        this.addOrderByToSelect(select, orderBys, from.getAlias());
    }

    private List<Condition> getJoinConditionsFlatten(SQLJoinTableSource from) throws SqlParseException {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (from.getCondition() == null) {
            return conditions;
        }
        Where where = Where.newInstance();
        WhereParser whereParser = new WhereParser(this, from.getCondition());
        whereParser.parseWhere(from.getCondition(), where);
        this.addIfConditionRecursive(where, conditions);
        return conditions;
    }

    private List<Condition> getConditionsFlatten(Where where) throws SqlParseException {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (where == null) {
            return conditions;
        }
        this.addIfConditionRecursive(where, conditions);
        return conditions;
    }

    private Map<String, Where> splitWheres(Where where, String ... aliases) throws SqlParseException {
        HashMap<String, Where> aliasToWhere = new HashMap<String, Where>();
        for (String alias : aliases) {
            aliasToWhere.put(alias, null);
        }
        if (where == null) {
            return aliasToWhere;
        }
        String allWhereFromSameAlias = this.sameAliasWhere(where, aliases);
        if (allWhereFromSameAlias != null) {
            this.removeAliasPrefix(where, allWhereFromSameAlias);
            aliasToWhere.put(allWhereFromSameAlias, where);
            return aliasToWhere;
        }
        for (Where innerWhere : where.getWheres()) {
            String sameAlias = this.sameAliasWhere(innerWhere, aliases);
            if (sameAlias == null) {
                throw new SqlParseException("Currently support only one hierarchy on different tables where");
            }
            this.removeAliasPrefix(innerWhere, sameAlias);
            Where aliasCurrentWhere = (Where)aliasToWhere.get(sameAlias);
            if (aliasCurrentWhere == null) {
                aliasToWhere.put(sameAlias, innerWhere);
                continue;
            }
            Where andWhereContainer = Where.newInstance();
            andWhereContainer.addWhere(aliasCurrentWhere);
            andWhereContainer.addWhere(innerWhere);
            aliasToWhere.put(sameAlias, andWhereContainer);
        }
        return aliasToWhere;
    }

    private void removeAliasPrefix(Where where, String alias) {
        if (where instanceof Condition) {
            Condition cond = (Condition)where;
            String fieldName = cond.getName();
            String aliasPrefix = alias + ".";
            cond.setName(cond.getName().replaceFirst(aliasPrefix, ""));
            return;
        }
        for (Where innerWhere : where.getWheres()) {
            this.removeAliasPrefix(innerWhere, alias);
        }
    }

    private void addIfConditionRecursive(Where where, List<Condition> conditions) throws SqlParseException {
        if (where instanceof Condition) {
            Condition cond = (Condition)where;
            if (!(cond.getValue() instanceof SQLIdentifierExpr || cond.getValue() instanceof SQLPropertyExpr || cond.getValue() instanceof String)) {
                throw new SqlParseException("conditions on join should be one side is secondTable OPEAR firstTable, condition was:" + cond.toString());
            }
            conditions.add(cond);
        }
        for (Where innerWhere : where.getWheres()) {
            this.addIfConditionRecursive(innerWhere, conditions);
        }
    }

    private List<From> findJoinedFrom(SQLTableSource from) {
        SQLJoinTableSource joinTableSource = (SQLJoinTableSource)from;
        ArrayList<From> fromList = new ArrayList<From>();
        fromList.addAll(this.findFrom(joinTableSource.getLeft()));
        fromList.addAll(this.findFrom(joinTableSource.getRight()));
        return fromList;
    }
}

