/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.nlpcn;

import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.plugin.nlpcn.ElasticJoinExecutor;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.nlpcn.es4sql.domain.Condition;
import org.nlpcn.es4sql.domain.Select;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.query.DefaultQueryAction;
import org.nlpcn.es4sql.query.join.NestedLoopsElasticRequestBuilder;
import org.nlpcn.es4sql.query.join.TableInJoinRequestBuilder;

public class NestedLoopsElasticExecutor
extends ElasticJoinExecutor {
    private final NestedLoopsElasticRequestBuilder nestedLoopsRequest;
    private final Client client;

    public NestedLoopsElasticExecutor(Client client, NestedLoopsElasticRequestBuilder nestedLoops) {
        super(nestedLoops);
        this.client = client;
        this.nestedLoopsRequest = nestedLoops;
    }

    @Override
    protected List<SearchHit> innerRun() throws SqlParseException {
        ArrayList<SearchHit> combinedResults = new ArrayList<SearchHit>();
        int totalLimit = this.nestedLoopsRequest.getTotalLimit();
        int multiSearchMaxSize = this.nestedLoopsRequest.getMultiSearchMaxSize();
        Select secondTableSelect = this.nestedLoopsRequest.getSecondTable().getOriginalSelect();
        Where originalSecondTableWhere = secondTableSelect.getWhere();
        this.orderConditions(this.nestedLoopsRequest.getFirstTable().getAlias(), this.nestedLoopsRequest.getSecondTable().getAlias());
        FetchWithScrollResponse fetchWithScrollResponse = this.firstFetch(this.nestedLoopsRequest.getFirstTable());
        SearchResponse firstTableResponse = fetchWithScrollResponse.getResponse();
        boolean needScrollForFirstTable = fetchWithScrollResponse.isNeedScrollForFirstTable();
        int currentCombinedResults = 0;
        boolean finishedWithFirstTable = false;
        while (totalLimit > currentCombinedResults && !finishedWithFirstTable) {
            SearchHit[] hits = firstTableResponse.getHits().getHits();
            boolean finishedMultiSearches = hits.length == 0;
            int currentHitsIndex = 0;
            while (!finishedMultiSearches) {
                MultiSearchRequest multiSearchRequest = this.createMultiSearchRequest(multiSearchMaxSize, this.nestedLoopsRequest.getConnectedWhere(), hits, secondTableSelect, originalSecondTableWhere, currentHitsIndex);
                int multiSearchSize = multiSearchRequest.requests().size();
                currentCombinedResults = this.combineResultsFromMultiResponses(combinedResults, totalLimit, currentCombinedResults, hits, currentHitsIndex, multiSearchRequest);
                finishedMultiSearches = (currentHitsIndex += multiSearchSize) >= hits.length - 1 || currentCombinedResults >= totalLimit;
            }
            if (hits.length < 10000) {
                needScrollForFirstTable = false;
            }
            if (finishedWithFirstTable) continue;
            if (needScrollForFirstTable) {
                firstTableResponse = (SearchResponse)this.client.prepareSearchScroll(firstTableResponse.getScrollId()).setScroll(new TimeValue(600000L)).get();
                continue;
            }
            finishedWithFirstTable = true;
        }
        return combinedResults;
    }

    private int combineResultsFromMultiResponses(List<SearchHit> combinedResults, int totalLimit, int currentCombinedResults, SearchHit[] hits, int currentIndex, MultiSearchRequest multiSearchRequest) {
        MultiSearchResponse.Item[] responses = ((MultiSearchResponse)this.client.multiSearch(multiSearchRequest).actionGet()).getResponses();
        String t1Alias = this.nestedLoopsRequest.getFirstTable().getAlias();
        String t2Alias = this.nestedLoopsRequest.getSecondTable().getAlias();
        for (int j = 0; j < responses.length && currentCombinedResults < totalLimit; ++j) {
            SearchHit hitFromFirstTable = hits[currentIndex + j];
            this.onlyReturnedFields(hitFromFirstTable.getSourceAsMap(), this.nestedLoopsRequest.getFirstTable().getReturnedFields(), this.nestedLoopsRequest.getFirstTable().getOriginalSelect().isSelectAll());
            SearchResponse multiItemResponse = responses[j].getResponse();
            this.updateMetaSearchResults(multiItemResponse);
            SearchHits responseForHit = multiItemResponse.getHits();
            if (responseForHit.getHits().length == 0 && this.nestedLoopsRequest.getJoinType() == SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN) {
                SearchHit unmachedResult = this.createUnmachedResult(this.nestedLoopsRequest.getSecondTable().getReturnedFields(), currentCombinedResults, t1Alias, t2Alias, hitFromFirstTable);
                combinedResults.add(unmachedResult);
                ++currentCombinedResults;
                continue;
            }
            for (SearchHit matchedHit : responseForHit.getHits()) {
                SearchHit searchHit = this.getMergedHit(currentCombinedResults, t1Alias, t2Alias, hitFromFirstTable, matchedHit);
                combinedResults.add(searchHit);
                if (++currentCombinedResults >= totalLimit) break;
            }
            if (currentCombinedResults >= totalLimit) break;
        }
        return currentCombinedResults;
    }

    private SearchHit getMergedHit(int currentCombinedResults, String t1Alias, String t2Alias, SearchHit hitFromFirstTable, SearchHit matchedHit) {
        this.onlyReturnedFields(matchedHit.getSourceAsMap(), this.nestedLoopsRequest.getSecondTable().getReturnedFields(), this.nestedLoopsRequest.getSecondTable().getOriginalSelect().isSelectAll());
        SearchHit searchHit = new SearchHit(currentCombinedResults, hitFromFirstTable.getId() + "|" + matchedHit.getId(), new Text(hitFromFirstTable.getType() + "|" + matchedHit.getType()), hitFromFirstTable.getFields());
        searchHit.sourceRef(hitFromFirstTable.getSourceRef());
        searchHit.getSourceAsMap().clear();
        searchHit.getSourceAsMap().putAll(hitFromFirstTable.getSourceAsMap());
        this.mergeSourceAndAddAliases(matchedHit.getSourceAsMap(), searchHit, t1Alias, t2Alias);
        return searchHit;
    }

    private MultiSearchRequest createMultiSearchRequest(int multiSearchMaxSize, Where connectedWhere, SearchHit[] hits, Select secondTableSelect, Where originalWhere, int currentIndex) throws SqlParseException {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        for (int i = currentIndex; i < currentIndex + multiSearchMaxSize && i < hits.length; ++i) {
            Map hitFromFirstTableAsMap = hits[i].getSourceAsMap();
            Where newWhere = Where.newInstance();
            if (originalWhere != null) {
                newWhere.addWhere(originalWhere);
            }
            if (connectedWhere != null) {
                Where connectedWhereCloned = null;
                try {
                    connectedWhereCloned = (Where)connectedWhere.clone();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                this.updateValuesOnWhereConditions(hitFromFirstTableAsMap, connectedWhereCloned);
                newWhere.addWhere(connectedWhereCloned);
            }
            if (newWhere.getWheres().size() != 0) {
                secondTableSelect.setWhere(newWhere);
            }
            DefaultQueryAction action = new DefaultQueryAction(this.client, secondTableSelect);
            action.explain();
            SearchRequestBuilder secondTableRequest = action.getRequestBuilder();
            Integer secondTableHintLimit = this.nestedLoopsRequest.getSecondTable().getHintLimit();
            if (secondTableHintLimit != null && secondTableHintLimit <= 10000) {
                secondTableRequest.setSize(secondTableHintLimit.intValue());
            }
            multiSearchRequest.add(secondTableRequest);
        }
        return multiSearchRequest;
    }

    private void updateValuesOnWhereConditions(Map<String, Object> hit, Where where) {
        if (where instanceof Condition) {
            Condition c = (Condition)where;
            Object value = this.deepSearchInMap(hit, c.getValue().toString());
            c.setValue(value);
        }
        for (Where innerWhere : where.getWheres()) {
            this.updateValuesOnWhereConditions(hit, innerWhere);
        }
    }

    private FetchWithScrollResponse firstFetch(TableInJoinRequestBuilder tableRequest) {
        SearchResponse responseWithHits;
        Integer hintLimit = tableRequest.getHintLimit();
        boolean needScrollForFirstTable = false;
        if (hintLimit != null && hintLimit < 10000) {
            responseWithHits = (SearchResponse)tableRequest.getRequestBuilder().setSize(hintLimit.intValue()).get();
            needScrollForFirstTable = false;
        } else {
            responseWithHits = this.scrollOneTimeWithMax(this.client, tableRequest);
            if (responseWithHits.getHits().getTotalHits() < 10000L) {
                needScrollForFirstTable = true;
            }
        }
        this.updateMetaSearchResults(responseWithHits);
        return new FetchWithScrollResponse(responseWithHits, needScrollForFirstTable);
    }

    private void orderConditions(String t1Alias, String t2Alias) {
        this.orderConditionRecursive(t1Alias, t2Alias, this.nestedLoopsRequest.getConnectedWhere());
    }

    private void orderConditionRecursive(String t1Alias, String t2Alias, Where where) {
        if (where == null) {
            return;
        }
        if (where instanceof Condition) {
            Condition c = (Condition)where;
            if (!c.getName().startsWith(t2Alias + ".") || !c.getValue().toString().startsWith(t1Alias + ".")) {
                throw new RuntimeException("On NestedLoops currently only supported Ordered conditions (t2.field2 OPEAR t1.field1) , badCondition was:" + c);
            }
            c.setName(c.getName().replaceFirst(t2Alias + ".", ""));
            c.setValue(c.getValue().toString().replaceFirst(t1Alias + ".", ""));
            return;
        }
        for (Where innerWhere : where.getWheres()) {
            this.orderConditionRecursive(t1Alias, t2Alias, innerWhere);
        }
    }

    private class FetchWithScrollResponse {
        private SearchResponse response;
        private boolean needScrollForFirstTable;

        private FetchWithScrollResponse(SearchResponse response, boolean needScrollForFirstTable) {
            this.response = response;
            this.needScrollForFirstTable = needScrollForFirstTable;
        }

        public SearchResponse getResponse() {
            return this.response;
        }

        public boolean isNeedScrollForFirstTable() {
            return this.needScrollForFirstTable;
        }
    }
}

