/*
 * Decompiled with CFR 0.152.
 */
package ninja.ebean;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.ebean.EbeanServer;
import io.ebean.EbeanServerFactory;
import io.ebean.config.ServerConfig;
import io.ebean.datasource.DataSourceConfig;
import io.ebeaninternal.server.lib.ShutdownManager;
import java.util.LinkedHashSet;
import java.util.Set;
import ninja.ebean.ReflectionsHelper;
import ninja.utils.NinjaProperties;
import org.slf4j.Logger;

@Singleton
public class NinjaEbeanServerLifecycle {
    private EbeanServer ebeanServer;
    private final NinjaProperties ninjaProperties;
    private final Logger logger;

    @Inject
    public NinjaEbeanServerLifecycle(Logger logger, NinjaProperties ninjaProperties) {
        this.logger = logger;
        this.ninjaProperties = ninjaProperties;
        this.startServer();
    }

    public final void startServer() {
        this.logger.info("Starting Ebeans Module.");
        boolean ebeanDdlGenerate = this.ninjaProperties.getBooleanWithDefault("ebean.ddl.generate", Boolean.valueOf(false));
        boolean ebeanDdlRun = this.ninjaProperties.getBooleanWithDefault("ebean.ddl.run", Boolean.valueOf(false));
        String ebeanDdlInitSql = this.ninjaProperties.get("ebean.ddl.initSql");
        String ebeanDdlSeedSql = this.ninjaProperties.get("ebean.ddl.seedSql");
        String ebeanDatasourceName = this.ninjaProperties.getWithDefault("ebean.datasource.name", "default");
        String ebeanDatasourceUserName = this.ninjaProperties.getWithDefault("ebean.datasource.username", "test");
        String ebeanDatasourcePassword = this.ninjaProperties.getWithDefault("ebean.datasource.password", "test");
        String ebeanDatasourceDatabaseUrl = this.ninjaProperties.getWithDefault("ebean.datasource.databaseUrl", "jdbc:h2:mem:tests;DB_CLOSE_DELAY=-1");
        String ebeanDatasourceDatabaseDriver = this.ninjaProperties.getWithDefault("ebean.datasource.databaseDriver", "org.h2.Driver");
        int ebeanDatasourceMinConnections = this.ninjaProperties.getIntegerWithDefault("ebean.datasource.minConnections", Integer.valueOf(1));
        int ebeanDatasourceMaxConnections = this.ninjaProperties.getIntegerWithDefault("ebean.datasource.maxConnections", Integer.valueOf(25));
        String ebeanDatasourceHeartbeatSql = this.ninjaProperties.getWithDefault("ebean.datasource.heartbeatsql", "select 1");
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.setName(ebeanDatasourceName);
        serverConfig.loadFromProperties();
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setDriver(ebeanDatasourceDatabaseDriver);
        dataSourceConfig.setUsername(ebeanDatasourceUserName);
        dataSourceConfig.setPassword(ebeanDatasourcePassword);
        dataSourceConfig.setUrl(ebeanDatasourceDatabaseUrl);
        dataSourceConfig.setMinConnections(ebeanDatasourceMinConnections);
        dataSourceConfig.setMaxConnections(ebeanDatasourceMaxConnections);
        dataSourceConfig.setHeartbeatSql(ebeanDatasourceHeartbeatSql);
        serverConfig.setDataSourceConfig(dataSourceConfig);
        serverConfig.setDdlGenerate(ebeanDdlGenerate);
        serverConfig.setDdlRun(ebeanDdlRun);
        serverConfig.setDdlInitSql(ebeanDdlInitSql);
        serverConfig.setDdlSeedSql(ebeanDdlSeedSql);
        serverConfig.setDefaultServer(true);
        serverConfig.setRegister(true);
        LinkedHashSet<String> packageNames = new LinkedHashSet<String>();
        LinkedHashSet entityClasses = new LinkedHashSet();
        packageNames.add("models");
        String[] manuallyListedModels = this.ninjaProperties.getStringArray("ebean.models");
        if (manuallyListedModels != null) {
            for (String model : manuallyListedModels) {
                if (model.endsWith(".*")) {
                    String packageName = model.substring(0, model.length() - 2);
                    packageNames.add(packageName);
                    continue;
                }
                try {
                    entityClasses.add(Class.forName(model));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Configuration error. Class listed/discovered via ebean.models not found: " + (String)model);
                }
            }
        }
        if (!packageNames.isEmpty()) {
            for (String string : packageNames) {
                Set<String> packageClasses = ReflectionsHelper.findAllClassesInPackage(string);
                this.logger.info("Searched and found " + packageClasses.size() + " classes in package " + string);
                for (String packageClass : packageClasses) {
                    try {
                        entityClasses.add(Class.forName(packageClass));
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Something fishy happenend. Unable to find class " + packageClass);
                    }
                }
            }
        }
        for (Class clazz : entityClasses) {
            serverConfig.addClass(clazz);
        }
        this.ebeanServer = this.createEbeanServer(serverConfig);
        ShutdownManager.touch();
    }

    public EbeanServer createEbeanServer(ServerConfig serverConfig) {
        return EbeanServerFactory.create((ServerConfig)serverConfig);
    }

    public EbeanServer getEbeanServer() {
        return this.ebeanServer;
    }
}

