/*
 * Decompiled with CFR 0.152.
 */
package ninja.ebean;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.EbeanServerFactory;
import com.avaje.ebean.config.DataSourceConfig;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebeaninternal.server.lib.ShutdownManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.logging.Logger;
import ninja.lifecycle.Dispose;
import ninja.utils.NinjaProperties;

@Singleton
public class NinjaEbeanServerLifecycle {
    private EbeanServer ebeanServer;
    private final NinjaProperties ninjaProperties;
    private final Logger logger;

    @Inject
    public NinjaEbeanServerLifecycle(Logger logger, NinjaProperties ninjaProperties) {
        this.logger = logger;
        this.ninjaProperties = ninjaProperties;
        this.startServer();
    }

    public void startServer() {
        this.logger.info("Starting Ebeans Module.");
        boolean ebeanDdlGenerate = this.ninjaProperties.getBooleanWithDefault("ebean.ddl.generate", Boolean.valueOf(true));
        boolean ebeanDdlRun = this.ninjaProperties.getBooleanWithDefault("ebean.ddl.run", Boolean.valueOf(true));
        String ebeanDatasourceName = this.ninjaProperties.getWithDefault("ebean.datasource.name", "default");
        String ebeanDatasourceUserName = this.ninjaProperties.getWithDefault("ebean.datasource.username", "test");
        String ebeanDatasourcePassword = this.ninjaProperties.getWithDefault("ebean.datasource.password", "test");
        String ebeanDatasourceDatabaseUrl = this.ninjaProperties.getWithDefault("ebean.datasource.databaseUrl", "jdbc:h2:mem:tests;DB_CLOSE_DELAY=-1");
        String ebeanDatasourceDatabaseDriver = this.ninjaProperties.getWithDefault("ebean.datasource.databaseDriver", "org.h2.Driver");
        int ebeanDatasourceMinConnections = this.ninjaProperties.getIntegerWithDefault("ebean.datasource.minConnections", Integer.valueOf(1));
        int ebeanDatasourceMaxConnections = this.ninjaProperties.getIntegerWithDefault("ebean.datasource.maxConnections", Integer.valueOf(25));
        String ebeanDatasourceHeartbeatSql = this.ninjaProperties.getWithDefault("ebean.datasource.heartbeatsql", "select 1");
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.setName(ebeanDatasourceName);
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setDriver(ebeanDatasourceDatabaseDriver);
        dataSourceConfig.setUsername(ebeanDatasourceUserName);
        dataSourceConfig.setPassword(ebeanDatasourcePassword);
        dataSourceConfig.setUrl(ebeanDatasourceDatabaseUrl);
        dataSourceConfig.setMinConnections(ebeanDatasourceMinConnections);
        dataSourceConfig.setMaxConnections(ebeanDatasourceMaxConnections);
        dataSourceConfig.setHeartbeatSql(ebeanDatasourceHeartbeatSql);
        serverConfig.setDataSourceConfig(dataSourceConfig);
        serverConfig.setDdlGenerate(ebeanDdlGenerate);
        serverConfig.setDdlRun(ebeanDdlRun);
        serverConfig.setDefaultServer(true);
        serverConfig.setRegister(true);
        serverConfig.addPackage("models");
        String[] manuallyListedModels = this.ninjaProperties.getStringArray("ebean.models");
        if (manuallyListedModels != null) {
            for (String model : manuallyListedModels) {
                try {
                    serverConfig.addClass(Class.forName(model));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Configuration error. Class not listed in ebean.models not found: " + model);
                }
            }
        }
        this.ebeanServer = EbeanServerFactory.create((ServerConfig)serverConfig);
    }

    @Dispose
    public void stopServer() {
        this.logger.info("Stoppping Ebeans module.");
        ShutdownManager.shutdown();
    }

    public EbeanServer getEbeanServer() {
        return this.ebeanServer;
    }
}

