/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.ui.ContainerPanel;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class SectionContainer
extends JPanel
implements NodeSectionPanel,
ContainerPanel {
    private SectionView sectionView;
    private Node root;
    private boolean active;
    private int sectionCount = 0;
    private int index;
    private boolean foldable;
    private JPanel actionPanel;
    private JPanel contentPanel;
    private JSeparator fillerEnd;
    private JSeparator fillerLine;
    private JToggleButton foldButton;
    private JSeparator headerSeparator;
    private JButton titleButton;
    private JPanel titlePanel;
    private JButton[] headerButtons;

    public SectionContainer(SectionView sectionView, Node root, String title) {
        this(sectionView, root, title, true);
    }

    public SectionContainer(SectionView sectionView, Node root, String title, boolean foldable) {
        this.sectionView = sectionView;
        this.root = root;
        this.foldable = foldable;
        this.initComponents();
        this.headerSeparator.setForeground(SectionVisualTheme.getSectionHeaderLineColor());
        this.fillerLine.setForeground(SectionVisualTheme.getFoldLineColor());
        this.fillerEnd.setForeground(SectionVisualTheme.getFoldLineColor());
        Mnemonics.setLocalizedText((AbstractButton)this.titleButton, (String)title);
        this.titleButton.setToolTipText(this.titleButton.getText());
        this.titleButton.addMouseListener((MouseListener)new MouseUtils.PopupMouseAdapter(){

            protected void showPopup(MouseEvent e) {
                JPopupMenu popup = SectionContainer.this.getNode().getContextMenu();
                popup.show(SectionContainer.this.titleButton, e.getX(), e.getY());
            }
        });
        if (foldable) {
            this.foldButton.setSelected(true);
        } else {
            this.remove(this.fillerLine);
            this.remove(this.fillerEnd);
            this.remove(this.foldButton);
        }
        this.setIcon(true);
    }

    @Override
    public Node getNode() {
        return this.root;
    }

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Override
    public void open() {
        if (this.foldable) {
            this.foldButton.setSelected(true);
            this.contentPanel.setVisible(true);
            this.fillerLine.setVisible(true);
            this.fillerEnd.setVisible(true);
            this.setIcon(true);
        }
    }

    @Override
    public void scroll() {
        Utils.scrollToVisible(this);
    }

    @Override
    public void setActive(boolean active) {
        if (active && !this.equals(this.sectionView.getActivePanel())) {
            this.sectionView.sectionSelected(true);
            this.sectionView.setActivePanel(this);
            this.sectionView.selectNode(this.root);
        }
        this.active = active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    private void mapSection(Node key, NodeSectionPanel panel) {
        this.sectionView.mapSection(key, panel);
    }

    private void deleteSection(Node key) {
        this.sectionView.deleteSection(key);
    }

    @Override
    public NodeSectionPanel getSection(Node key) {
        return this.sectionView.getSection(key);
    }

    public void addSection(NodeSectionPanel section, boolean open) {
        this.addSection(section);
        if (open) {
            section.open();
            section.scroll();
            section.setActive(true);
        }
    }

    @Override
    public void addSection(NodeSectionPanel section) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.sectionCount;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.contentPanel.add((Component)((JPanel)((Object)section)), gridBagConstraints);
        section.setIndex(this.sectionCount);
        this.mapSection(section.getNode(), section);
        ++this.sectionCount;
    }

    @Override
    public void removeSection(NodeSectionPanel section) {
        NodeSectionPanel pan;
        int i;
        int panelIndex = section.getIndex();
        this.contentPanel.remove((JPanel)((Object)section));
        Component[] components = this.contentPanel.getComponents();
        ArrayList<NodeSectionPanel> removedPanels = new ArrayList<NodeSectionPanel>();
        for (i = 0; i < components.length; ++i) {
            int index;
            if (!(components[i] instanceof NodeSectionPanel) || (index = (pan = (NodeSectionPanel)((Object)components[i])).getIndex()) <= panelIndex) continue;
            this.contentPanel.remove((JPanel)((Object)pan));
            pan.setIndex(index - 1);
            removedPanels.add(pan);
        }
        for (i = 0; i < removedPanels.size(); ++i) {
            pan = (NodeSectionPanel)removedPanels.get(i);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = pan.getIndex();
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            this.contentPanel.add((Component)((JPanel)((Object)pan)), gridBagConstraints);
        }
        this.deleteSection(section.getNode());
        --this.sectionCount;
    }

    private void initComponents() {
        this.foldButton = new JToggleButton();
        this.headerSeparator = new JSeparator();
        this.contentPanel = new JPanel();
        this.actionPanel = new JPanel();
        this.fillerLine = new JSeparator();
        this.fillerEnd = new JSeparator();
        this.titlePanel = new JPanel();
        this.titleButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.foldButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/xml/multiview/resources/plus.gif")));
        this.foldButton.setToolTipText(NbBundle.getMessage(SectionContainer.class, (String)"HINT_FOLD_BUTTON"));
        this.foldButton.setBorder(null);
        this.foldButton.setBorderPainted(false);
        this.foldButton.setContentAreaFilled(false);
        this.foldButton.setFocusPainted(false);
        this.foldButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/xml/multiview/resources/minus.gif")));
        this.foldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SectionContainer.this.foldButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(6, 2, 0, 2);
        this.add((Component)this.foldButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.headerSeparator, gridBagConstraints);
        this.contentPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.contentPanel, gridBagConstraints);
        this.actionPanel.setLayout(new FlowLayout(2, 2, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.actionPanel, gridBagConstraints);
        this.fillerLine.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.fillerLine, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 6, 0, 2);
        this.add((Component)this.fillerEnd, gridBagConstraints);
        this.titlePanel.setLayout(new BorderLayout());
        this.titleButton.setFont(this.titleButton.getFont().deriveFont(this.titleButton.getFont().getStyle() | 1, this.titleButton.getFont().getSize() + 2));
        this.titleButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.titleButton.setBorderPainted(false);
        this.titleButton.setContentAreaFilled(false);
        this.titleButton.setFocusPainted(false);
        this.titleButton.setHorizontalAlignment(2);
        this.titleButton.setMargin(new Insets(0, 4, 0, 4));
        this.titleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SectionContainer.this.titleButtonActionPerformed(evt);
            }
        });
        this.titlePanel.add((Component)this.titleButton, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.titlePanel, gridBagConstraints);
    }

    private void titleButtonActionPerformed(ActionEvent evt) {
        if (this.foldable) {
            if (!this.foldButton.isSelected()) {
                this.open();
                this.foldButton.setSelected(true);
            } else if (this.isActive()) {
                this.foldButton.setSelected(false);
                this.contentPanel.setVisible(false);
                this.fillerLine.setVisible(false);
                this.fillerEnd.setVisible(false);
                this.setIcon(false);
            }
        }
        if (!this.isActive()) {
            this.setActive(true);
        }
    }

    private void foldButtonActionPerformed(ActionEvent evt) {
        this.contentPanel.setVisible(this.foldButton.isSelected());
        this.fillerLine.setVisible(this.foldButton.isSelected());
        this.fillerEnd.setVisible(this.foldButton.isSelected());
        this.setIcon(this.foldButton.isSelected());
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setHeaderActions(Action[] actions) {
        this.headerButtons = new JButton[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            this.headerButtons[i] = new JButton(actions[i]);
            this.headerButtons[i].setMargin(new Insets(0, 14, 0, 14));
            this.headerButtons[i].setOpaque(false);
            this.actionPanel.add(this.headerButtons[i]);
        }
    }

    public JButton[] getHeaderButtons() {
        return this.headerButtons;
    }

    public boolean isFoldable() {
        return this.foldable;
    }

    private void setIcon(boolean opened) {
        Image image = null;
        if (opened) {
            image = this.root == null ? null : this.root.getOpenedIcon(1);
        } else {
            Image image2 = image = this.root == null ? null : this.root.getIcon(1);
        }
        if (image != null) {
            this.titleButton.setIcon(new ImageIcon(image));
        }
    }
}

