/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import org.netbeans.modules.xml.multiview.Refreshable;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;

public abstract class ItemCheckBoxHelper
implements ActionListener,
Refreshable {
    private JCheckBox checkBox;
    private XmlMultiViewDataSynchronizer synchronizer;

    public ItemCheckBoxHelper(XmlMultiViewDataSynchronizer synchronizer, JCheckBox checkBox) {
        this.synchronizer = synchronizer;
        this.checkBox = checkBox;
        checkBox.addActionListener(this);
        this.setValue(this.getItemValue());
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        boolean value = this.getValue();
        if (value != this.getItemValue()) {
            this.setItemValue(value);
            this.synchronizer.requestUpdateData();
        }
    }

    public void setValue(boolean itemValue) {
        this.checkBox.setSelected(itemValue);
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public boolean getValue() {
        return this.checkBox.isSelected();
    }

    public abstract boolean getItemValue();

    public abstract void setItemValue(boolean var1);

    @Override
    public void refresh() {
        this.setValue(this.getItemValue());
    }
}

