/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.xml.axi.impl.AXIModelBuilderQuery;
import org.netbeans.modules.xml.axi.impl.AXIModelImpl;
import org.netbeans.modules.xml.axi.impl.ModelAccessImpl;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;

public class SchemaModelListener
implements PropertyChangeListener {
    private List<PropertyChangeEvent> events = new ArrayList<PropertyChangeEvent>();
    private AXIModelImpl model;

    public SchemaModelListener(AXIModelImpl model) {
        this.model = model;
    }

    boolean needsSync() {
        return !this.events.isEmpty();
    }

    void syncCompleted() {
        this.events.clear();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        assert (this.model != null);
        if (this.model.isIntransaction() || !this.isValidEvent(evt)) {
            return;
        }
        this.events.add(evt);
        ((ModelAccessImpl)this.model.getAccess()).setDirty();
    }

    private boolean isValidEvent(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof SchemaModel) {
            return true;
        }
        if (!(evt.getSource() instanceof SchemaComponent)) {
            return false;
        }
        SchemaComponent component = (SchemaComponent)evt.getSource();
        if (evt.getOldValue() == null && evt.getNewValue() != null && evt.getNewValue() instanceof SchemaComponent) {
            component = (SchemaComponent)evt.getNewValue();
        }
        if (evt.getNewValue() == null && evt.getOldValue() != null && evt.getOldValue() instanceof SchemaComponent) {
            component = (SchemaComponent)evt.getOldValue();
        }
        AXIModelBuilderQuery query = new AXIModelBuilderQuery(this.model);
        return query.affectsModel(component);
    }
}

