/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.spi;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping25;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.rest.MiscPrivateUtilities;
import org.netbeans.modules.websvc.rest.WebXmlUpdater;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MiscUtilities {
    public static FileObject findSourceRoot(Project project) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroups != null && sourceGroups.length > 0) {
            return sourceGroups[0].getRootFolder();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File testdir, String name) throws IOException {
        String path = "resources/" + name;
        File df = new File(testdir, name);
        if (!df.exists()) {
            InputStream is = null;
            OutputStream os = null;
            try {
                int c;
                is = RestSupport.class.getResourceAsStream(path);
                os = new FileOutputStream(df);
                while ((c = is.read()) != -1) {
                    os.write(c);
                }
            }
            finally {
                if (os != null) {
                    os.flush();
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject copyFile(File testdir, String name, String[] replaceKeys, boolean overwrite) throws IOException {
        FileObject dir = FileUtil.toFileObject((File)testdir);
        FileObject fo = dir.getFileObject(name);
        if (fo == null) {
            fo = dir.createData(name);
        } else if (!overwrite) {
            return fo;
        }
        FileLock lock = null;
        BufferedWriter writer = null;
        BufferedReader reader = null;
        try {
            String line;
            int i;
            lock = fo.lock();
            OutputStream os = fo.getOutputStream(lock);
            writer = new BufferedWriter(new OutputStreamWriter(os, Charset.forName("UTF-8")));
            InputStream is = RestSupport.class.getResourceAsStream("resources/" + name);
            reader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            String lineSep = "\n";
            if (File.separatorChar == '\\') {
                lineSep = "\r\n";
            }
            String[] replaceValues = null;
            if (replaceKeys != null) {
                replaceValues = new String[replaceKeys.length];
                for (i = 0; i < replaceKeys.length; ++i) {
                    replaceValues[i] = NbBundle.getMessage(RestSupport.class, (String)replaceKeys[i]);
                }
            }
            while ((line = reader.readLine()) != null) {
                for (i = 0; i < replaceKeys.length; ++i) {
                    line = line.replaceAll(replaceKeys[i], replaceValues[i]);
                }
                writer.write(line);
                writer.write(lineSep);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (lock != null) {
                lock.releaseLock();
            }
            if (reader != null) {
                reader.close();
            }
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject modifyFile(FileObject fo, Map<String, String> replace) throws IOException {
        StringWriter content = new StringWriter();
        BufferedWriter writer = null;
        BufferedReader reader = null;
        try {
            String line;
            writer = new BufferedWriter(content);
            InputStream is = fo.getInputStream();
            reader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            String lineSep = "\n";
            if (File.separatorChar == '\\') {
                lineSep = "\r\n";
            }
            while ((line = reader.readLine()) != null) {
                for (Map.Entry<String, String> entry : replace.entrySet()) {
                    line = line.replaceAll(entry.getKey(), entry.getValue());
                }
                writer.write(line);
                writer.write(lineSep);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
            StringBuffer buffer = content.getBuffer();
            FileLock lock = fo.lock();
            try {
                OutputStream outputStream = fo.getOutputStream(lock);
                writer = new BufferedWriter(new OutputStreamWriter(outputStream, Charset.forName("UTF-8")));
                writer.write(buffer.toString());
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
                if (writer != null) {
                    writer.close();
                }
            }
        }
        return fo;
    }

    public static FileObject getApplicationContextXml(Project project) {
        FileObject configRoot;
        FileObject webInf;
        J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        FileObject[] fobjs = provider.getSourceRoots();
        if (fobjs.length > 0 && (webInf = (configRoot = fobjs[0]).getFileObject("WEB-INF")) != null) {
            return webInf.getFileObject("applicationContext", "xml");
        }
        return null;
    }

    public static String getContextRootURL(Project project) {
        String portNumber = "8080";
        String host = "localhost";
        J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        String serverInstanceID = provider.getServerInstanceID();
        if (serverInstanceID == null || "DEV-NULL".equals(serverInstanceID)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RestSupport.class, (String)"MSG_MissingServer"), 0));
        } else {
            ServerInstance serverInstance = Deployment.getDefault().getServerInstance(serverInstanceID);
            try {
                ServerInstance.Descriptor instanceDescriptor = serverInstance.getDescriptor();
                if (instanceDescriptor != null) {
                    String hostName;
                    int port = instanceDescriptor.getHttpPort();
                    if (port > 0) {
                        portNumber = String.valueOf(port);
                    }
                    if ((hostName = instanceDescriptor.getHostname()) != null) {
                        host = hostName;
                    }
                }
            }
            catch (InstanceRemovedException instanceDescriptor) {
                // empty catch block
            }
        }
        J2eeModuleProvider.ConfigSupport configSupport = provider.getConfigSupport();
        String contextRoot = null;
        try {
            contextRoot = configSupport.getWebContextRoot();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (contextRoot == null) {
            contextRoot = "";
        }
        if (contextRoot.length() > 0 && contextRoot.startsWith("/")) {
            contextRoot = contextRoot.substring(1);
        }
        return "http://" + host + ":" + portNumber + "/" + (contextRoot.length() > 0 ? contextRoot + "/" : "");
    }

    public static boolean hasApplicationResourceClass(RestSupport restSupport, String fqn) {
        return MiscPrivateUtilities.hasApplicationResourceClass(restSupport, fqn);
    }

    public static FileObject generateTestClient(File testdir) throws IOException {
        return MiscPrivateUtilities.generateTestClient(testdir);
    }

    public static void addInitParam(RestSupport restSupport, String paramName, String value) {
        try {
            FileObject ddFO = restSupport.getWebXmlUpdater().getWebXml(false);
            WebApp webApp = restSupport.getWebXmlUpdater().findWebApp();
            if (ddFO == null || webApp == null) {
                return;
            }
            Servlet adaptorServlet = WebXmlUpdater.getRestServletAdaptorByName(webApp, "ServletAdaptor");
            if (adaptorServlet == null) {
                return;
            }
            InitParam initParam = (InitParam)adaptorServlet.findBeanByName("InitParam", "ParamName", paramName);
            if (initParam == null) {
                try {
                    initParam = (InitParam)adaptorServlet.createBean("InitParam");
                    adaptorServlet.addInitParam(initParam);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            initParam.setParamName(paramName);
            initParam.setParamValue(value);
            webApp.write(ddFO);
        }
        catch (IOException e) {
            Logger.getLogger(RestSupport.class.getName()).log(Level.WARNING, null, e);
        }
    }

    public static void addCORSFilter(RestSupport restSupport, String applicationClassName, String corsFilterName) {
        try {
            InitParam initParam;
            assert (applicationClassName != null);
            WebXmlUpdater webXmlUpdater = restSupport.getWebXmlUpdater();
            FileObject ddFO = webXmlUpdater.getWebXml(true);
            WebApp webApp = webXmlUpdater.findWebApp();
            if (ddFO == null || webApp == null) {
                return;
            }
            boolean changed = false;
            Servlet applicationConfigServlet = WebXmlUpdater.getRestServletAdaptorByName(webApp, applicationClassName);
            if (applicationConfigServlet == null) {
                try {
                    applicationConfigServlet = (Servlet)webApp.createBean("Servlet");
                    applicationConfigServlet.setServletName(applicationClassName);
                    webApp.addServlet(applicationConfigServlet);
                    changed = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (applicationConfigServlet != null && (initParam = (InitParam)applicationConfigServlet.findBeanByName("InitParam", "ParamName", "com.sun.jersey.spi.container.ContainerResponseFilters")) == null) {
                try {
                    initParam = (InitParam)applicationConfigServlet.createBean("InitParam");
                    initParam.setParamName("com.sun.jersey.spi.container.ContainerResponseFilters");
                    initParam.setParamValue(corsFilterName);
                    applicationConfigServlet.addInitParam(initParam);
                    changed = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (changed) {
                webApp.write(ddFO);
            }
        }
        catch (IOException e) {
            Logger.getLogger(RestSupport.class.getName()).log(Level.WARNING, null, e);
        }
    }

    public static ServletMapping25 getRestServletMapping(WebApp webApp) {
        return WebXmlUpdater.getRestServletMapping(webApp);
    }

    public static String getApplicationPathFromDD(WebApp webApp) {
        ServletMapping25 sm;
        if (webApp != null && (sm = MiscUtilities.getRestServletMapping(webApp)) != null) {
            String urlPattern = null;
            String[] urlPatterns = sm.getUrlPatterns();
            if (urlPatterns.length > 0) {
                urlPattern = urlPatterns[0];
            }
            if (urlPattern != null) {
                if (urlPattern.endsWith("*")) {
                    urlPattern = urlPattern.substring(0, urlPattern.length() - 1);
                }
                if (urlPattern.endsWith("/")) {
                    urlPattern = urlPattern.substring(0, urlPattern.length() - 1);
                }
                if (urlPattern.startsWith("/")) {
                    urlPattern = urlPattern.substring(1);
                }
                return urlPattern;
            }
        }
        return null;
    }

    public static Datasource getDatasource(Project p, String jndiName) {
        J2eeModuleProvider provider = (J2eeModuleProvider)p.getLookup().lookup(J2eeModuleProvider.class);
        try {
            return provider.getConfigSupport().findDatasource(jndiName);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static String createBodyForGetClassesMethod(RestSupport restSupport) {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        if (MiscUtilities.isSourceLevel17orHigher(restSupport.getProject())) {
            builder.append("Set<Class<?>> resources = new java.util.HashSet<>();");
        } else {
            builder.append("Set<Class<?>> resources = new java.util.HashSet<Class<?>>();");
        }
        if (!restSupport.hasJersey2(true)) {
            builder.append(MiscPrivateUtilities.getJacksonProviderSnippet(restSupport));
        }
        builder.append("addRestResourceClasses(resources);");
        builder.append("return resources;}");
        return builder.toString();
    }

    public static ClassTree createAddResourceClasses(TreeMaker maker, ClassTree classTree, CompilationController controller, String methodBody, boolean addComment) throws IOException {
        WildcardTree wildCard = maker.Wildcard(Tree.Kind.UNBOUNDED_WILDCARD, null);
        ParameterizedTypeTree wildClass = maker.ParameterizedType((Tree)maker.QualIdent(Class.class.getCanonicalName()), Collections.singletonList(wildCard));
        ParameterizedTypeTree wildSet = maker.ParameterizedType((Tree)maker.QualIdent(Set.class.getCanonicalName()), Collections.singletonList(wildClass));
        ModifiersTree modifiersTree = maker.Modifiers(EnumSet.of(Modifier.PRIVATE));
        VariableTree newParam = maker.Variable(maker.Modifiers(Collections.emptySet()), (CharSequence)"resources", (Tree)wildSet, null);
        MethodTree methodTree = maker.Method(modifiersTree, (CharSequence)"addRestResourceClasses", maker.Type("void"), Collections.emptyList(), Arrays.asList(newParam), Collections.emptyList(), methodBody, null);
        if (addComment) {
            Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)"Do not modify addRestResourceClasses() method.\nIt is automatically populated with\nall resources defined in the project.\nIf required, comment out calling this method in getClasses().");
            maker.addComment((Tree)methodTree, comment, true);
        }
        return maker.addClassMember(classTree, (Tree)methodTree);
    }

    private static boolean isSourceLevel17orHigher(Project project) {
        String srcLevel = SourceLevelQuery.getSourceLevel((FileObject)project.getProjectDirectory());
        if (srcLevel != null) {
            double sourceLevel = Double.parseDouble(srcLevel);
            return sourceLevel >= 1.7;
        }
        return false;
    }

    public static boolean isJavaEE6AndHigher(Project project) {
        Profile profile;
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        return webModule != null && (Profile.JAVA_EE_6_WEB == (profile = webModule.getJ2eeProfile()) || Profile.JAVA_EE_6_FULL == profile || Profile.JAVA_EE_7_WEB == profile || Profile.JAVA_EE_7_FULL == profile || Profile.JAVA_EE_8_WEB == profile || Profile.JAVA_EE_8_FULL == profile || Profile.JAKARTA_EE_8_WEB == profile || Profile.JAKARTA_EE_8_FULL == profile || Profile.JAKARTA_EE_9_WEB == profile || Profile.JAKARTA_EE_9_FULL == profile);
    }
}

