/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.wizards.ResourceLibraryIteratorPanel;
import org.netbeans.modules.web.jsf.wizards.TemplateIterator;
import org.netbeans.modules.web.jsf.wizards.TemplatePanelVisual;
import org.netbeans.modules.web.jsfapi.api.JsfVersion;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class ResourceLibraryIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 1L;
    protected static final String META_INF = "META-INF";
    protected static final String CONTRACTS = "contracts";
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private WizardDescriptor descriptor;
    private ProjectType projectType;
    private int index;

    public Set<DataObject> instantiate(TemplateWizard wiz) throws IOException {
        FileObject targetDir;
        Project project = Templates.getProject((WizardDescriptor)wiz);
        FileObject contractsParent = this.getNearestContractsParent(project);
        HashSet<DataObject> result = new HashSet<DataObject>();
        if (this.projectType == ProjectType.J2SE && !META_INF.equals(contractsParent.getName())) {
            contractsParent = FileUtil.createFolder((FileObject)contractsParent, (String)META_INF);
        }
        if ((targetDir = contractsParent.getFileObject(CONTRACTS)) == null) {
            targetDir = FileUtil.createFolder((FileObject)contractsParent, (String)CONTRACTS);
        }
        FileObject contractFolder = FileUtil.createFolder((FileObject)targetDir, (String)((String)wiz.getProperty("contractName")));
        if (((Boolean)wiz.getProperty("createTemplate")).booleanValue()) {
            FileObject cssFolder = contractFolder.getFileObject("css");
            if (cssFolder == null) {
                cssFolder = FileUtil.createFolder((FileObject)contractFolder, (String)"css");
            }
            TemplateIterator.CreateTemplateAction templateAction = new TemplateIterator.CreateTemplateAction((TemplatePanelVisual)wiz.getProperty("templatePanel"), (String)wiz.getProperty("templateName"), contractFolder, cssFolder, JsfVersion.JSF_2_2);
            contractsParent.getFileSystem().runAtomicAction((FileSystem.AtomicAction)templateAction);
            result.add(DataObject.find((FileObject)templateAction.getResult()));
        }
        return result;
    }

    public void initialize(TemplateWizard wiz) {
        this.descriptor = wiz;
        Project project = Templates.getProject((WizardDescriptor)wiz);
        FileObject contractsParent = this.getNearestContractsParent(project);
        this.loadPanelsAndSteps(contractsParent);
    }

    public void uninitialize(TemplateWizard wiz) {
        this.panels = null;
        this.descriptor = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(TemplateIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private FileObject getNearestContractsParent(Project project) {
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (wm != null) {
            this.projectType = ProjectType.WEB;
            if (wm.getDocumentBase() != null) {
                return wm.getDocumentBase();
            }
        } else {
            SourceGroup[] sourceGroups;
            this.projectType = ProjectType.J2SE;
            Sources sources = ProjectUtils.getSources((Project)project);
            for (SourceGroup sourceGroup : sourceGroups = sources.getSourceGroups("java")) {
                FileObject metaInf = sourceGroup.getRootFolder().getFileObject(META_INF);
                if (metaInf == null) continue;
                return metaInf;
            }
            if (sourceGroups.length > 0) {
                return sourceGroups[0].getRootFolder();
            }
        }
        return project.getProjectDirectory();
    }

    private void loadPanelsAndSteps(FileObject contractsParent) {
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new ResourceLibraryIteratorPanel(this.descriptor, contractsParent, this.projectType)};
            String[] steps = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                if (steps[i] == null) {
                    steps[i] = c.getName();
                }
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
    }

    private String[] createSteps() {
        String[] beforeSteps = null;
        Object prop = this.descriptor.getProperty("WizardPanel_contentData");
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        if (beforeSteps == null) {
            beforeSteps = new String[]{};
        }
        String[] res = new String[beforeSteps.length - 1 + this.panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < beforeSteps.length - 1 ? beforeSteps[i] : this.panels[i - beforeSteps.length + 1].getComponent().getName();
        }
        return res;
    }

    protected static enum ProjectType {
        WEB,
        J2SE;

    }
}

