/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.hints.rules;

import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.jakarta.web.beans.CdiUtil;
import org.netbeans.modules.web.jsf.hints.JsfHintsContext;
import org.netbeans.modules.web.jsf.hints.JsfHintsUtils;
import org.netbeans.modules.web.jsf.hints.rules.Bundle;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.HintContext;

public class FlowScopedBeanWithoutCdi {
    private static final String FLOW_SCOPED = "javax.faces.flow.FlowScoped";
    private static final String FLOW_SCOPED_JAKARTA = "jakarta.faces.flow.FlowScoped";

    public static Collection<ErrorDescription> run(HintContext hintContext) {
        ArrayList<ErrorDescription> problems = new ArrayList<ErrorDescription>();
        JsfHintsContext ctx = JsfHintsUtils.getOrCacheContext(hintContext);
        Project project = ctx.getProject();
        if (project == null) {
            return problems;
        }
        CompilationInfo info = hintContext.getInfo();
        for (TypeElement typeElement : info.getTopLevelElements()) {
            for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
                Tree tree;
                org.netbeans.modules.web.beans.CdiUtil cdiUtil;
                if (FLOW_SCOPED.equals(annotationMirror.getAnnotationType().toString())) {
                    cdiUtil = (org.netbeans.modules.web.beans.CdiUtil)project.getLookup().lookup(org.netbeans.modules.web.beans.CdiUtil.class);
                    if (cdiUtil != null && cdiUtil.isCdiEnabled()) continue;
                    tree = info.getTrees().getTree(typeElement, annotationMirror);
                    problems.add(JsfHintsUtils.createProblem(tree, info, Bundle.FlowScopedBeanWithoutCdi_display_name(), Severity.WARNING, Arrays.asList(new FixCdiAvailability(project))));
                    continue;
                }
                if (!FLOW_SCOPED_JAKARTA.equals(annotationMirror.getAnnotationType().toString()) || (cdiUtil = (CdiUtil)project.getLookup().lookup(CdiUtil.class)) != null && cdiUtil.isCdiEnabled()) continue;
                tree = info.getTrees().getTree(typeElement, annotationMirror);
                problems.add(JsfHintsUtils.createProblem(tree, info, Bundle.FlowScopedBeanWithoutCdi_display_name(), Severity.WARNING, Arrays.asList(new FixCdiAvailability(project))));
            }
        }
        return problems;
    }

    private static class FixCdiAvailability
    implements Fix {
        private final Project project;

        public FixCdiAvailability(Project project) {
            this.project = project;
        }

        public String getText() {
            ProjectInformation information = ProjectUtils.getInformation((Project)this.project);
            return Bundle.FixCdiAvailability_lbl_enable_cdi(information.getDisplayName());
        }

        public ChangeInfo implement() throws Exception {
            org.netbeans.modules.web.beans.CdiUtil cdiUtil;
            CdiUtil jakartaCdiUtil = (CdiUtil)this.project.getLookup().lookup(CdiUtil.class);
            if (jakartaCdiUtil != null) {
                jakartaCdiUtil.enableCdi();
            }
            if ((cdiUtil = (org.netbeans.modules.web.beans.CdiUtil)this.project.getLookup().lookup(org.netbeans.modules.web.beans.CdiUtil.class)) != null) {
                cdiUtil.enableCdi();
            }
            return null;
        }
    }
}

