/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.richfaces;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.JsfComponentUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.netbeans.modules.web.jsf.richfaces.Bundle;
import org.netbeans.modules.web.jsf.richfaces.Richfaces4Customizer;
import org.netbeans.modules.web.jsf.richfaces.ui.Richfaces4CustomizerPanelVisual;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentCustomizer;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class Richfaces4Implementation
implements JsfComponentImplementation {
    private static final Logger LOGGER = Logger.getLogger(Richfaces4Implementation.class.getName());
    private Richfaces4Customizer customizer;
    private static final String RICHFACES_NAME = "RichFaces";
    private static final String MAVEN_REPO = "default:https://repository.jboss.org/nexus/content/groups/public-jboss/";
    private static final String MAVEN_DEP_CORE = "org.richfaces.core:richfaces-core-impl:4.3.3.Final:jar";
    private static final String MAVEN_DEP_UI = "org.richfaces.ui:richfaces-components-ui:4.3.3.Final:jar";
    public static final Set<String> RF_LIBRARIES = new HashSet<String>();
    public static final Map<String, String> RF_DEPENDENCIES = new HashMap<String, String>();
    public static final String PREF_RICHFACES_NODE = "richfaces";
    public static final String PREF_RICHFACES_LIBRARY = "base-library";

    public String getName() {
        return RICHFACES_NAME;
    }

    public String getDisplayName() {
        return Bundle.Richfaces4Implementation_richfaces_display_name();
    }

    public String getDescription() {
        return NbBundle.getMessage(Richfaces4Implementation.class, (String)"LBL_RichFaces_Description");
    }

    public void remove(WebModule webModule) {
        try {
            List<Library> richfacesLibraries = JsfComponentUtils.isMavenBased((WebModule)webModule) ? Arrays.asList(Richfaces4Implementation.getMavenLibrary()) : Richfaces4Customizer.getRichfacesLibraries();
            ProjectClassPathModifier.removeLibraries((Library[])richfacesLibraries.toArray(new Library[richfacesLibraries.size()]), (FileObject)webModule.getJavaSources()[0], (String)"classpath/compile");
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Exception during removing JSF suite from an web project", ex);
        }
        catch (UnsupportedOperationException ex) {
            LOGGER.log(Level.WARNING, "Exception during removing JSF suite from an web project", ex);
        }
    }

    public Set<FileObject> extend(WebModule webModule, JsfComponentCustomizer jsfComponentCustomizer) {
        Richfaces4Implementation.extendClasspath(webModule, jsfComponentCustomizer);
        try {
            FileObject welcomePage = Richfaces4Implementation.generateWelcomePage(webModule);
            return Collections.singleton(welcomePage);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Exception during welcome page creation", ex);
            return Collections.emptySet();
        }
    }

    private static void extendClasspath(WebModule webModule, JsfComponentCustomizer jsfComponentCustomizer) {
        try {
            ArrayList<Library> libraries = new ArrayList<Library>(1);
            Library rfLibrary = null;
            if (JsfComponentUtils.isMavenBased((WebModule)webModule)) {
                rfLibrary = Richfaces4Implementation.getMavenLibrary();
            } else {
                if (jsfComponentCustomizer != null) {
                    Richfaces4CustomizerPanelVisual panel = (Richfaces4CustomizerPanelVisual)jsfComponentCustomizer.getComponent();
                    rfLibrary = LibraryManager.getDefault().getLibrary(panel.getRichFacesLibrary());
                }
                if (rfLibrary == null) {
                    Preferences preferences = Richfaces4Implementation.getRichfacesPreferences();
                    rfLibrary = LibraryManager.getDefault().getLibrary(preferences.get(PREF_RICHFACES_LIBRARY, ""));
                }
                if (rfLibrary == null) {
                    rfLibrary = Richfaces4Customizer.getRichfacesLibraries().get(0);
                }
            }
            if (rfLibrary != null) {
                FileObject[] javaSources = webModule.getJavaSources();
                libraries.add(rfLibrary);
                ProjectClassPathModifier.addLibraries((Library[])libraries.toArray(new Library[1]), (FileObject)javaSources[0], (String)"classpath/compile");
            } else {
                LOGGER.log(Level.SEVERE, "No RichFaces library was found.");
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Exception during extending an web project", ex);
        }
        catch (UnsupportedOperationException ex) {
            LOGGER.log(Level.WARNING, "Exception during extending an web project", ex);
        }
    }

    private static Library getMavenLibrary() {
        return JsfComponentUtils.createMavenDependencyLibrary((String)"RichFaces-maven-lib", (String[])new String[]{MAVEN_DEP_CORE, MAVEN_DEP_UI}, (String[])new String[]{MAVEN_REPO});
    }

    private static FileObject generateWelcomePage(WebModule webModule) throws IOException {
        FileObject templateFO = FileUtil.getConfigFile((String)"Templates/Other/welcomeRichfaces.xhtml");
        DataObject templateDO = DataObject.find((FileObject)templateFO);
        DataObject generated = templateDO.createFromTemplate(DataFolder.findFolder((FileObject)webModule.getDocumentBase()), "welcomeRichfaces");
        JsfComponentUtils.reformat((DataObject)generated);
        Richfaces4Implementation.updateIndexPage(webModule);
        return generated.getPrimaryFile();
    }

    private static void updateIndexPage(WebModule webModule) throws DataObjectNotFoundException {
        FileObject indexFO;
        FileObject documentBase = webModule.getDocumentBase();
        if (documentBase != null && (indexFO = documentBase.getFileObject("index.xhtml")) != null) {
            DataObject indexDO = DataObject.find((FileObject)indexFO);
            JsfComponentUtils.enhanceFileBody((DataObject)indexDO, (String)"</h:body>", (String)"<br />\n<h:link outcome=\"welcomeRichfaces\" value=\"Richfaces welcome page\" />");
            if (indexFO.isValid() && indexFO.canWrite()) {
                JsfComponentUtils.reformat((DataObject)indexDO);
            }
        }
    }

    public Set<JSFVersion> getJsfVersion() {
        return EnumSet.of(JSFVersion.JSF_2_0, JSFVersion.JSF_2_1, JSFVersion.JSF_2_2);
    }

    public boolean isInWebModule(WebModule webModule) {
        ClassPath classpath = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/compile");
        for (String libraryName : RF_LIBRARIES) {
            if (classpath.findResource(libraryName.replace('.', '/') + ".class") != null) continue;
            return false;
        }
        return true;
    }

    public JsfComponentCustomizer createJsfComponentCustomizer(WebModule webModule) {
        if (this.customizer == null) {
            this.customizer = new Richfaces4Customizer();
        }
        return this.customizer;
    }

    public static Preferences getRichfacesPreferences() {
        return NbPreferences.forModule(Richfaces4Implementation.class).node(PREF_RICHFACES_NODE);
    }

    static {
        RF_LIBRARIES.add("org.richfaces.application.Module");
        RF_LIBRARIES.add("org.richfaces.application.ServiceLoader");
        RF_LIBRARIES.add("org.richfaces.el.ValueDescriptor");
        RF_LIBRARIES.add("org.richfaces.el.ValueReference");
        RF_DEPENDENCIES.put("com.google.common.base.Functions", "guava.jar");
        RF_DEPENDENCIES.put("org.w3c.css.sac.Parser", "sac.jar");
        RF_DEPENDENCIES.put("com.steadystate.css.parser.ParseException", "cssparser.jar");
    }
}

