/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.awt.Image;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JOptionPane;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModel;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationCase;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationRule;
import org.netbeans.modules.web.jsf.navigation.FacesModelUtility;
import org.netbeans.modules.web.jsf.navigation.PageFlowController;
import org.netbeans.modules.web.jsf.navigation.Pin;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneElement;
import org.openide.ErrorManager;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class NavigationCaseEdge
extends PageFlowSceneElement {
    private final NavigationCase navCase;
    private final String toViewID;
    private final PageFlowController pc;
    private static final String MSG_FacesConfigIllegalStateWarning = NbBundle.getMessage(NavigationCaseEdge.class, (String)"MSG_FacesConfigIllegalStateWarning");
    private static final String TLE_FacesConfigIllegalStateWarning = NbBundle.getMessage(NavigationCaseEdge.class, (String)"TLE_FacesConfigIllegalStateWarning");
    private Node navNode;

    public NavigationCaseEdge(PageFlowController pc, NavigationCase navCase) {
        this.navCase = navCase;
        this.toViewID = FacesModelUtility.getToViewIdFiltered(navCase);
        this.pc = pc;
    }

    public String toString() {
        return new String("NavigationCaseEdge[FromOutcome=" + this.getFromOuctome() + " ToViewId=" + this.getToViewId() + " FromViewId=" + this.getFromViewId() + "] ");
    }

    public String getToViewId() {
        return this.toViewID;
    }

    public String getFromOuctome() {
        if (this.navCase != null && this.navCase.getModel() != null) {
            return this.navCase.getFromOutcome();
        }
        return null;
    }

    public String getFromAction() {
        if (this.navCase != null && this.navCase.getModel() != null) {
            return this.navCase.getFromAction();
        }
        return null;
    }

    public boolean isRedirected() {
        return this.navCase.isRedirected();
    }

    public String getFromViewId() {
        NavigationRule navRule;
        if (this.navCase != null && this.navCase.getModel() != null && (navRule = (NavigationRule)this.navCase.getParent()) != null) {
            return FacesModelUtility.getFromViewIdFiltered(navRule);
        }
        return null;
    }

    @Override
    public boolean canRename() {
        return true;
    }

    @Override
    public void setName(String newName) {
        Pin pin = this.pc.getView().getEdgeSourcePin(this);
        if (pin != null && !pin.isDefault()) {
            pin.setFromOutcome(newName);
        }
        this.pc.setModelNavigationCaseName(this.navCase, newName);
        super.setName(newName);
    }

    @Override
    public String getName() {
        String name = "";
        if (this.navCase.getModel() != null) {
            try {
                name = this.navCase.getFromOutcome() != null ? this.navCase.getFromOutcome() : this.navCase.getFromAction();
            }
            catch (IllegalStateException ise) {
                JOptionPane.showMessageDialog(Utilities.findDialogParent(), MSG_FacesConfigIllegalStateWarning, TLE_FacesConfigIllegalStateWarning, 2);
            }
        }
        return name;
    }

    @Override
    public boolean canDestroy() {
        return true;
    }

    @Override
    public void destroy() throws IOException {
        boolean deleteRuleTo = false;
        this.pc.removeModelNavigationCase(this.navCase);
        if (this.navNode != null) {
            this.navNode.destroy();
        }
    }

    @Override
    public HelpCtx getHelpCtx() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Image getIcon(int type) {
        return null;
    }

    @Override
    public Node getNode() {
        if (this.navNode == null) {
            this.navNode = new NavNode(this);
        }
        return this.navNode;
    }

    private class NavNode
    extends AbstractNode {
        private final NavigationCaseEdge edge;

        public NavNode(NavigationCaseEdge edge) {
            super(Children.LEAF);
            this.edge = edge;
        }

        protected Sheet createSheet() {
            Sheet s = Sheet.createDefault();
            Sheet.Set ss = s.get("general");
            if (ss == null) {
                ss = new Sheet.Set();
                ss.setName("general");
                ss.setDisplayName(NbBundle.getMessage(NavigationCaseEdge.class, (String)"General"));
                ss.setShortDescription(NbBundle.getMessage(NavigationCaseEdge.class, (String)"GeneralHint"));
                s.put(ss);
            }
            Sheet.Set gs = ss;
            try {
                ModelProperty p = new ModelProperty(NavigationCaseEdge.this.navCase, String.class, "getFromOutcome", "setFromOutcome");
                p.setName("fromOutcome");
                p.setDisplayName(NbBundle.getMessage(NavigationCaseEdge.class, (String)"Outcome"));
                p.setShortDescription(NbBundle.getMessage(NavigationCaseEdge.class, (String)"OutcomeHint"));
                ss.put((Node.Property)p);
                p = new ModelProperty(NavigationCaseEdge.this.navCase, String.class, "getFromAction", "setFromAction");
                p.setName("fromView");
                p.setDisplayName(NbBundle.getMessage(NavigationCaseEdge.class, (String)"FromAction"));
                p.setShortDescription(NbBundle.getMessage(NavigationCaseEdge.class, (String)"FromActionHint"));
                ss.put((Node.Property)p);
                p = new ModelProperty(NavigationCaseEdge.this.navCase, String.class, "getToViewId", "setToViewId");
                p.setName("toViewId");
                p.setDisplayName(NbBundle.getMessage(NavigationCaseEdge.class, (String)"ToViewId"));
                p.setShortDescription(NbBundle.getMessage(NavigationCaseEdge.class, (String)"ToViewHint"));
                ss.put((Node.Property)p);
            }
            catch (NoSuchMethodException nsme) {
                ErrorManager.getDefault().notify((Throwable)nsme);
            }
            return s;
        }

        public <T extends Node.Cookie> T getCookie(Class<T> type) {
            if (type.equals(SaveCookie.class)) {
                NavigationCaseEdge.this.pc.serializeNodeLocations();
                return (T)NavigationCaseEdge.this.pc.getConfigDataObject().getCookie(type);
            }
            if (type.equals(OpenCookie.class)) {
                return (T)new OpenCookie(){

                    public void open() {
                        NavigationCaseEdge.this.pc.openNavigationCase(NavNode.this.edge);
                    }
                };
            }
            return null;
        }

        public boolean canRename() {
            return NavigationCaseEdge.this.isModifiable();
        }

        public String getName() {
            return this.edge.getName();
        }

        public void setName(String s) {
            super.setName(s);
            this.edge.setName(s);
        }
    }

    public class ModelProperty
    extends PropertySupport.Reflection<String> {
        public ModelProperty(Object instance, Class<String> valueType, String getter, String setter) throws NoSuchMethodException {
            super(instance, valueType, getter, setter);
        }

        public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            JSFConfigModel model = NavigationCaseEdge.this.navCase.getModel();
            model.startTransaction();
            super.setValue((Object)val);
            try {
                model.endTransaction();
                model.sync();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalStateException ise) {
                Exceptions.printStackTrace((Throwable)ise);
            }
        }
    }
}

