/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph;

import java.awt.Point;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.visual.vmd.VMDNodeWidget;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowScene;

public class PageFlowSceneData {
    private final PageFlowToolbarUtilities utilities;
    private final Map<String, PageData> facesConfigSceneData = new HashMap<String, PageData>();
    private final Map<String, PageData> projectSceneData = new HashMap<String, PageData>();
    private final Map<String, PageData> allFacesConfigSceneData = new HashMap<String, PageData>();
    private static Logger LOG = Logger.getLogger(PageFlowSceneData.class.getName());

    public PageFlowSceneData(PageFlowToolbarUtilities utilities) {
        this.utilities = utilities;
    }

    public void saveCurrentSceneData(PageFlowScene scene) {
        switch (this.utilities.getCurrentScope()) {
            case SCOPE_FACESCONFIG: {
                this.facesConfigSceneData.clear();
                this.facesConfigSceneData.putAll(this.createSceneInfo(scene));
                break;
            }
            case SCOPE_PROJECT: {
                this.projectSceneData.clear();
                this.projectSceneData.putAll(this.createSceneInfo(scene));
                break;
            }
            case SCOPE_ALL_FACESCONFIG: {
                this.allFacesConfigSceneData.clear();
                this.allFacesConfigSceneData.putAll(this.createSceneInfo(scene));
                break;
            }
            default: {
                LOG.fine("PageFlowSceneData: Unknown State");
            }
        }
    }

    public void savePageWithNewName(String oldDisplayName, String newDisplayName) {
        this.replaceSceneInfo(this.facesConfigSceneData, oldDisplayName, newDisplayName);
        this.replaceSceneInfo(this.projectSceneData, oldDisplayName, newDisplayName);
        this.replaceSceneInfo(this.allFacesConfigSceneData, oldDisplayName, newDisplayName);
    }

    public void loadSceneData(PageFlowScene scene) {
        this.loadSceneData(scene, this.getCurrentSceneData());
    }

    public PageData getPageData(String pageDisplayName) {
        Map<String, PageData> map = this.getCurrentSceneData();
        PageData data = null;
        if (map != null) {
            data = map.get(pageDisplayName);
        }
        return data;
    }

    private void loadSceneData(PageFlowScene scene, Map<String, PageData> sceneInfo) {
        if (sceneInfo == null) {
            return;
        }
        Collection pages = scene.getNodes();
        for (Page page : pages) {
            PageData data = sceneInfo.get(page.getDisplayName());
            if (data == null) continue;
            VMDNodeWidget pageWidget = (VMDNodeWidget)scene.findWidget(page);
            pageWidget.setPreferredLocation(data.getPoint());
            pageWidget.setMinimized(data.isMinimized());
        }
    }

    private Map<String, PageData> createSceneInfo(PageFlowScene scene) {
        HashMap<String, PageData> sceneInfo = new HashMap<String, PageData>();
        Collection pages = scene.getNodes();
        for (Page page : pages) {
            VMDNodeWidget pageWidget = (VMDNodeWidget)scene.findWidget(page);
            Point p = scene.isValidated() ? pageWidget.getLocation() : pageWidget.getPreferredLocation();
            if (p == null) continue;
            sceneInfo.put(page.getDisplayName(), PageFlowSceneData.createPageData(p, pageWidget.isMinimized()));
        }
        return sceneInfo;
    }

    public String getCurrentScopeStr() {
        return PageFlowToolbarUtilities.getScopeLabel(this.utilities.getCurrentScope());
    }

    public void setCurrentScope(PageFlowToolbarUtilities.Scope newScope) {
        this.utilities.setCurrentScope(newScope);
    }

    public void setScopeData(PageFlowToolbarUtilities.Scope scope, Map<String, PageData> map) {
        switch (scope) {
            case SCOPE_FACESCONFIG: {
                this.facesConfigSceneData.clear();
                this.facesConfigSceneData.putAll(map);
                break;
            }
            case SCOPE_PROJECT: {
                this.projectSceneData.clear();
                this.projectSceneData.putAll(map);
                break;
            }
            case SCOPE_ALL_FACESCONFIG: {
                this.allFacesConfigSceneData.clear();
                this.allFacesConfigSceneData.putAll(map);
            }
        }
    }

    public Map<String, PageData> getScopeData(PageFlowToolbarUtilities.Scope scope) {
        Map<String, PageData> sceneInfo = null;
        switch (scope) {
            case SCOPE_FACESCONFIG: {
                sceneInfo = this.facesConfigSceneData;
                break;
            }
            case SCOPE_PROJECT: {
                sceneInfo = this.projectSceneData;
                break;
            }
            case SCOPE_ALL_FACESCONFIG: {
                sceneInfo = this.allFacesConfigSceneData;
            }
        }
        return sceneInfo;
    }

    private Map<String, PageData> getCurrentSceneData() {
        Map<String, PageData> currentSceneData = null;
        switch (this.utilities.getCurrentScope()) {
            case SCOPE_FACESCONFIG: {
                currentSceneData = this.facesConfigSceneData;
                break;
            }
            case SCOPE_PROJECT: {
                currentSceneData = this.projectSceneData;
                break;
            }
            case SCOPE_ALL_FACESCONFIG: {
                currentSceneData = this.allFacesConfigSceneData;
                break;
            }
            default: {
                currentSceneData = null;
            }
        }
        return currentSceneData;
    }

    private void replaceSceneInfo(Map<String, PageData> sceneInfo, String oldDisplayName, String newDisplayName) {
        assert (oldDisplayName != null);
        assert (newDisplayName != null);
        if (sceneInfo == null || sceneInfo.size() < 1) {
            return;
        }
        PageData data = sceneInfo.remove(oldDisplayName);
        if (data != null) {
            sceneInfo.put(newDisplayName, data);
        }
    }

    public static PageData createPageData(Point point, boolean isMinimized) {
        return new PageData(point, isMinimized);
    }

    public static class PageData {
        private Point point;
        private boolean isMinimized = false;

        private PageData() {
        }

        public PageData(Point point) {
            if (point == null) {
                throw new IllegalArgumentException("Page Data does not accept null points");
            }
            this.point = point;
        }

        public PageData(Point point, boolean isMinimized) {
            this(point);
            this.isMinimized = isMinimized;
        }

        public Point getPoint() {
            return this.point;
        }

        public boolean isMinimized() {
            return this.isMinimized;
        }
    }
}

