/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.knockout;

import javax.swing.Action;
import org.netbeans.modules.web.inspect.webkit.knockout.KnockoutChildFactory;
import org.netbeans.modules.web.inspect.webkit.knockout.RefreshAction;
import org.netbeans.modules.web.webkit.debugging.api.debugger.PropertyDescriptor;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class KnockoutNode
extends AbstractNode {
    private static final RequestProcessor RP = new RequestProcessor(KnockoutNode.class);
    private final RemoteObject remoteObject;
    private final ValueProperty valueProperty;
    KnockoutChildFactory childFactory;
    final String UNWRAP_SCRIPT = "function() {var ko = NetBeans.getKnockout(); return [ko.isObservable(this), ko.utils.unwrapObservable(this)]}";

    private KnockoutNode(String name, RemoteObject remoteObject, KnockoutChildFactory childFactory) {
        super(childFactory == null ? Children.LEAF : Children.create((ChildFactory)childFactory, (boolean)true));
        this.childFactory = childFactory;
        this.remoteObject = remoteObject;
        this.valueProperty = new ValueProperty(KnockoutNode.valueFor(remoteObject));
        this.setName(name);
        this.unwrap();
    }

    KnockoutNode(String name, RemoteObject remoteObject) {
        this(name, remoteObject, KnockoutNode.childFactoryFor(remoteObject));
    }

    static final KnockoutChildFactory childFactoryFor(RemoteObject remoteObject) {
        RemoteObject.Type type;
        boolean isLeaf = true;
        if (remoteObject != null && (type = remoteObject.getType()) == RemoteObject.Type.OBJECT && remoteObject.getDescription() != null) {
            isLeaf = false;
        }
        return isLeaf ? null : new KnockoutChildFactory(remoteObject);
    }

    final void unwrap() {
        if (this.remoteObject != null && this.remoteObject.getType() == RemoteObject.Type.FUNCTION) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    RemoteObject observableInfo = KnockoutNode.this.remoteObject.apply("function() {var ko = NetBeans.getKnockout(); return [ko.isObservable(this), ko.utils.unwrapObservable(this)]}");
                    boolean isObservable = false;
                    RemoteObject observable = null;
                    for (PropertyDescriptor descriptor : observableInfo.getProperties()) {
                        String name = descriptor.getName();
                        if ("0".equals(name)) {
                            isObservable = "true".equals(descriptor.getValue().getValueAsString());
                            continue;
                        }
                        if (!"1".equals(name)) continue;
                        observable = descriptor.getValue();
                    }
                    if (isObservable) {
                        KnockoutNode.this.childFactory = KnockoutNode.childFactoryFor(observable);
                        KnockoutNode.this.setChildren(KnockoutNode.this.childFactory == null ? Children.LEAF : Children.create((ChildFactory)KnockoutNode.this.childFactory, (boolean)true));
                        KnockoutNode.this.setName(KnockoutNode.this.getName() + "()");
                        KnockoutNode.this.valueProperty.setValueInternal(KnockoutNode.valueFor(observable));
                        KnockoutNode.this.firePropertyChange("value", null, null);
                    }
                }
            });
        }
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)this.valueProperty);
        sheet.put(set);
        return sheet;
    }

    void refresh() {
        if (this.childFactory != null) {
            this.childFactory.refresh();
        }
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(RefreshAction.class)};
    }

    private static String valueFor(RemoteObject remoteObject) {
        String value;
        if (remoteObject == null) {
            value = null;
        } else if (remoteObject.getType() == RemoteObject.Type.UNDEFINED) {
            value = NbBundle.getMessage(KnockoutNode.class, (String)"KnockoutNode.valueUndefined");
        } else {
            value = remoteObject.getDescription();
            if (value == null && remoteObject.getType() != RemoteObject.Type.OBJECT) {
                value = remoteObject.getValueAsString();
            }
        }
        return value;
    }

    static final class ValueProperty
    extends PropertySupport.ReadOnly<String> {
        static final String NAME = "value";
        private static final String DISPLAY_NAME = NbBundle.getMessage(ValueProperty.class, (String)"KnockoutNode.valueProperty.displayName");
        private static final String DESCRIPTION = NbBundle.getMessage(ValueProperty.class, (String)"KnockoutNode.valueProperty.description");
        private String value;

        ValueProperty(String value) {
            super(NAME, String.class, DISPLAY_NAME, DESCRIPTION);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        void setValueInternal(String value) {
            this.value = value;
        }
    }
}

