/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.indent.api.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.web.indent.api.LexUtilities;
import org.netbeans.modules.web.indent.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.web.indent.api.embedding.VirtualSource;
import org.netbeans.modules.web.indent.api.support.IndentCommand;
import org.netbeans.modules.web.indent.api.support.IndenterContextData;
import org.netbeans.modules.web.indent.api.support.IndenterFormattingContext;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public abstract class AbstractIndenter<T1 extends TokenId> {
    private Language<T1> language;
    private Context context;
    private int indentationSize;
    private static final Logger LOG = Logger.getLogger(AbstractIndenter.class.getName());
    protected static final boolean DEBUG = LOG.isLoggable(Level.FINE);
    protected static final boolean DEBUG_PERFORMANCE = Logger.getLogger("AbstractIndenter.PERF").isLoggable(Level.FINE);
    private static long startTime1;
    private static long startTimeTotal;
    private static final int MAX_INDENT = 200;
    public static boolean inUnitTestRun;
    private IndenterFormattingContext formattingContext;
    private boolean used = false;

    public AbstractIndenter(Language<T1> language, Context context) {
        this.language = language;
        this.context = context;
        this.indentationSize = AbstractIndenter.indentLevelSize((Document)this.getDocument(), language.mimeType());
        this.formattingContext = new IndenterFormattingContext(this.getDocument());
    }

    private static int indentLevelSize(Document doc, String mimeType) {
        Preferences prefs = CodeStylePreferences.get((Document)doc, (String)mimeType).getPreferences();
        int indentLevel = prefs.getInt("indent-shift-width", -1);
        if (indentLevel < 0) {
            boolean expandTabs = prefs.getBoolean("expand-tabs", true);
            indentLevel = expandTabs ? prefs.getInt("spaces-per-tab", 4) : prefs.getInt("tab-size", 8);
        }
        assert (indentLevel >= 0) : "Invalid indentLevelSize " + indentLevel + " for " + doc;
        return indentLevel;
    }

    public final IndenterFormattingContext createFormattingContext() {
        return this.formattingContext;
    }

    public final void beforeReindent(Collection<? extends IndenterFormattingContext> contexts) {
        assert (contexts.size() > 0) : "your IndentTask must implement Lookup.Provider and return an instance of IndenterFormattingContext in it";
        IndenterFormattingContext first = null;
        IndenterFormattingContext last = null;
        for (IndenterFormattingContext indenterFormattingContext : contexts) {
            if (indenterFormattingContext.isInitialized()) {
                return;
            }
            if (first == null) {
                first = indenterFormattingContext;
                first.initFirstIndenter();
            } else {
                indenterFormattingContext.setDelegate(first);
            }
            last = indenterFormattingContext;
        }
        assert (first != null);
        assert (last != null);
        last.setLastIndenter();
    }

    protected final int getIndentationSize() {
        return this.indentationSize;
    }

    protected final Context getContext() {
        return this.context;
    }

    protected final BaseDocument getDocument() {
        return (BaseDocument)this.context.document();
    }

    protected final Language<T1> getLanguage() {
        return this.language;
    }

    protected abstract int getFormatStableStart(JoinedTokenSequence<T1> var1, int var2, int var3, OffsetRanges var4) throws BadLocationException;

    protected abstract List<IndentCommand> getLineIndent(IndenterContextData<T1> var1, List<IndentCommand> var2) throws BadLocationException;

    protected abstract boolean isWhiteSpaceToken(Token<T1> var1);

    protected abstract void reset();

    public final void reindent() {
        if (this.used && DEBUG) {
            System.err.println("WARNING: indentation task cannot be reused! is this ok?");
        }
        this.used = true;
        this.reset();
        this.beforeReindent(this.context.getLookup().lookupAll(IndenterFormattingContext.class));
        this.formattingContext.disableListener();
        try {
            if (!this.formattingContext.isFirstIndenter()) {
                List<IndenterFormattingContext.Change> l = this.formattingContext.getAndClearChanges();
                if (l.size() > 0) {
                    this.updateLineOffsets(l);
                }
            } else {
                startTimeTotal = System.currentTimeMillis();
            }
            this.calculateIndentation();
            this.applyIndentation();
        }
        catch (BadLocationException ble) {
            if (inUnitTestRun) {
                throw new RuntimeException(ble);
            }
            Exceptions.printStackTrace((Throwable)ble);
        }
        finally {
            if (this.formattingContext.isLastIndenter()) {
                this.formattingContext.removeListener();
                if (DEBUG_PERFORMANCE) {
                    System.err.println("[IndPer] Total time " + (System.currentTimeMillis() - startTimeTotal) + " ms");
                }
            } else {
                this.formattingContext.enableListener();
            }
        }
    }

    private void calculateIndentation() throws BadLocationException {
        VirtualSource virtualSource;
        List<JoinedTokenSequence.CodeBlock<T1>> blocks;
        BaseDocument doc = this.getDocument();
        int startOffset = this.context.startOffset();
        int endOffset = this.context.endOffset();
        if (DEBUG) {
            System.err.println(">> AbstractIndenter based indenter: " + this.getClass().toString());
        }
        if (LOG.isLoggable(Level.FINER)) {
            System.err.println(">> TokenHierarchy of file to be indented:");
            System.err.println(TokenHierarchy.get((Document)doc));
        }
        if ((blocks = LexUtilities.createCodeBlocks(doc, this.language, virtualSource = this.createVirtualSource())) == null) {
            return;
        }
        if (DEBUG) {
            // empty if block
        }
        JoinedTokenSequence<T1> joinedTS = JoinedTokenSequence.createFromCodeBlocks(blocks);
        int start = Utilities.getRowStart((BaseDocument)doc, (int)startOffset);
        int end = Utilities.getRowEnd((BaseDocument)doc, (int)endOffset) + 1;
        if (end > doc.getLength()) {
            end = doc.getLength();
        }
        int initialOffset = 0;
        OffsetRanges rangesToIgnore = new OffsetRanges();
        if (start > 0) {
            TokenSequence<T1> ts = LexUtilities.getTokenSequence(doc, start, this.language);
            if (ts == null) {
                int newStart = this.findPreviousOccuranceOfOurLanguage(joinedTS, start);
                if (newStart == -1) {
                    return;
                }
                ts = LexUtilities.getTokenSequence(doc, newStart, this.language);
                start = newStart;
            }
            startTime1 = System.currentTimeMillis();
            initialOffset = this.getFormatStableStart(joinedTS, start, end, rangesToIgnore);
            if (DEBUG_PERFORMANCE) {
                System.err.println("[IndPer] Locating FormatStableStart took " + (System.currentTimeMillis() - startTime1) + " ms");
                System.err.println("[IndPer] Current line index is: " + Utilities.getLineOffset((BaseDocument)doc, (int)start));
                System.err.println("[IndPer] FormatStableStart line starts at index: " + Utilities.getLineOffset((BaseDocument)doc, (int)initialOffset));
                System.err.println("[IndPer] Number of ranges to ignore: " + rangesToIgnore.ranges.size());
            }
            if (DEBUG && !rangesToIgnore.isEmpty()) {
                System.err.println("Ignored ranges: " + rangesToIgnore.dump());
            }
        }
        ArrayList<Line> indentedLines = new ArrayList<Line>();
        startTime1 = System.currentTimeMillis();
        List<LinePair> linePairs = this.calculateLinePairs(blocks, initialOffset, end);
        if (DEBUG_PERFORMANCE) {
            System.err.println("[IndPer] calculateLinePairs (total pairs=" + linePairs.size() + ") took " + (System.currentTimeMillis() - startTime1) + " ms");
        }
        if (DEBUG) {
            System.err.println("line pairs to process=" + linePairs);
        }
        startTime1 = System.currentTimeMillis();
        this.processLanguage(joinedTS, linePairs, initialOffset, end, indentedLines, rangesToIgnore);
        if (DEBUG_PERFORMANCE) {
            System.err.println("[IndPer] processLanguage (" + this.getContext().mimePath() + ") took " + (System.currentTimeMillis() - startTime1) + " ms");
        }
        assert (this.formattingContext.getIndentationData() != null);
        List<List<Line>> indentationData = this.formattingContext.getIndentationData();
        indentationData.add(indentedLines);
    }

    private int findPreviousOccuranceOfOurLanguage(JoinedTokenSequence<T1> ts, int start) throws BadLocationException {
        int offset;
        int lineStart = Utilities.getRowStart((BaseDocument)this.getDocument(), (int)start);
        if (lineStart > 0) {
            --lineStart;
        }
        if ((offset = Utilities.getFirstNonWhiteRow((BaseDocument)this.getDocument(), (int)start, (boolean)false)) == -1) {
            offset = 0;
        }
        if (ts.move(lineStart = Utilities.getRowStart((BaseDocument)this.getDocument(), (int)offset), true)) {
            if (!ts.moveNext()) {
                ts.movePrevious();
            }
            if ((offset = ts.offset()) > start) {
                return -1;
            }
            return offset;
        }
        return -1;
    }

    private void applyIndentation() throws BadLocationException {
        if (!this.formattingContext.isLastIndenter()) {
            return;
        }
        startTime1 = System.currentTimeMillis();
        this.recalculateLineIndexes();
        if (DEBUG_PERFORMANCE) {
            System.err.println("[IndPer] recalculateLineIndexes took " + (System.currentTimeMillis() - startTime1) + " ms");
        }
        int lineStart = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)this.context.startOffset());
        int lineEnd = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)this.context.endOffset());
        assert (this.formattingContext.getIndentationData() != null);
        List<List<Line>> indentationData = this.formattingContext.getIndentationData();
        startTime1 = System.currentTimeMillis();
        List<Line> indentedLines = this.mergeIndentedLines(indentationData);
        if (DEBUG_PERFORMANCE) {
            System.err.println("[IndPer] mergeIndentedLines took " + (System.currentTimeMillis() - startTime1) + " ms");
        }
        if (DEBUG) {
            System.err.println("Merged line data:");
            for (Line l : indentedLines) {
                this.debugIndentation(l.lineStartOffset, l.lineIndent, this.getDocument().getText(l.lineStartOffset, l.lineEndOffset - l.lineStartOffset + 1).replace("\n", "").replace("\r", "").trim(), l.indentThisLine);
            }
        }
        if (indentedLines.isEmpty()) {
            return;
        }
        this.applyIndents(indentedLines, lineStart, lineEnd);
    }

    private VirtualSource createVirtualSource() {
        boolean isEmbedded;
        String mimeType = (String)this.getDocument().getProperty((Object)"mimeType");
        boolean bl = isEmbedded = !this.getLanguage().mimeType().equals(mimeType);
        if (!isEmbedded) {
            return null;
        }
        for (VirtualSource.Factory factory : Lookup.getDefault().lookupAll(VirtualSource.Factory.class)) {
            VirtualSource vs = factory.createVirtualSource((Document)this.getDocument(), this.language.mimeType());
            if (vs == null) continue;
            if (DEBUG) {
                System.err.println("Virtual Source found:" + vs.toString());
            }
            return vs;
        }
        return null;
    }

    private List<ForeignLanguageBlock> eliminateUnneededBlocks(List<ForeignLanguageBlock> blocks, List<Line> all) {
        ArrayList<ForeignLanguageBlock> newBlocks = new ArrayList<ForeignLanguageBlock>();
        for (ForeignLanguageBlock b : blocks) {
            if (this.findLineByLineIndex(all, b.startLine + 1) != null) continue;
            newBlocks.add(b);
        }
        Comparator<ForeignLanguageBlock> c = new Comparator<ForeignLanguageBlock>(){

            @Override
            public int compare(ForeignLanguageBlock o1, ForeignLanguageBlock o2) {
                int res = o1.startLine - o2.startLine;
                if (res == 0) {
                    res = o1.endLine - o2.endLine;
                }
                return res;
            }
        };
        newBlocks.sort(c);
        ArrayList<ForeignLanguageBlock> result = new ArrayList<ForeignLanguageBlock>();
        for (ForeignLanguageBlock b : newBlocks) {
            this.addBlockAndMergeIfNeeded(result, b);
        }
        return result;
    }

    private void addBlockAndMergeIfNeeded(List<ForeignLanguageBlock> newBlocks, ForeignLanguageBlock toAdd) {
        if (newBlocks.isEmpty()) {
            newBlocks.add(toAdd);
            return;
        }
        ForeignLanguageBlock b = newBlocks.get(newBlocks.size() - 1);
        assert (toAdd.startLine >= b.startLine || toAdd.endLine <= b.endLine) : "blocks: " + newBlocks + " toAdd:" + toAdd;
        if (toAdd.startLine < b.startLine || toAdd.endLine > b.endLine) {
            if (toAdd.startLine >= b.startLine && toAdd.startLine <= b.endLine) {
                b.endLine = toAdd.endLine;
            } else {
                newBlocks.add(toAdd);
            }
        }
    }

    private void extractForeignLanguageBlocks(List<ForeignLanguageBlock> blocks, List<Line> lines) throws BadLocationException {
        int start = -1;
        for (Line l : lines) {
            ArrayList<IndentCommand> cmds = new ArrayList<IndentCommand>();
            for (IndentCommand ic : l.lineIndent) {
                if (ic.getType() == IndentCommand.Type.BLOCK_START) {
                    start = l.index;
                    continue;
                }
                if (ic.getType() == IndentCommand.Type.BLOCK_END) {
                    if (start == -1) continue;
                    int end = l.index;
                    if (end - start > 1) {
                        blocks.add(new ForeignLanguageBlock(start, end));
                    }
                    start = -1;
                    continue;
                }
                cmds.add(ic);
            }
            if (cmds.size() == l.lineIndent.size()) continue;
            l.lineIndent = cmds;
            if (!cmds.isEmpty()) continue;
            cmds.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, l.offset, this.getIndentationSize()));
        }
    }

    private void applyStoredBlocks(List<Line> all, List<ForeignLanguageBlock> blocks) {
        for (ForeignLanguageBlock b : blocks) {
            Line l = this.findLineByLineIndex(all, b.startLine);
            assert (l != null) : "" + b;
            l.foreignLanguageBlockStart = true;
            l = this.findLineByLineIndex(all, b.endLine);
            assert (l != null) : "fb=" + b + " lines=" + all;
            l.foreignLanguageBlockEnd = true;
        }
    }

    private List<Line> mergeIndentedLines(List<List<Line>> indentationData) throws BadLocationException {
        for (List<Line> l : indentationData) {
            this.addLanguageEndLine(l);
        }
        List<ForeignLanguageBlock> blocks = new ArrayList<ForeignLanguageBlock>();
        ArrayList<LineCommandsPair> pairs = new ArrayList<LineCommandsPair>();
        for (List<Line> l : indentationData) {
            this.simplifyIndentationCommands(pairs, l);
            this.extractForeignLanguageBlocks(blocks, l);
            this.handleLanguageGaps(pairs, l);
            this.extractCommandsFromNonIndentableLines(pairs, l);
        }
        List<Line> all = new ArrayList<Line>();
        for (List<Line> l : indentationData) {
            all = AbstractIndenter.mergeProcessedIndentedLines(all, l);
        }
        if (all.isEmpty()) {
            return all;
        }
        blocks = this.eliminateUnneededBlocks(blocks, all);
        this.applyStoredBlocks(all, blocks);
        this.applyStoredCommads(all, pairs);
        return all;
    }

    private void handleLanguageGaps(List<LineCommandsPair> pairs, List<Line> lines) {
        ArrayList<Line> newLines = new ArrayList<Line>();
        Line prevLine = null;
        for (Line l : lines) {
            if (prevLine != null && prevLine.index + 1 != l.index) {
                ArrayList<IndentCommand> removed = new ArrayList<IndentCommand>();
                ArrayList<IndentCommand> kept = new ArrayList<IndentCommand>();
                boolean keepRemoving = true;
                for (IndentCommand ic : l.lineIndent) {
                    if (keepRemoving && ic.getType() == IndentCommand.Type.INDENT) {
                        removed.add(ic);
                        continue;
                    }
                    kept.add(ic);
                    keepRemoving = false;
                }
                l.lineIndent = kept;
                if (l.lineIndent.isEmpty()) {
                    l.lineIndent.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, l.offset, this.getIndentationSize()));
                }
                if (removed.size() > 0) {
                    pairs.add(new LineCommandsPair(prevLine.index + 1, removed));
                }
            }
            newLines.add(l);
            prevLine = l;
        }
        lines.clear();
        lines.addAll(newLines);
    }

    private void extractCommandsFromNonIndentableLines(List<LineCommandsPair> pairs, List<Line> lines) {
        ArrayList<Line> newLines = new ArrayList<Line>();
        Line previousLine = null;
        for (Line l : lines) {
            if (!l.indentThisLine) {
                ArrayList<IndentCommand> accepted = new ArrayList<IndentCommand>();
                ArrayList<IndentCommand> nextLine = new ArrayList<IndentCommand>();
                for (IndentCommand ic : l.lineIndent) {
                    if (ic.getType() == IndentCommand.Type.INDENT) {
                        accepted.add(ic);
                        continue;
                    }
                    if (ic.getType() != IndentCommand.Type.RETURN) continue;
                    if (!(previousLine != null && previousLine.index + 1 == l.index || l.emptyLine)) {
                        nextLine.add(ic);
                        continue;
                    }
                    accepted.add(ic);
                }
                if (accepted.size() > 0) {
                    pairs.add(new LineCommandsPair(l.index, accepted));
                }
                if (nextLine.size() > 0) {
                    pairs.add(new LineCommandsPair(l.index + 1, nextLine));
                }
                l.lineIndent = new ArrayList();
                l.lineIndent.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, l.offset, this.getIndentationSize()));
                newLines.add(l);
            } else {
                newLines.add(l);
            }
            previousLine = l;
        }
        lines.clear();
        lines.addAll(newLines);
    }

    private void addLanguageEndLine(List<Line> lines) throws BadLocationException {
        if (lines.isEmpty()) {
            return;
        }
        Line lastLine = lines.get(lines.size() - 1);
        if (lastLine.preliminaryNextLineIndent.isEmpty()) {
            return;
        }
        int lineIndex = lastLine.index + 1;
        int offset = Utilities.getRowStartFromLineOffset((BaseDocument)this.getDocument(), (int)lineIndex);
        if (offset == -1) {
            return;
        }
        Line l = this.generateBasicLine(lineIndex);
        l.indentThisLine = false;
        l.lineIndent = new ArrayList(lastLine.preliminaryNextLineIndent);
        lines.add(l);
    }

    private static List<Line> mergeProcessedIndentedLines(List<Line> originalLines, List<Line> newLines) {
        ArrayList<Line> merged = new ArrayList<Line>();
        Iterator<Line> it1 = originalLines.iterator();
        Iterator<Line> it2 = newLines.iterator();
        Line l1 = null;
        Line l2 = null;
        if (it1.hasNext()) {
            l1 = it1.next();
        }
        if (it2.hasNext()) {
            l2 = it2.next();
        }
        while (l1 != null && l2 != null) {
            boolean move2;
            boolean move1;
            if (l1.index < l2.index) {
                merged.add(l1);
                move1 = true;
                move2 = false;
            } else if (l1.index > l2.index) {
                merged.add(l2);
                move1 = false;
                move2 = true;
            } else {
                if (l1.indentThisLine) {
                    merged.add(l1);
                } else {
                    assert (!l1.indentThisLine);
                    merged.add(l2);
                }
                move1 = true;
                move2 = true;
            }
            if (move1) {
                l1 = it1.hasNext() ? it1.next() : null;
            }
            if (!move2) continue;
            if (it2.hasNext()) {
                l2 = it2.next();
                continue;
            }
            l2 = null;
        }
        if (l1 != null) {
            merged.add(l1);
        } else if (l2 != null) {
            merged.add(l2);
        }
        while (it1.hasNext()) {
            merged.add(it1.next());
        }
        while (it2.hasNext()) {
            merged.add(it2.next());
        }
        return merged;
    }

    private void applyStoredCommads(List<Line> all, List<LineCommandsPair> pairs) throws BadLocationException {
        Comparator<LineCommandsPair> c = new Comparator<LineCommandsPair>(){

            @Override
            public int compare(LineCommandsPair o1, LineCommandsPair o2) {
                return o1.line - o2.line;
            }
        };
        ArrayList<LineCommandsPair> s1 = new ArrayList<LineCommandsPair>(pairs);
        s1.sort(c);
        ArrayList<LineCommandsPair> s2 = new ArrayList<LineCommandsPair>();
        LineCommandsPair previous = null;
        for (LineCommandsPair pair : s1) {
            if (previous != null && previous.line == pair.line) {
                previous.commands.addAll(pair.commands);
                continue;
            }
            s2.add(pair);
            previous = pair;
        }
        Iterator<Line> it = all.iterator();
        assert (all.size() > 0);
        Line l = null;
        Line lastLine = null;
        for (LineCommandsPair pair : s2) {
            while (it.hasNext() && (l == null || l.index < pair.line)) {
                l = it.next();
            }
            assert (l != null);
            if (l.index >= pair.line) {
                ArrayList<IndentCommand> commands = new ArrayList<IndentCommand>(pair.commands);
                for (IndentCommand ic : l.lineIndent) {
                    if (ic.getType() == IndentCommand.Type.NO_CHANGE && (ic.getType() != IndentCommand.Type.NO_CHANGE || !commands.isEmpty())) continue;
                    commands.add(ic);
                }
                l.lineIndent = commands;
                continue;
            }
            assert (!it.hasNext());
            if (lastLine == null) {
                int offset = Utilities.getRowStartFromLineOffset((BaseDocument)this.getDocument(), (int)pair.line);
                if (offset == -1) break;
                lastLine = this.generateBasicLine(pair.line);
                lastLine.lineIndent = new ArrayList(pair.commands);
                continue;
            }
            lastLine.lineIndent.addAll(pair.commands);
        }
        if (lastLine != null) {
            all.add(lastLine);
        }
    }

    private void simplifyIndentationCommands(List<LineCommandsPair> pairs, List<Line> lines) {
        boolean firstContinue = true;
        boolean inContinue = false;
        boolean fixedIndentContinue = false;
        Line lastLineWithContinue = null;
        for (Line l : lines) {
            ArrayList<IndentCommand> commands = new ArrayList<IndentCommand>();
            for (IndentCommand ic : l.lineIndent) {
                if (ic.getType() == IndentCommand.Type.CONTINUE) {
                    if (firstContinue) {
                        IndentCommand ic2;
                        if (ic.getFixedIndentSize() != -1) {
                            ic2 = new IndentCommand(IndentCommand.Type.INDENT, ic.getLineOffset(), this.getIndentationSize());
                            ic2.setFixedIndentSize(ic.getFixedIndentSize());
                            ic2.setWasContinue();
                            commands.add(ic2);
                            fixedIndentContinue = true;
                        } else {
                            ic2 = new IndentCommand(IndentCommand.Type.INDENT, ic.getLineOffset(), this.getIndentationSize());
                            ic2.setWasContinue();
                            commands.add(ic2);
                            fixedIndentContinue = false;
                        }
                        firstContinue = false;
                        inContinue = true;
                    }
                    lastLineWithContinue = l;
                    continue;
                }
                if (inContinue && ic.getType() != IndentCommand.Type.PRESERVE_INDENTATION) {
                    ArrayList<IndentCommand> listToAddTo = commands;
                    assert (lastLineWithContinue != null);
                    if (l.index - lastLineWithContinue.index > 1) {
                        ArrayList<IndentCommand> list = new ArrayList<IndentCommand>();
                        pairs.add(new LineCommandsPair(lastLineWithContinue.index + 1, list));
                        listToAddTo = list;
                    }
                    if (fixedIndentContinue) {
                        listToAddTo.add(new IndentCommand(IndentCommand.Type.RETURN, ic.getLineOffset(), this.getIndentationSize()));
                    } else {
                        listToAddTo.add(new IndentCommand(IndentCommand.Type.RETURN, ic.getLineOffset(), this.getIndentationSize()));
                    }
                    inContinue = false;
                    firstContinue = true;
                }
                if (ic.getType() == IndentCommand.Type.NO_CHANGE && (ic.getType() != IndentCommand.Type.NO_CHANGE || !commands.isEmpty())) continue;
                commands.add(ic);
            }
            if (commands.isEmpty()) {
                IndentCommand ic2 = new IndentCommand(IndentCommand.Type.NO_CHANGE, l.lineStartOffset, this.getIndentationSize());
                if (inContinue) {
                    ic2.setWasContinue();
                }
                commands.add(ic2);
            }
            l.lineIndent = commands;
        }
    }

    private void updateLineOffsets(List<IndenterFormattingContext.Change> l) {
        if (DEBUG) {
            System.err.println("update line offset with following deltas:" + l);
        }
        for (List<Line> lines : this.formattingContext.getIndentationData()) {
            for (Line line : lines) {
                for (IndenterFormattingContext.Change ch : l) {
                    if (ch.offset > line.offset) continue;
                    line.updateOffset(ch.change);
                }
            }
        }
    }

    private void recalculateLineIndexes() throws BadLocationException {
        for (List<Line> lines : this.formattingContext.getIndentationData()) {
            ArrayList<Line> l = new ArrayList<Line>();
            Line previousLine = null;
            for (Line line : lines) {
                line.recalculateLineIndex(this.getDocument());
                if (previousLine != null && previousLine.index == line.index) {
                    if (DEBUG) {
                        System.err.println("WARNING: some lines where deleted by other formatter. merging " + previousLine + " with " + line);
                    }
                    previousLine.lineIndent.addAll(line.lineIndent);
                } else {
                    l.add(line);
                }
                previousLine = line;
            }
            if (l.size() == lines.size()) continue;
            lines.clear();
            lines.addAll(l);
        }
    }

    private List<LinePair> calculateLinePairs(List<JoinedTokenSequence.CodeBlock<T1>> blocks, int startOffset, int endOffset) throws BadLocationException {
        ArrayList<LinePair> lps = new ArrayList<LinePair>();
        LinePair lastOne = null;
        int startLine = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)startOffset);
        int endLine = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)endOffset);
        block0: for (JoinedTokenSequence.CodeBlock<T1> block : blocks) {
            for (JoinedTokenSequence.TokenSequenceWrapper tsw : block.tss) {
                if (tsw.isVirtual()) continue;
                LinePair lp = new LinePair();
                lp.startingLine = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)LexUtilities.getTokenSequenceStartOffset(tsw.getTokenSequence()));
                lp.endingLine = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)LexUtilities.getTokenSequenceEndOffset(tsw.getTokenSequence()));
                if (lp.startingLine > endLine) continue block0;
                if (lp.startingLine < startLine) {
                    if (startLine > lp.endingLine) continue;
                    lp.startingLine = startLine;
                }
                if (lp.endingLine > endLine) {
                    lp.endingLine = endLine;
                }
                if (lastOne != null && lastOne.endingLine == lp.startingLine) {
                    lastOne.endingLine = lp.endingLine;
                    continue;
                }
                lps.add(lp);
                lastOne = lp;
            }
        }
        return lps;
    }

    private void processLanguage(JoinedTokenSequence<T1> joinedTS, List<LinePair> lines, int overallStartOffset, int overallEndOffset, List<Line> lineIndents, OffsetRanges rangesToIgnore) throws BadLocationException {
        List l;
        BaseDocument doc = this.getDocument();
        joinedTS.moveStart();
        joinedTS.moveNext();
        for (LinePair lp : lines) {
            int realStartingLine = lp.startingLine;
            int realEndingLine = lp.endingLine;
            if (realEndingLine > realStartingLine && !this.doesLineStartWithOurLanguage(doc, realStartingLine, joinedTS)) {
                ++realStartingLine;
            }
            if (realEndingLine > realStartingLine && !this.doesLineStartWithOurLanguage(doc, realEndingLine, joinedTS)) {
                --realEndingLine;
            }
            for (int line = lp.startingLine; line <= lp.endingLine; ++line) {
                int rowStartOffset = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)line);
                if (rowStartOffset < overallStartOffset) {
                    rowStartOffset = overallStartOffset;
                }
                int firstNonWhite = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)rowStartOffset);
                int rowEndOffset = Utilities.getRowEnd((BaseDocument)doc, (int)rowStartOffset);
                int nextLineStartOffset = rowEndOffset + 1;
                if (rangesToIgnore.contains(rowStartOffset, rowEndOffset)) continue;
                boolean indentThisLine = true;
                boolean emptyLine = false;
                if (firstNonWhite != -1) {
                    String st;
                    int newRowStartOffset = this.findLanguageOffset(joinedTS, rowStartOffset, rowEndOffset, true);
                    if (newRowStartOffset > overallEndOffset) continue;
                    rowEndOffset = this.findLanguageOffset(joinedTS, rowEndOffset, rowStartOffset, false);
                    rowStartOffset = newRowStartOffset;
                    if (rowStartOffset == -1 || rowEndOffset == -1 || rowStartOffset > rowEndOffset) continue;
                    if (rowEndOffset > overallEndOffset) {
                        rowEndOffset = overallEndOffset;
                    }
                    boolean bl = indentThisLine = firstNonWhite == rowStartOffset;
                    if (!indentThisLine && rowStartOffset - firstNonWhite == 2 && ("#{".equals(st = doc.getText(firstNonWhite, 2)) || "${".equals(st))) {
                        indentThisLine = true;
                    }
                } else {
                    emptyLine = true;
                    Language<? extends TokenId> l2 = LexUtilities.getLanguage(this.getDocument(), rowStartOffset);
                    if (l2 == null || !l2.equals(this.language)) continue;
                }
                int[] newOffset = new int[2];
                if (rangesToIgnore.calculateUncoveredArea(rowStartOffset, rowEndOffset, newOffset)) {
                    rowStartOffset = newOffset[0];
                    rowEndOffset = newOffset[1];
                    if (rowStartOffset == -1 && rowEndOffset == -1) continue;
                }
                if (firstNonWhite < rowStartOffset) {
                    firstNonWhite = rowStartOffset;
                }
                IndenterContextData<T1> cd = new IndenterContextData<T1>(joinedTS, rowStartOffset, rowEndOffset, firstNonWhite, nextLineStartOffset, emptyLine, indentThisLine);
                cd.setLanguageBlockStart(line == realStartingLine);
                cd.setLanguageBlockEnd(line == realEndingLine);
                ArrayList<IndentCommand> preliminaryNextLineIndent = new ArrayList<IndentCommand>();
                List<IndentCommand> iis = this.getLineIndent(cd, preliminaryNextLineIndent);
                if (iis.isEmpty()) {
                    throw new IllegalStateException("getLineIndent must always return at least IndentInstance.Type.NO_CHANGE");
                }
                if (preliminaryNextLineIndent.isEmpty()) {
                    throw new IllegalStateException("preliminaryNextLineIndent from getLineIndent must always return at least IndentInstance.Type.NO_CHANGE");
                }
                Line ln = this.generateBasicLine(line);
                ln.lineIndent = iis;
                ln.preliminaryNextLineIndent = preliminaryNextLineIndent;
                ln.lineStartOffset = rowStartOffset;
                ln.lineEndOffset = rowEndOffset;
                ln.indentThisLine = indentThisLine;
                ln.emptyLine = emptyLine;
                lineIndents.add(ln);
                if (!DEBUG) continue;
                this.debugIndentation(cd.getLineStartOffset(), iis, this.getDocument().getText(rowStartOffset, rowEndOffset - rowStartOffset + 1).replace("\n", "").replace("\r", "").trim(), ln.indentThisLine);
            }
        }
        if (DEBUG && lineIndents.size() > 0 && (l = lineIndents.get(lineIndents.size() - 1).preliminaryNextLineIndent).size() > 0) {
            System.err.println("Preliminary indent commands for next line:" + l);
        }
    }

    private boolean doesLineStartWithOurLanguage(BaseDocument doc, int lineIndex, JoinedTokenSequence<T1> joinedTS) throws BadLocationException {
        int newRowStartOffset;
        int rowStartOffset = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)lineIndex);
        int rowEndOffset = Utilities.getRowEnd((BaseDocument)doc, (int)rowStartOffset);
        int firstNonWhite = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)rowStartOffset);
        return firstNonWhite == -1 || (newRowStartOffset = this.findLanguageOffset(joinedTS, rowStartOffset, rowEndOffset, true)) != -1;
    }

    private int findLanguageOffset(JoinedTokenSequence<T1> joinedTS, int rowStartOffset, int rowEndOffset, boolean forward) {
        if (!joinedTS.move(rowStartOffset, forward)) {
            return -1;
        }
        if (!joinedTS.moveNext()) {
            if (!forward) {
                if (!joinedTS.movePrevious()) {
                    return -1;
                }
            } else {
                return -1;
            }
        }
        while (forward ? joinedTS.offset() <= rowEndOffset : joinedTS.offset() + joinedTS.token().length() >= rowEndOffset) {
            boolean ws;
            TokenSequence<?> ts;
            boolean ok;
            int tokenStart = joinedTS.offset();
            int tokenEnd = joinedTS.offset() + joinedTS.token().length();
            boolean bl = ok = joinedTS.embedded() == null;
            if (!ok && !(ts = joinedTS.embedded()).isEmpty()) {
                int start = LexUtilities.getTokenSequenceStartOffset(ts);
                int end = LexUtilities.getTokenSequenceEndOffset(ts);
                if (forward) {
                    if (start > tokenStart && tokenStart >= rowStartOffset) {
                        ok = true;
                        tokenEnd = tokenStart + (start - tokenStart);
                    } else if (end < tokenEnd && end >= rowStartOffset) {
                        ok = true;
                        tokenStart = end;
                    }
                } else if (end < tokenEnd && tokenEnd <= rowStartOffset) {
                    ok = true;
                    tokenStart = end;
                } else if (start > tokenStart && start <= rowStartOffset) {
                    ok = true;
                    tokenEnd = tokenStart + (start - tokenStart);
                }
            }
            if (ok && joinedTS.language() == this.language && !joinedTS.isCurrentTokenSequenceVirtual() && !(ws = this.isWhiteSpaceToken(joinedTS, rowStartOffset, rowEndOffset, forward))) {
                int offset = rowStartOffset >= tokenStart && rowStartOffset <= tokenEnd ? rowStartOffset : (rowStartOffset < tokenStart ? tokenStart : tokenEnd);
                offset = this.findNonWhiteSpaceCharacter(joinedTS, offset, forward);
                return offset;
            }
            if (!(forward ? !joinedTS.moveNext() : !joinedTS.movePrevious())) continue;
            break;
        }
        return -1;
    }

    private boolean isWhiteSpaceToken(JoinedTokenSequence<T1> joinedTS, int rowStartOffset, int rowEndOffset, boolean forward) {
        int start = joinedTS.offset();
        int end = joinedTS.offset() + joinedTS.token().length();
        if (forward) {
            if (rowStartOffset > start) {
                start = Math.min(rowStartOffset, end);
            }
            if (rowEndOffset < end) {
                end = Math.max(rowEndOffset, start);
            }
        } else {
            if (rowEndOffset > start) {
                start = Math.min(rowEndOffset, end);
            }
            if (rowStartOffset < end) {
                end = Math.max(rowStartOffset, start);
            }
        }
        return CharSequenceUtilities.trim((CharSequence)joinedTS.token().text().subSequence(start - joinedTS.offset(), end - joinedTS.offset())).length() == 0;
    }

    private int findNonWhiteSpaceCharacter(JoinedTokenSequence<T1> joinedTS, int offset, boolean forward) {
        CharSequence tokenText = joinedTS.token().text();
        int tokenStart = joinedTS.offset();
        int index = offset - tokenStart;
        if (!forward && index == tokenText.length()) {
            --index;
        }
        while ((forward ? index < tokenText.length() : index > 0) && tokenText.charAt(index) == ' ' || tokenText.charAt(index) == '\t') {
            if (forward) {
                ++index;
                continue;
            }
            --index;
        }
        return tokenStart + index;
    }

    private static int getCalulatedIndexOfPreviousIndent(List<IndentCommand> indentations, int shift) {
        int balance = 1;
        int i = indentations.size();
        if (i == 0) {
            return -1;
        }
        do {
            if (indentations.get(--i).getType() == IndentCommand.Type.RETURN) {
                ++balance;
            }
            if (indentations.get(i).getType() != IndentCommand.Type.INDENT) continue;
            --balance;
        } while (balance != 0 && i > 0);
        if (balance != 0 || indentations.get(i).getType() != IndentCommand.Type.INDENT) {
            if (DEBUG) {
                System.err.println("WARNING: cannot find INDENT command corresponding to RETURN command at index " + (indentations.size() - 1) + ". make sure RETURN and INDENT commands are always paired. this can be caused by wrong getFormatStableStart but also by user typing code which is not syntactically correct. commands:" + (indentations.size() < 30 ? indentations : "[too many commands]"));
            }
            if (i + shift < 0) {
                i = 0 - shift;
            }
        }
        if (i + shift < 0) {
            return -1;
        }
        return i + shift;
    }

    private int calculateLineIndent(int indentation, List<Line> lines, Line line, List<IndentCommand> currentLineIndents, List<IndentCommand> allPreviousCommands, boolean update, int lineStart) throws BadLocationException {
        currentLineIndents = this.cleanUpAndPossiblyClone(currentLineIndents, !update);
        boolean beingFormatted = line != null ? line.index >= lineStart : false;
        int thisLineIndent = 0;
        UnmodifiableButExtendableList<IndentCommand> allCommands = new UnmodifiableButExtendableList<IndentCommand>(allPreviousCommands);
        int preservedLineIndentation = -1;
        for (IndentCommand ii : currentLineIndents) {
            switch (ii.getType()) {
                case NO_CHANGE: {
                    break;
                }
                case INDENT: {
                    if (ii.getFixedIndentSize() != -1) {
                        thisLineIndent = ii.getFixedIndentSize();
                        break;
                    }
                    thisLineIndent += ii.getIndentationSize() != -1 ? ii.getIndentationSize() : this.indentationSize;
                    break;
                }
                case RETURN: {
                    int index = AbstractIndenter.getCalulatedIndexOfPreviousIndent(allCommands, -1);
                    if (index == -1) break;
                    indentation = ((IndentCommand)allCommands.get(index)).getCalculatedIndentation();
                    thisLineIndent = 0;
                    break;
                }
                case DO_NOT_INDENT_THIS_LINE: {
                    if (!update) break;
                    line.indentThisLine = false;
                    break;
                }
                case PRESERVE_INDENTATION: {
                    if (!update) break;
                    line.preserveThisLineIndent = true;
                    if (line.index != lineStart || ii.getFixedIndentSize() == -1 || !this.context.isIndent()) break;
                    preservedLineIndentation = ii.getFixedIndentSize();
                }
            }
            ii.setCalculatedIndentation(indentation + thisLineIndent);
            allCommands.add(ii);
        }
        int lineIndentation = currentLineIndents.get(currentLineIndents.size() - 1).getCalculatedIndentation();
        int lineIndentAdjustment = 0;
        if (!(line == null || line.preserveThisLineIndent || beingFormatted || line.emptyLine)) {
            lineIndentAdjustment = line.existingLineIndent - lineIndentation;
        }
        IndentCommand ii = currentLineIndents.get(currentLineIndents.size() - 1);
        if (lineIndentAdjustment != 0 && !beingFormatted) {
            ii.setCalculatedIndentation(ii.getCalculatedIndentation() + lineIndentAdjustment);
        }
        if (beingFormatted) {
            lineIndentation = currentLineIndents.get(currentLineIndents.size() - 1).getCalculatedIndentation();
        }
        if (update) {
            line.indentation = lineIndentation;
            line.indentationAdjustment = lineIndentAdjustment;
        }
        if (preservedLineIndentation != -1) {
            line.indentation = preservedLineIndentation;
            assert (line.indentationAdjustment == 0);
        }
        return currentLineIndents.get(currentLineIndents.size() - 1).getCalculatedIndentation();
    }

    private List<IndentCommand> cleanUpAndPossiblyClone(List<IndentCommand> commands, boolean clone) {
        if (!clone) {
            return commands;
        }
        ArrayList<IndentCommand> newItems = new ArrayList<IndentCommand>();
        for (int i = 0; i < commands.size(); ++i) {
            IndentCommand item = commands.get(i);
            newItems.add(clone ? item.cloneMe() : item);
        }
        return newItems;
    }

    private Line findLineByLineIndex(List<Line> lines, int index) {
        for (Line l : lines) {
            if (l == null) continue;
            if (l.index == index) {
                return l;
            }
            if (l.index <= index) continue;
            break;
        }
        return null;
    }

    private void applyIndents(final List<Line> indentedLines, final int lineStart, final int lineEnd) throws BadLocationException {
        final BadLocationException[] ex = new BadLocationException[1];
        this.getDocument().runAtomic(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractIndenter.this.applyIndents0(indentedLines, lineStart, lineEnd);
                }
                catch (BadLocationException ble) {
                    ex[0] = ble;
                }
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
    }

    private void applyIndents0(List<Line> indentedLines, int lineStart, int lineEnd) throws BadLocationException {
        if (DEBUG) {
            System.err.println(">> reindentation done by all AbstractIndenter subclasses:");
        }
        boolean indentEmptyLines = this.context.isIndent();
        int indentation = 0;
        ArrayList<IndentCommand> commands = new ArrayList<IndentCommand>();
        int nextLineIndent = -1;
        Line previousLine = null;
        HashMap<Integer, Integer> suggestedIndentsForOtherLines = new HashMap<Integer, Integer>();
        startTime1 = System.currentTimeMillis();
        for (Line line : indentedLines) {
            if (previousLine != null && previousLine.index + 1 != line.index) {
                for (int i = previousLine.index + 1; i < line.index; ++i) {
                    suggestedIndentsForOtherLines.put(i, nextLineIndent);
                }
            }
            indentation = this.calculateLineIndent(indentation, indentedLines, line, line.lineIndent, commands, true, lineStart);
            if (line.emptyLine && !indentEmptyLines) {
                line.indentation = 0;
            }
            commands.addAll(line.lineIndent);
            if (!line.indentThisLine) {
                suggestedIndentsForOtherLines.put(line.index, indentation);
            }
            nextLineIndent = this.calculateLineIndent(indentation, indentedLines, null, line.preliminaryNextLineIndent, commands, false, lineStart);
            previousLine = line;
        }
        if (DEBUG_PERFORMANCE) {
            System.err.println("[IndPer] calculateLineIndent took " + (System.currentTimeMillis() - startTime1) + " ms");
        }
        for (int i = previousLine.index + 1; i <= lineEnd; ++i) {
            suggestedIndentsForOtherLines.put(i, nextLineIndent);
        }
        startTime1 = System.currentTimeMillis();
        this.updateIndentationForPreservedLines(indentedLines, this.context.isIndent() ? lineStart : -1);
        if (DEBUG_PERFORMANCE) {
            System.err.println("[IndPer] updateIndentationForPreservedLines took " + (System.currentTimeMillis() - startTime1) + " ms");
        }
        startTime1 = System.currentTimeMillis();
        indentedLines = this.generateBlockIndentsForForeignLanguage(indentedLines, suggestedIndentsForOtherLines);
        if (DEBUG_PERFORMANCE) {
            System.err.println("[IndPer] generateBlockIndentsForForeignLanguage took " + (System.currentTimeMillis() - startTime1) + " ms");
        }
        if (DEBUG) {
            System.err.println(">> line data:");
            for (Line line : indentedLines) {
                System.err.println(" " + line.dump());
            }
            System.err.println(">> line indentations:");
            for (Line line : indentedLines) {
                if (!line.indentThisLine) continue;
                this.debugLineIndentation(line, line.index >= lineStart && line.index <= lineEnd);
            }
        }
        startTime1 = System.currentTimeMillis();
        this.storeIndentsForOtherFormatters(suggestedIndentsForOtherLines);
        if (DEBUG_PERFORMANCE) {
            System.err.println("[IndPer] storeIndentsForOtherFormatters took " + (System.currentTimeMillis() - startTime1) + " ms");
        }
        startTime1 = System.currentTimeMillis();
        this.modifyDocument(indentedLines, lineStart, lineEnd);
        if (DEBUG_PERFORMANCE) {
            System.err.println("[IndPer] modifyDocument took " + (System.currentTimeMillis() - startTime1) + " ms");
        }
    }

    private void storeIndentsForOtherFormatters(Map<Integer, Integer> suggestedIndentsForOtherLines) {
        this.getDocument().putProperty((Object)"AbstractIndenter.lineIndents", suggestedIndentsForOtherLines);
        if (DEBUG && !suggestedIndentsForOtherLines.isEmpty()) {
            TreeSet<Integer> keys = new TreeSet<Integer>(suggestedIndentsForOtherLines.keySet());
            System.err.print("AbstractIndenter.lineIndents:");
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                int l = (Integer)iterator.next();
                System.err.print("" + (l + 1) + ":" + suggestedIndentsForOtherLines.get(l) + " ");
            }
            System.err.println("");
        }
    }

    private List<Line> generateBlockIndentsForForeignLanguage(List<Line> indentedLines, Map<Integer, Integer> suggestedIndentsForOtherLines) throws BadLocationException {
        ArrayList<Line> indents = new ArrayList<Line>();
        ArrayList<Line> linesInBlock = new ArrayList<Line>();
        int lastStart = -1;
        Line lastStartLine = null;
        for (Line line : indentedLines) {
            if (line.foreignLanguageBlockStart) {
                lastStart = line.index;
                lastStartLine = line;
            }
            if (line.foreignLanguageBlockEnd) {
                if (lastStart == -1) assert (false) : "found line.compoundEnd without start: " + indentedLines;
                if (lastStart != line.index) {
                    int end = line.index;
                    if (!line.indentThisLine) {
                        ++end;
                    }
                    for (int i = lastStart + 1; i < end; ++i) {
                        Line line2 = this.findLineByLineIndex(linesInBlock, i);
                        if (line2 == null) {
                            line2 = this.generateBasicLine(i);
                            line2.indentThisLine = true;
                            line2.preserveThisLineIndent = true;
                            line2.indentation = this.calculatePreservedLineIndentation(lastStartLine, line2.offset);
                        } else if (!line2.indentThisLine) {
                            line2.preserveThisLineIndent = true;
                            line2.indentThisLine = true;
                            line2.indentation = this.calculatePreservedLineIndentation(lastStartLine, line2.offset);
                        }
                        if (!line2.emptyLine) {
                            indents.add(line2);
                        }
                        suggestedIndentsForOtherLines.remove(i);
                    }
                    linesInBlock.clear();
                }
                lastStart = -1;
            }
            if (lastStart != -1 && line.index > lastStart) {
                linesInBlock.add(line);
                continue;
            }
            indents.add(line);
        }
        return indents;
    }

    private Line generateBasicLine(int index) throws BadLocationException {
        Line line = new Line();
        line.index = index;
        line.offset = Utilities.getRowStartFromLineOffset((BaseDocument)this.getDocument(), (int)index);
        line.existingLineIndent = IndentUtils.lineIndent((Document)this.getDocument(), (int)line.offset);
        int nonWS = Utilities.getRowFirstNonWhite((BaseDocument)this.getDocument(), (int)line.offset);
        line.emptyLine = nonWS == -1;
        line.tabIndentation = nonWS == -1 || line.existingLineIndent != nonWS - line.offset;
        line.lineStartOffset = line.offset;
        line.lineEndOffset = Utilities.getRowEnd((BaseDocument)this.getDocument(), (int)line.offset);
        line.lineIndent = new ArrayList();
        line.lineIndent.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, line.offset, this.getIndentationSize()));
        line.preliminaryNextLineIndent = new ArrayList();
        line.preliminaryNextLineIndent.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, line.offset, this.getIndentationSize()));
        return line;
    }

    private void updateIndentationForPreservedLines(List<Line> indentedLines, int lineToBeIndented) throws BadLocationException {
        Line lineBeforePreserveIndent = null;
        for (Line line : indentedLines) {
            if (!line.indentThisLine) continue;
            if (line.preserveThisLineIndent) {
                if (lineBeforePreserveIndent != null) {
                    if (lineToBeIndented != -1 && line.index == lineToBeIndented) continue;
                    line.indentation = this.calculatePreservedLineIndentation(lineBeforePreserveIndent, line.offset);
                    continue;
                }
                lineBeforePreserveIndent = line;
                continue;
            }
            lineBeforePreserveIndent = line;
        }
    }

    private int calculatePreservedLineIndentation(Line lineBeforePreserveIndent, int lineOffset) throws BadLocationException {
        int originalFirstLineIndent = IndentUtils.lineIndent((Document)this.getDocument(), (int)lineBeforePreserveIndent.offset);
        int originalCurrentLineIndent = IndentUtils.lineIndent((Document)this.getDocument(), (int)lineOffset);
        return lineBeforePreserveIndent.indentation + (originalCurrentLineIndent - originalFirstLineIndent);
    }

    private void modifyDocument(List<Line> indentedLines, int lineStart, int lineEnd) throws BadLocationException {
        for (int i = indentedLines.size() - 1; i >= 0; --i) {
            Line line = indentedLines.get(i);
            if (!line.indentThisLine || line.index < lineStart || line.index > lineEnd) continue;
            int newIndent = line.indentation;
            if (newIndent < 0) {
                newIndent = 0;
            }
            assert (line.existingLineIndent != -1) : "line is missing existingLineIndent " + line;
            if (line.existingLineIndent == newIndent && !line.tabIndentation) continue;
            this.context.modifyIndent(line.offset, Math.min(newIndent, 200));
        }
    }

    private void debugIndentation(int lineOffset, List<IndentCommand> iis, String text, boolean indentable) throws BadLocationException {
        int index = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)lineOffset);
        char ch = ' ';
        if (indentable) {
            ch = '*';
        }
        System.err.println(String.format("%1c[%4d]", Character.valueOf(ch), index + 1) + text);
        for (IndentCommand ii : iis) {
            System.err.println("      " + ii);
        }
    }

    private void debugLineIndentation(Line ln, boolean indentable) throws BadLocationException {
        String line = "";
        if (ln.lineStartOffset != ln.lineEndOffset) {
            line = this.getDocument().getText(ln.lineStartOffset, ln.lineEndOffset - ln.lineStartOffset + 1).replace("\n", "").replace("\r", "").trim();
        }
        StringBuilder sb = new StringBuilder();
        char ch = ' ';
        if (indentable) {
            ch = '*';
        } else if (ln.preserveThisLineIndent) {
            ch = 'P';
        }
        sb.append(String.format("%1c[%4d]", Character.valueOf(ch), ln.index + 1));
        for (int i = 0; i < ln.indentation; ++i) {
            sb.append('.');
        }
        sb.append(line);
        if (sb.length() > 75) {
            sb.setLength(75);
        }
        System.err.println(sb.toString());
    }

    static {
        inUnitTestRun = false;
    }

    public static final class OffsetRanges {
        List<OffsetRange> ranges = new ArrayList<OffsetRange>();

        public void add(int start, int end) {
            for (OffsetRange range : this.ranges) {
                if (range.end == start) {
                    range.end = end;
                    return;
                }
                if (range.start != end) continue;
                range.start = start;
                return;
            }
            this.ranges.add(new OffsetRange(start, end));
        }

        private boolean contains(int start, int end) {
            for (OffsetRange or : this.ranges) {
                if (start < or.getStart() || end > or.getEnd()) continue;
                return true;
            }
            return false;
        }

        private boolean calculateUncoveredArea(int start, int end, int[] result) {
            boolean changed = false;
            for (OffsetRange or : this.ranges) {
                if (start < or.getStart() && end > or.getEnd()) continue;
                if (start >= or.getStart() && end <= or.getEnd()) {
                    result[0] = -1;
                    result[1] = -1;
                    return true;
                }
                if (start >= or.getStart() && start <= or.getEnd()) {
                    assert (or.getEnd() + 1 <= end) : "" + start + "-" + end + " range=" + or;
                    start = or.getEnd() + 1;
                    changed = true;
                }
                if (end < or.getStart() || end > or.getEnd()) continue;
                assert (start <= or.getStart() - 1) : "" + start + "-" + end + " range=" + or;
                end = or.getStart() - 1;
                changed = true;
            }
            if (changed) {
                result[0] = start;
                result[1] = end;
            }
            return changed;
        }

        public boolean isEmpty() {
            return this.ranges.isEmpty();
        }

        public String dump() {
            StringBuilder sb = new StringBuilder();
            for (OffsetRange or : this.ranges) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("[").append(or.start).append("-").append(or.end).append("]");
            }
            return sb.toString();
        }

        public String toString() {
            return "OffsetRanges[" + this.dump() + "]";
        }
    }

    static final class Line {
        private List<IndentCommand> lineIndent;
        private List<IndentCommand> preliminaryNextLineIndent;
        private int offset;
        private int lineStartOffset;
        private int lineEndOffset;
        private int index;
        private boolean indentThisLine = true;
        private boolean preserveThisLineIndent;
        private int indentation;
        private boolean emptyLine;
        private boolean foreignLanguageBlockStart;
        private boolean foreignLanguageBlockEnd;
        private int existingLineIndent = -1;
        private boolean tabIndentation;
        private int indentationAdjustment = 0;

        Line() {
        }

        private void updateOffset(int diff) {
            this.offset += diff;
            this.lineStartOffset += diff;
            this.lineEndOffset += diff;
            for (IndentCommand ic : this.lineIndent) {
                ic.updateOffset(diff);
            }
            for (IndentCommand ic : this.preliminaryNextLineIndent) {
                ic.updateOffset(diff);
            }
        }

        private void recalculateLineIndex(BaseDocument doc) throws BadLocationException {
            this.index = Utilities.getLineOffset((BaseDocument)doc, (int)this.offset);
            int rowStart = Utilities.getRowStart((BaseDocument)doc, (int)this.offset);
            if (rowStart != this.offset) {
                if (DEBUG) {
                    System.err.println("WARNING: disabling line indentability because its start has changed: " + this);
                }
                this.indentThisLine = false;
            }
        }

        public String dump() {
            return String.format("[%4d]", this.index + 1) + " offset=" + this.offset + " (" + this.lineStartOffset + "-" + this.lineEndOffset + ") indent=" + this.indentation + (this.indentationAdjustment != 0 ? "(" + this.indentationAdjustment + ")" : "") + (this.existingLineIndent != -1 ? " existingIndent=" + this.existingLineIndent : "") + (this.foreignLanguageBlockStart ? " foreignLangBlockStart" : "") + (this.foreignLanguageBlockEnd ? " foreignLangBlockEnd" : "") + (this.preserveThisLineIndent ? " preserve" : "") + (this.emptyLine ? " empty" : "") + (!this.indentThisLine ? " noIndent" : "");
        }

        public String toString() {
            return "Line[index=" + this.index + ",lineOffset=" + this.offset + ",startOffset=" + this.lineStartOffset + ",endOffset=" + this.lineEndOffset + ",indentation=" + this.indentation + (this.indentationAdjustment != 0 ? "(" + this.indentationAdjustment + ")" : "") + (this.existingLineIndent != -1 ? ",existingIndent=" + this.existingLineIndent : "") + (this.preserveThisLineIndent ? ",preserveThisLineIndent" : "") + (this.emptyLine ? ",empty" : "") + (!this.indentThisLine ? ",doNotIndentThisLine" : "") + ",lineIndent=" + this.lineIndent + "]";
        }
    }

    private static class ForeignLanguageBlock {
        private int startLine;
        private int endLine;

        public ForeignLanguageBlock(int startLine, int endLine) {
            this.startLine = startLine;
            this.endLine = endLine;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public String toString() {
            return "ForeignLangBlock[" + this.startLine + "-" + this.endLine + "]";
        }
    }

    private static class LineCommandsPair {
        private int line;
        private List<IndentCommand> commands;

        public LineCommandsPair(int line, List<IndentCommand> commands) {
            this.line = line;
            this.commands = commands;
        }

        public String toString() {
            return "LineCommandsPair[" + this.line + ":" + this.commands + "]";
        }
    }

    private final class LinePair {
        private int startingLine;
        private int endingLine;

        private LinePair() {
        }

        public int getEndingLine() {
            return this.endingLine;
        }

        public int getStartingLine() {
            return this.startingLine;
        }

        public String toString() {
            return "LP[" + this.startingLine + ":" + this.endingLine + "]";
        }
    }

    private static class UnmodifiableButExtendableList<T>
    implements List<T> {
        private static final String NOT_SUPPORTED_MGS = "UnmodifiableButExtendableList doesn't implement the method, if you've modified the using code, please update the UnmodifiableButExtendableList class accordingly!";
        private List<T> original;
        private List<T> ext;

        public UnmodifiableButExtendableList(List<T> original) {
            this.original = original;
            this.ext = new ArrayList<T>();
        }

        @Override
        public int size() {
            return this.original.size() + this.ext.size();
        }

        @Override
        public boolean isEmpty() {
            return this.original.isEmpty() && this.ext.isEmpty();
        }

        @Override
        public boolean add(T e) {
            return this.ext.add(e);
        }

        @Override
        public T get(int i) {
            int os = this.original.size();
            if (i < os) {
                return this.original.get(i);
            }
            return this.ext.get(i - os);
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }

        @Override
        public Iterator<T> iterator() {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }

        @Override
        public <T> T[] toArray(T[] ts) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }

        @Override
        public boolean containsAll(Collection<?> clctn) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }

        @Override
        public boolean addAll(Collection<? extends T> clctn) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }

        @Override
        public boolean addAll(int i, Collection<? extends T> clctn) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }

        @Override
        public boolean removeAll(Collection<?> clctn) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }

        @Override
        public boolean retainAll(Collection<?> clctn) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }

        @Override
        public T set(int i, T e) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }

        @Override
        public void add(int i, T e) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }

        @Override
        public T remove(int i) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }

        @Override
        public int indexOf(Object o) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }

        @Override
        public int lastIndexOf(Object o) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }

        @Override
        public ListIterator<T> listIterator() {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }

        @Override
        public ListIterator<T> listIterator(int i) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }

        @Override
        public List<T> subList(int i, int i1) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MGS);
        }
    }

    private static final class OffsetRange {
        private int start;
        private int end;

        public OffsetRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getEnd() {
            return this.end;
        }

        public int getStart() {
            return this.start;
        }

        public String toString() {
            return "OffsetRange[" + this.start + "-" + this.end + "]";
        }
    }
}

