/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.refactoring;

import com.sun.el.parser.AstMethodArguments;
import com.sun.el.parser.Node;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringCommit;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.web.el.CompilationContext;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELVariableResolvers;
import org.netbeans.modules.web.el.refactoring.DiffElement;
import org.netbeans.modules.web.el.refactoring.ELWhereUsedQuery;
import org.netbeans.modules.web.el.refactoring.RefactoringUtil;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionRef;
import org.openide.util.NbBundle;

public class ELRenameRefactoring
extends ELWhereUsedQuery {
    private final RenameRefactoring rename;

    public ELRenameRefactoring(RenameRefactoring rename) {
        super((AbstractRefactoring)rename);
        this.rename = rename;
    }

    @Override
    protected Problem handleClass(CompilationContext info, RefactoringElementsBag refactoringElementsBag, TreePathHandle handle, Element targetType) {
        TypeElement type = (TypeElement)targetType;
        String beanName = ELVariableResolvers.findBeanName(info, type.getQualifiedName().toString(), this.getFileObject());
        if (beanName != null && beanName.equalsIgnoreCase(type.getSimpleName().toString())) {
            for (AnnotationMirror annotationMirror : info.info().getElements().getAllAnnotationMirrors(type)) {
                CharSequence annFqn = info.info().getTypeUtilities().getTypeName((TypeMirror)annotationMirror.getAnnotationType(), new TypeUtilities.TypeNameOptions[]{TypeUtilities.TypeNameOptions.PRINT_FQN});
                if ("javax.faces.bean.ManagedBean".contentEquals(annFqn)) {
                    for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                        if (!"name".contentEquals(executableElement.getSimpleName())) continue;
                        return null;
                    }
                    return super.handleClass(info, refactoringElementsBag, handle, targetType);
                }
                if ("jakarta.faces.bean.ManagedBean".contentEquals(annFqn)) {
                    for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                        if (!"name".contentEquals(executableElement.getSimpleName())) continue;
                        return null;
                    }
                    return super.handleClass(info, refactoringElementsBag, handle, targetType);
                }
                if ("javax.inject.Named".contentEquals(annFqn)) {
                    for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                        if (!"value".contentEquals(executableElement.getSimpleName())) continue;
                        return null;
                    }
                    return super.handleClass(info, refactoringElementsBag, handle, targetType);
                }
                if (!"jakarta.inject.Named".contentEquals(annFqn)) continue;
                for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                    if (!"value".contentEquals(executableElement.getSimpleName())) continue;
                    return null;
                }
                return super.handleClass(info, refactoringElementsBag, handle, targetType);
            }
        }
        return null;
    }

    @Override
    protected void addElements(CompilationContext info, ELElement elem, List<Node> matchingNodes, RefactoringElementsBag refactoringElementsBag) {
        FileObject file = elem.getSnapshot().getSource().getFileObject();
        ModificationResult modificationResult = new ModificationResult();
        ArrayList<ModificationResult.Difference> differences = new ArrayList<ModificationResult.Difference>();
        TypeMirror returnType = null;
        TreePathHandle treePathHandle = (TreePathHandle)this.rename.getRefactoringSource().lookup(TreePathHandle.class);
        if (treePathHandle != null && treePathHandle.getKind() == Tree.Kind.METHOD) {
            ExecutableElement methodElement = (ExecutableElement)treePathHandle.resolveElement(info.info());
            returnType = methodElement.getReturnType();
        }
        for (Node targetNode : matchingNodes) {
            Node child;
            PositionRef[] position = RefactoringUtil.getPostionRefs(elem, targetNode);
            String renameNewName = this.rename.getNewName();
            if (renameNewName == null) continue;
            String newName = renameNewName + "()";
            if (RefactoringUtil.isPropertyAccessor(renameNewName, returnType)) {
                newName = RefactoringUtil.getPropertyName(renameNewName, returnType);
            } else if (targetNode.jjtGetLastToken().image != null && !targetNode.jjtGetLastToken().image.endsWith(")")) {
                newName = renameNewName;
            }
            PositionRef[] childPosition = null;
            if (targetNode.jjtGetNumChildren() > 0 && (child = targetNode.jjtGetChild(0)) instanceof AstMethodArguments) {
                childPosition = RefactoringUtil.getPostionRefs(elem, child);
                newName = renameNewName;
            }
            differences.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, position[0], childPosition != null ? childPosition[0] : position[1], targetNode.getImage(), newName, NbBundle.getMessage(ELRenameRefactoring.class, (String)"LBL_Update", (Object)targetNode.getImage())));
        }
        modificationResult.addDifferences(file, differences);
        refactoringElementsBag.registerTransaction((Transaction)new RefactoringCommit(Collections.singletonList(modificationResult)));
        for (ModificationResult.Difference diff : modificationResult.getDifferences(file)) {
            DiffElement diffElem = DiffElement.create(diff, file, modificationResult);
            refactoringElementsBag.add(this.refactoring, (RefactoringElementImplementation)diffElem);
        }
    }
}

