/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.navigation;

import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.Node;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.element.Element;
import javax.swing.text.Document;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.netbeans.modules.web.el.AstPath;
import org.netbeans.modules.web.el.CompilationContext;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELTypeUtilities;
import org.netbeans.modules.web.el.ResourceBundles;
import org.netbeans.modules.web.el.navigation.ELHyperlinkProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Pair;

public class ELDeclarationFinder
implements DeclarationFinder {
    private static final org.netbeans.modules.csl.api.ElementHandle DEFAULT_RESOURCE_BUNDLE_HANDLE = new ResourceBundleElementHandle();

    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult info, int offset) {
        final Pair<Node, ELElement> nodeElem = ELHyperlinkProvider.resolveNodeAndElement(info.getSnapshot().getSource(), offset, new AtomicBoolean());
        if (nodeElem == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        final FileObject file = info.getSnapshot().getSource().getFileObject();
        final ClasspathInfo cp = ELTypeUtilities.getElimplExtendedCPI(file);
        final RefsHolder refs = new RefsHolder();
        final ArrayList alternatives = new ArrayList();
        try {
            JavaSource javaSource;
            JavaSource.create((ClasspathInfo)cp, (FileObject[])new FileObject[0]).runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    List bundleLocations;
                    ResourceBundles resourceBundles;
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationContext context = CompilationContext.create(file, (CompilationInfo)cc);
                    Element javaElement = ELTypeUtilities.resolveElement(context, (ELElement)nodeElem.second(), (Node)nodeElem.first());
                    if (javaElement != null) {
                        refs.handle = ElementHandle.create((Element)javaElement);
                        refs.fo = SourceUtils.getFile((ElementHandle)refs.handle, (ClasspathInfo)cp);
                    }
                    if ((resourceBundles = ResourceBundles.get(file)).canHaveBundles() && !(bundleLocations = ELDeclarationFinder.getBundleLocations(resourceBundles, (Pair<Node, ELElement>)nodeElem)).isEmpty()) {
                        refs.fo = ((ResourceBundles.Location)bundleLocations.get(0)).getFile();
                        refs.offset = ((ResourceBundles.Location)bundleLocations.get(0)).getOffset();
                        for (ResourceBundles.Location location : bundleLocations) {
                            alternatives.add(new ResourceBundleAlternative(location));
                        }
                    }
                }
            }, true);
            if (refs.fo != null && (javaSource = JavaSource.forFileObject((FileObject)refs.fo)) != null) {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController controller) throws Exception {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Element element = refs.handle.resolve((CompilationInfo)controller);
                        Trees trees = controller.getTrees();
                        Tree tree = trees.getTree(element);
                        SourcePositions sourcePositions = trees.getSourcePositions();
                        refs.offset = (int)sourcePositions.getStartPosition(controller.getCompilationUnit(), tree);
                    }
                }, true);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (refs.fo != null && refs.offset != -1) {
            DeclarationFinder.DeclarationLocation declarationLocation = new DeclarationFinder.DeclarationLocation(refs.fo, refs.offset);
            for (DeclarationFinder.AlternativeLocation alternativeLocation : alternatives) {
                declarationLocation.addAlternative(alternativeLocation);
            }
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public OffsetRange getReferenceSpan(final Document doc, final int caretOffset) {
        final AtomicReference<OffsetRange> ret = new AtomicReference<OffsetRange>(OffsetRange.NONE);
        doc.render(new Runnable(){

            @Override
            public void run() {
                int[] offsets = ELHyperlinkProvider.getELIdentifierSpan(doc, caretOffset);
                if (offsets != null) {
                    ret.set(new OffsetRange(offsets[0], offsets[1]));
                }
            }
        });
        return ret.get();
    }

    private static List<ResourceBundles.Location> getBundleLocations(ResourceBundles resourceBundles, Pair<Node, ELElement> nodeElem) {
        if (nodeElem.first() instanceof AstIdentifier) {
            return resourceBundles.getLocationsForBundleIdent(((Node)nodeElem.first()).getImage());
        }
        AstPath astPath = new AstPath(((ELElement)nodeElem.second()).getNode());
        for (Node node : astPath.rootToLeaf()) {
            String image = ((Node)nodeElem.first()).getImage();
            if (!(node instanceof AstIdentifier) || node.getImage() == null || image == null) continue;
            if (image.length() > 2 && image.startsWith("'") && image.endsWith("'") || image.startsWith("\"") && image.endsWith("\"")) {
                image = image.substring(1, image.length() - 1);
            }
            return resourceBundles.getLocationsForBundleKey(node.getImage(), image);
        }
        return Collections.emptyList();
    }

    private static class ResourceBundleElementHandle
    implements org.netbeans.modules.csl.api.ElementHandle {
        private ResourceBundleElementHandle() {
        }

        public FileObject getFileObject() {
            return null;
        }

        public String getMimeType() {
            return "";
        }

        public String getName() {
            return "";
        }

        public String getIn() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.FILE;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean signatureEquals(org.netbeans.modules.csl.api.ElementHandle handle) {
            return false;
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }
    }

    private static class RefsHolder {
        private ElementHandle<Element> handle;
        private FileObject fo;
        private int offset = -1;

        private RefsHolder() {
        }
    }

    private static class ResourceBundleAlternative
    implements DeclarationFinder.AlternativeLocation {
        private final FileObject file;
        private final int offset;

        public ResourceBundleAlternative(ResourceBundles.Location location) {
            this.offset = location.getOffset();
            this.file = location.getFile();
        }

        public org.netbeans.modules.csl.api.ElementHandle getElement() {
            return DEFAULT_RESOURCE_BUNDLE_HANDLE;
        }

        public String getDisplayHtml(HtmlFormatter formatter) {
            Project project;
            StringBuilder b = new StringBuilder();
            b.append("<font color=007c00>");
            b.append("<b>");
            b.append(this.file.getName());
            b.append("</b>");
            b.append("</font> in ");
            FileObject pathRoot = ProjectWebRootQuery.getWebRoot((FileObject)this.file);
            String path = null;
            if (pathRoot != null) {
                path = FileUtil.getRelativePath((FileObject)pathRoot, (FileObject)this.file);
            }
            if (path == null && (project = FileOwnerQuery.getOwner((FileObject)this.file)) != null) {
                pathRoot = project.getProjectDirectory();
                path = FileUtil.getRelativePath((FileObject)pathRoot, (FileObject)this.file);
            }
            if (path == null) {
                path = this.file.getPath();
            }
            b.append("<i>");
            b.append(path);
            b.append("</i>");
            if (this.offset > 0) {
                b.append(":");
                b.append(this.offset + 1);
            }
            return b.toString();
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            return new DeclarationFinder.DeclarationLocation(this.file, this.offset);
        }

        public int compareTo(DeclarationFinder.AlternativeLocation o) {
            return ResourceBundleAlternative.getComparableString(this).compareTo(ResourceBundleAlternative.getComparableString(o));
        }

        private static String getComparableString(DeclarationFinder.AlternativeLocation loc) {
            DeclarationFinder.DeclarationLocation location = loc.getLocation();
            FileObject fileObject = location.getFileObject();
            if (fileObject != null) {
                return String.valueOf(location.getOffset()) + fileObject.getPath();
            }
            return String.valueOf(location.getOffset());
        }

        public int hashCode() {
            int hash = 5;
            hash = 89 * hash + Objects.hashCode(this.file);
            hash = 89 * hash + this.offset;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceBundleAlternative other = (ResourceBundleAlternative)obj;
            if (!Objects.equals(this.file, other.file)) {
                return false;
            }
            return this.offset == other.offset;
        }
    }
}

