/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.refactoring;

import com.sun.el.parser.Node;
import java.util.ArrayList;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Position;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.web.el.ELElement;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.Parameters;

public final class RefactoringUtil {
    private RefactoringUtil() {
    }

    static String encodeAndHighlight(String text, OffsetRange expressionOffset, OffsetRange nodeOffset) {
        StringBuilder result = new StringBuilder(text.length() + 7);
        String expression = text.substring(expressionOffset.getStart(), expressionOffset.getEnd());
        result.append(RefactoringUtil.encodeAngleBrackets(text.substring(0, expressionOffset.getStart())));
        result.append(RefactoringUtil.highlight(expression, nodeOffset));
        result.append(RefactoringUtil.encodeAngleBrackets(text.substring(expressionOffset.getEnd(), text.length())));
        return result.toString();
    }

    private static String encodeAngleBrackets(String str) {
        return str.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private static String highlight(String text, OffsetRange offsetRange) {
        StringBuilder result = new StringBuilder(text.length() + 7);
        result.append(text.substring(0, offsetRange.getStart()));
        result.append("<b>");
        result.append(RefactoringUtil.encodeAngleBrackets(text.subSequence(offsetRange.getStart(), offsetRange.getEnd()).toString()));
        result.append("</b>");
        result.append(text.substring(offsetRange.getEnd(), text.length()));
        return result.toString();
    }

    public static String getPropertyName(String accessor) {
        return RefactoringUtil.getPropertyName(accessor, null, false);
    }

    public static String getPropertyName(String accessor, TypeMirror returnType) {
        return RefactoringUtil.getPropertyName(accessor, returnType, false);
    }

    public static String getPropertyName(String accessor, TypeMirror returnType, boolean includeSetter) {
        Parameters.notEmpty((CharSequence)"accessor", (CharSequence)accessor);
        int prefixLength = RefactoringUtil.getPrefixLength(accessor, includeSetter);
        String withoutPrefix = accessor.substring(prefixLength);
        if (withoutPrefix.isEmpty()) {
            return accessor;
        }
        char firstChar = withoutPrefix.charAt(0);
        if (!Character.isUpperCase(firstChar)) {
            return accessor;
        }
        if (returnType != null && accessor.startsWith("is") && returnType.getKind() != TypeKind.BOOLEAN) {
            return accessor;
        }
        if (withoutPrefix.length() > 1 && Character.isUpperCase(withoutPrefix.charAt(1))) {
            return withoutPrefix;
        }
        return Character.toLowerCase(firstChar) + withoutPrefix.substring(1);
    }

    public static boolean isPropertyAccessor(String accessor, TypeMirror returnType) {
        return !RefactoringUtil.getPropertyName(accessor, returnType).equals(accessor);
    }

    private static int getPrefixLength(String accessor, boolean includeSetter) {
        ArrayList<String> accessorPrefixes = new ArrayList<String>();
        accessorPrefixes.add("get");
        if (includeSetter) {
            accessorPrefixes.add("set");
        }
        accessorPrefixes.add("is");
        for (String prefix : accessorPrefixes) {
            if (!accessor.startsWith(prefix)) continue;
            return prefix.length();
        }
        return 0;
    }

    static PositionRef[] getPostionRefs(ELElement elem, Node targetNode) {
        OffsetRange nodeRange = elem.getOriginalOffset(targetNode);
        CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)elem.getSnapshot().getSource().getFileObject());
        if (editor != null) {
            PositionRef start = editor.createPositionRef(nodeRange.getStart(), Position.Bias.Forward);
            PositionRef end = editor.createPositionRef(nodeRange.getEnd(), Position.Bias.Backward);
            return new PositionRef[]{start, end};
        }
        return new PositionRef[0];
    }
}

