/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.api.CustomizerPanel;
import org.netbeans.modules.web.clientproject.api.platform.PlatformProvider;
import org.netbeans.modules.web.clientproject.ui.customizer.BrowserRunPanel;
import org.netbeans.modules.web.clientproject.ui.customizer.Bundle;
import org.netbeans.modules.web.clientproject.ui.customizer.ClientSideProjectProperties;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RunPanel
extends JPanel
implements HelpCtx.Provider,
ChangeListener {
    private final ClientSideProject project;
    private final ProjectCustomizer.Category category;
    private final ClientSideProjectProperties uiProperties;
    private final BrowserRunPanel browserRunPanel;
    private final List<CustomizerPanel> platformPanels = new CopyOnWriteArrayList<CustomizerPanel>();
    private volatile CustomizerPanel selectedPanel = null;
    private JPanel browserPanel;
    private JPanel browserPanelHolder;
    private JPanel platformProviderPanel;
    private JPanel platformProviderPanelHolder;
    private JComboBox<CustomizerPanel> runAsComboBox;
    private JPanel runAsHolder;
    private JLabel runAsLabel;
    private JCheckBox runBrowserCheckBox;
    private JPanel runBrowserHolder;

    public RunPanel(ProjectCustomizer.Category category, ClientSideProjectProperties uiProperties) {
        assert (category != null);
        assert (uiProperties != null);
        this.category = category;
        this.uiProperties = uiProperties;
        this.project = uiProperties.getProject();
        this.browserRunPanel = new BrowserRunPanel(uiProperties);
        for (PlatformProvider platformProvider : this.project.getPlatformProviders()) {
            this.platformPanels.addAll(platformProvider.getRunCustomizerPanels((Project)this.project));
        }
        this.initComponents();
        this.init();
        category.setStoreListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RunPanel.this.selectedPanel != null) {
                    RunPanel.this.selectedPanel.save();
                }
            }
        });
    }

    private void init() {
        String selectedRunAs = this.uiProperties.getRunAs().get();
        this.runBrowserCheckBox.setSelected(this.uiProperties.isRunBrowser());
        this.runAsComboBox.setRenderer(new RunAsRenderer());
        if (this.platformPanels.isEmpty()) {
            this.runAsHolder.setVisible(false);
            this.platformProviderPanelHolder.setVisible(false);
            this.runBrowserHolder.setVisible(false);
        } else {
            if (!this.project.isJsLibrary()) {
                this.runAsComboBox.addItem(null);
            }
            for (CustomizerPanel platformPanel : this.platformPanels) {
                this.runAsComboBox.addItem(platformPanel);
                if (!platformPanel.getIdentifier().equals(selectedRunAs)) continue;
                this.runAsComboBox.setSelectedItem(platformPanel);
            }
            this.switchPlatformPanel();
        }
        if (this.project.isJsLibrary()) {
            this.runBrowserHolder.setVisible(false);
            this.browserPanelHolder.setVisible(false);
        } else {
            this.browserPanel.add((Component)this.browserRunPanel, "Center");
            this.browserPanel.revalidate();
            this.browserPanel.repaint();
        }
        if (this.runAsComboBox.getItemCount() <= 1) {
            this.runAsHolder.setVisible(false);
        }
        this.browserPanel.setVisible(this.isRunBrowser());
        this.initListeners();
    }

    private void initListeners() {
        this.runAsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RunPanel.this.switchPlatformPanel();
                RunPanel.this.validateAndStoreData();
            }
        });
        this.runBrowserCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RunPanel.this.browserPanel.setVisible(e.getStateChange() == 1);
                RunPanel.this.validateAndStoreData();
            }
        });
        this.browserRunPanel.addChangeListener(this);
    }

    private boolean isRunBrowser() {
        if (this.project.isJsLibrary()) {
            return false;
        }
        if (this.getSelectedPanel() == null) {
            return true;
        }
        return this.runBrowserCheckBox.isSelected();
    }

    @CheckForNull
    private String getRunAs() {
        CustomizerPanel panel = this.getSelectedPanel();
        if (panel == null) {
            return null;
        }
        return panel.getIdentifier();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.web.clientproject.ui.customizer.RunPanel");
    }

    void switchPlatformPanel() {
        assert (EventQueue.isDispatchThread());
        assert (this.platformProviderPanel.isVisible());
        if (this.selectedPanel != null) {
            this.selectedPanel.removeChangeListener((ChangeListener)this);
        }
        this.platformProviderPanel.removeAll();
        this.selectedPanel = this.getSelectedPanel();
        if (this.selectedPanel != null) {
            this.platformProviderPanelHolder.setVisible(true);
            this.selectedPanel.addChangeListener((ChangeListener)this);
            this.platformProviderPanel.add((Component)this.selectedPanel.getComponent(), "Center");
            this.runBrowserHolder.setVisible(!this.project.isJsLibrary());
            this.browserRunPanel.onlyExternalUrl(true);
        } else {
            this.platformProviderPanelHolder.setVisible(false);
            this.runBrowserHolder.setVisible(false);
            this.browserRunPanel.onlyExternalUrl(false);
        }
        this.platformProviderPanelHolder.revalidate();
        this.platformProviderPanelHolder.repaint();
        this.browserPanel.setVisible(this.isRunBrowser());
        this.validateAndStoreData();
    }

    void validateAndStoreData() {
        this.validateData();
        this.storeData();
    }

    private void validateData() {
        assert (EventQueue.isDispatchThread());
        String error = null;
        String warning = null;
        if (this.selectedPanel != null) {
            error = this.selectedPanel.getErrorMessage();
            warning = this.selectedPanel.getWarningMessage();
        }
        if (this.isRunBrowser()) {
            if (error == null) {
                error = this.browserRunPanel.getErrorMessage();
            }
            if (warning == null) {
                warning = this.browserRunPanel.getWarningMessage();
            }
        }
        if (error != null) {
            this.category.setErrorMessage(error);
            this.category.setValid(false);
            return;
        }
        if (warning != null) {
            this.category.setErrorMessage(warning);
            this.category.setValid(true);
            return;
        }
        this.category.setErrorMessage(null);
        this.category.setValid(true);
    }

    private void storeData() {
        this.uiProperties.setRunAs(this.getRunAs());
        this.uiProperties.setRunBrowser(this.isRunBrowser());
    }

    @CheckForNull
    private CustomizerPanel getSelectedPanel() {
        if (this.platformPanels.isEmpty()) {
            return null;
        }
        return (CustomizerPanel)this.runAsComboBox.getSelectedItem();
    }

    private void initComponents() {
        this.runAsHolder = new JPanel();
        this.runAsLabel = new JLabel();
        this.runAsComboBox = new JComboBox();
        this.platformProviderPanelHolder = new JPanel();
        this.platformProviderPanel = new JPanel();
        this.runBrowserHolder = new JPanel();
        this.runBrowserCheckBox = new JCheckBox();
        this.browserPanelHolder = new JPanel();
        this.browserPanel = new JPanel();
        Mnemonics.setLocalizedText((JLabel)this.runAsLabel, (String)NbBundle.getMessage(RunPanel.class, (String)"RunPanel.runAsLabel.text"));
        GroupLayout runAsHolderLayout = new GroupLayout(this.runAsHolder);
        this.runAsHolder.setLayout(runAsHolderLayout);
        runAsHolderLayout.setHorizontalGroup(runAsHolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(runAsHolderLayout.createSequentialGroup().addComponent(this.runAsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.runAsComboBox, -2, -1, -2)));
        runAsHolderLayout.setVerticalGroup(runAsHolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(runAsHolderLayout.createSequentialGroup().addGroup(runAsHolderLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.runAsLabel).addComponent(this.runAsComboBox, -2, -1, -2)).addContainerGap()));
        this.platformProviderPanel.setLayout(new BorderLayout());
        GroupLayout platformProviderPanelHolderLayout = new GroupLayout(this.platformProviderPanelHolder);
        this.platformProviderPanelHolder.setLayout(platformProviderPanelHolderLayout);
        platformProviderPanelHolderLayout.setHorizontalGroup(platformProviderPanelHolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.platformProviderPanel, -1, -1, Short.MAX_VALUE));
        platformProviderPanelHolderLayout.setVerticalGroup(platformProviderPanelHolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(platformProviderPanelHolderLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.platformProviderPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        Mnemonics.setLocalizedText((AbstractButton)this.runBrowserCheckBox, (String)NbBundle.getMessage(RunPanel.class, (String)"RunPanel.runBrowserCheckBox.text"));
        GroupLayout runBrowserHolderLayout = new GroupLayout(this.runBrowserHolder);
        this.runBrowserHolder.setLayout(runBrowserHolderLayout);
        runBrowserHolderLayout.setHorizontalGroup(runBrowserHolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(runBrowserHolderLayout.createSequentialGroup().addComponent(this.runBrowserCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        runBrowserHolderLayout.setVerticalGroup(runBrowserHolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(runBrowserHolderLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.runBrowserCheckBox).addGap(0, 0, 0)));
        this.browserPanel.setLayout(new BorderLayout());
        GroupLayout browserPanelHolderLayout = new GroupLayout(this.browserPanelHolder);
        this.browserPanelHolder.setLayout(browserPanelHolderLayout);
        browserPanelHolderLayout.setHorizontalGroup(browserPanelHolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.browserPanel, -1, -1, Short.MAX_VALUE));
        browserPanelHolderLayout.setVerticalGroup(browserPanelHolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(browserPanelHolderLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.browserPanel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.platformProviderPanelHolder, -1, -1, Short.MAX_VALUE).addComponent(this.runAsHolder, -1, -1, Short.MAX_VALUE).addComponent(this.runBrowserHolder, -1, -1, Short.MAX_VALUE).addComponent(this.browserPanelHolder, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.runAsHolder, -2, -1, -2).addGap(0, 0, 0).addComponent(this.platformProviderPanelHolder, -2, -1, -2).addGap(0, 0, 0).addComponent(this.runBrowserHolder, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browserPanelHolder, -2, -1, -2)));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.validateAndStoreData();
    }

    private static final class RunAsRenderer
    implements ListCellRenderer<Object> {
        private final DefaultListCellRenderer renderer = new DefaultListCellRenderer();

        private RunAsRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String label;
            if (value == null) {
                label = Bundle.RunAsRenderer_default();
            } else if (value instanceof String) {
                label = (String)value;
            } else {
                assert (value instanceof CustomizerPanel) : value.getClass().getName();
                label = ((CustomizerPanel)value).getDisplayName();
            }
            return this.renderer.getListCellRendererComponent(list, label, index, isSelected, cellHasFocus);
        }
    }
}

