/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.api.platform;

import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.CustomizerPanelAccessor;
import org.netbeans.modules.web.clientproject.api.BadgeIcon;
import org.netbeans.modules.web.clientproject.api.CustomizerPanel;
import org.netbeans.modules.web.clientproject.platform.PlatformProviderAccessor;
import org.netbeans.modules.web.clientproject.spi.CustomizerPanelImplementation;
import org.netbeans.modules.web.clientproject.spi.platform.PlatformProviderImplementation;
import org.netbeans.spi.project.ActionProvider;
import org.openide.util.Parameters;

public final class PlatformProvider {
    public static final String PROP_ENABLED = "ENABLED";
    public static final String PROP_SOURCE_ROOTS = "SOURCE_ROOTS";
    public static final String PROP_PROJECT_NAME = "PROJECT_NAME";
    public static final String PROP_RUN_CONFIGURATION = "RUN_CONFIGURATION";
    private final PlatformProviderImplementation delegate;

    private PlatformProvider(PlatformProviderImplementation delegate) {
        assert (delegate != null);
        this.delegate = delegate;
    }

    @NonNull
    public String getIdentifier() {
        return this.delegate.getIdentifier();
    }

    @NonNull
    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    @CheckForNull
    public BadgeIcon getBadgeIcon() {
        return this.delegate.getBadgeIcon();
    }

    public boolean isEnabled(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        return this.delegate.isEnabled(project);
    }

    public List<URL> getSourceRoots(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        return this.delegate.getSourceRoots(project);
    }

    @CheckForNull
    public ActionProvider getActionProvider(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        return this.delegate.getActionProvider(project);
    }

    public List<CustomizerPanel> getRunCustomizerPanels(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        List<CustomizerPanelImplementation> delegatePanels = this.delegate.getRunCustomizerPanels(project);
        if (delegatePanels.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CustomizerPanel> panels = new ArrayList<CustomizerPanel>(delegatePanels.size());
        for (CustomizerPanelImplementation delegatePanel : delegatePanels) {
            if (delegatePanel == null) {
                throw new IllegalStateException("Run customizer panel cannot be null for " + this.delegate.getClass().getName());
            }
            panels.add(CustomizerPanelAccessor.getDefault().create(delegatePanel));
        }
        return panels;
    }

    void projectOpened(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.delegate.projectOpened(project);
    }

    void projectClosed(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.delegate.projectClosed(project);
    }

    PlatformProviderImplementation getDelegate() {
        return this.delegate;
    }

    void notifyPropertyChanged(@NonNull Project project, @NonNull PropertyChangeEvent event) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"event", (Object)event);
        this.delegate.notifyPropertyChanged(project, event);
    }

    static {
        PlatformProviderAccessor.setDefault(new PlatformProviderAccessor(){

            @Override
            public PlatformProvider create(PlatformProviderImplementation platformProviderImplementation) {
                return new PlatformProvider(platformProviderImplementation);
            }
        });
    }
}

