/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.beans.completion.BeansCompletionItem;
import org.netbeans.modules.web.beans.completion.CompletionContext;
import org.netbeans.modules.web.beans.completion.Utils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public abstract class BeansCompletor {
    private int anchorOffset = -1;
    TAG tag;

    public abstract List<BeansCompletionItem> doCompletion(CompletionContext var1);

    BeansCompletor(TAG tag) {
        this.tag = tag;
    }

    protected void setAnchorOffset(int anchorOffset) {
        this.anchorOffset = anchorOffset;
    }

    public int getAnchorOffset() {
        return this.anchorOffset;
    }

    private static boolean isAlternative(TypeElement te) {
        List<? extends AnnotationMirror> annotationMirrors = te.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String typeName;
            if (!(annotationMirror.getAnnotationType().asElement() instanceof TypeElement) || !"javax.enterprise.inject.Alternative".equals(typeName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString()) && !"jakarta.enterprise.inject.Alternative".equals(typeName)) continue;
            return true;
        }
        return false;
    }

    public static enum TAG {
        CLASS,
        STEREOTYPE;

    }

    public static class JavaClassesCompletor
    extends BeansCompletor {
        JavaClassesCompletor(TAG tag) {
            super(tag);
        }

        @Override
        public List<BeansCompletionItem> doCompletion(CompletionContext context) {
            ArrayList<BeansCompletionItem> results = new ArrayList<BeansCompletionItem>();
            try {
                Document doc = context.getDocument();
                String typedChars = context.getTypedPrefix();
                JavaSource js = Utils.getJavaSource(doc);
                if (js == null) {
                    return Collections.emptyList();
                }
                FileObject fo = NbEditorUtilities.getFileObject((Document)context.getDocument());
                this.doJavaCompletion(fo, js, results, typedChars, context.getCurrentTokenOffset());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return results;
        }

        private void doJavaCompletion(FileObject fo, JavaSource js, final List<BeansCompletionItem> results, final String typedPrefix, final int substitutionOffset) throws IOException {
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    Set declaredTypes = null;
                    declaredTypes = cc.getClasspathInfo().getClassIndex().getDeclaredTypes(typedPrefix, ClassIndex.NameKind.PREFIX, Collections.singleton(ClassIndex.SearchScope.SOURCE));
                    if (declaredTypes != null && declaredTypes.size() > 0) {
                        block4: for (ElementHandle cl : declaredTypes) {
                            ElementKind kind = cl.getKind();
                            switch (tag) {
                                case CLASS: {
                                    if (kind != ElementKind.CLASS) break;
                                    TypeElement te = (TypeElement)cl.resolve((CompilationInfo)cc);
                                    if (!BeansCompletor.isAlternative(te)) continue block4;
                                    BeansCompletionItem item = BeansCompletionItem.createBeansTagValueItem(substitutionOffset - typedPrefix.length(), cl.getQualifiedName(), te.getSimpleName().toString());
                                    results.add(item);
                                    break;
                                }
                                case STEREOTYPE: {
                                    TypeElement te;
                                    if (kind != ElementKind.ANNOTATION_TYPE || !BeansCompletor.isAlternative(te = (TypeElement)cl.resolve((CompilationInfo)cc))) break;
                                    BeansCompletionItem item = BeansCompletionItem.createBeansTagValueItem(substitutionOffset - typedPrefix.length(), cl.getQualifiedName(), te.getSimpleName().toString());
                                    results.add(item);
                                }
                            }
                        }
                    }
                }
            }, true);
            this.setAnchorOffset(substitutionOffset);
        }
    }
}

