/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model.results;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ArrayValueHandler;
import org.netbeans.modules.web.beans.api.model.InterceptorsResult;
import org.netbeans.modules.web.beans.impl.model.StereotypeChecker;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelProviderImpl;

public class InterceptorsResultImpl
implements InterceptorsResult {
    static final String INTERCEPTORS = "javax.interceptor.Interceptors";
    static final String INTERCEPTORS_JAKARTA = "jakarta.interceptor.Interceptors";
    private Element mySubjectElement;
    private List<TypeElement> myEnabledInterceptors;
    private Collection<TypeElement> myDisabledInterceptors;
    private List<TypeElement> myDeclaredInterceptors;
    private AnnotationModelHelper myHelper;

    public InterceptorsResultImpl(Element element, List<TypeElement> enabledInterceptors, Set<TypeElement> disabledIntercaptors, AnnotationModelHelper helper) {
        this.mySubjectElement = element;
        this.myHelper = helper;
        this.myEnabledInterceptors = enabledInterceptors;
        this.myDisabledInterceptors = disabledIntercaptors;
        this.initDeclaredInterceptors();
    }

    @Override
    public List<AnnotationMirror> getAllStereotypes(Element element) {
        return WebBeansModelProviderImpl.getAllStereotypes(element, this.getHelper().getHelper());
    }

    @Override
    public List<AnnotationMirror> getStereotypes(Element element) {
        return InterceptorsResultImpl.getStereotypes(element, this.getHelper());
    }

    @Override
    public boolean isDisabled(Element element) {
        return this.myDisabledInterceptors.contains(element);
    }

    @Override
    public Element getElement() {
        return this.mySubjectElement;
    }

    @Override
    public List<TypeElement> getResolvedInterceptors() {
        int enabledSize = this.myEnabledInterceptors.size();
        int disabledSize = this.myDisabledInterceptors.size();
        ArrayList<TypeElement> result = new ArrayList<TypeElement>(enabledSize + disabledSize);
        result.addAll(this.myEnabledInterceptors);
        result.addAll(this.myDisabledInterceptors);
        return result;
    }

    @Override
    public List<TypeElement> getDeclaredInterceptors() {
        return this.myDeclaredInterceptors;
    }

    @Override
    public List<TypeElement> getAllInterceptors() {
        int enabledSize = this.myEnabledInterceptors.size();
        int disabledSize = this.myDisabledInterceptors.size();
        int declaredSize = this.myDeclaredInterceptors.size();
        ArrayList<TypeElement> result = new ArrayList<TypeElement>(enabledSize + disabledSize + declaredSize);
        result.addAll(this.myEnabledInterceptors);
        result.addAll(this.myDeclaredInterceptors);
        result.addAll(this.myDisabledInterceptors);
        return result;
    }

    private void initDeclaredInterceptors() {
        final LinkedHashSet result = new LinkedHashSet();
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)this.getHelper());
        parser.expectClassArray("value", new ArrayValueHandler(){

            public Object handleArray(List<AnnotationValue> arrayMembers) {
                for (AnnotationValue arrayMember : arrayMembers) {
                    TypeMirror typeMirror = (TypeMirror)arrayMember.getValue();
                    Element element = InterceptorsResultImpl.this.getController().getTypes().asElement(typeMirror);
                    if (!(element instanceof TypeElement)) continue;
                    result.add((TypeElement)element);
                }
                return null;
            }
        }, null);
        Element subjectElement = this.getElement();
        if (subjectElement instanceof ExecutableElement) {
            TypeElement enclosingType = this.getController().getElementUtilities().enclosingTypeElement(subjectElement);
            this.fillDeclaredAnnotations(parser, enclosingType);
        }
        this.fillDeclaredAnnotations(parser, subjectElement);
        this.myDeclaredInterceptors = new ArrayList<TypeElement>(result);
    }

    private void fillDeclaredAnnotations(AnnotationParser parser, Element subjectElement) {
        List<? extends AnnotationMirror> annotationMirrors = this.getController().getElements().getAllAnnotationMirrors(subjectElement);
        AnnotationMirror annotationMirror = (AnnotationMirror)this.getHelper().getAnnotationsByType(annotationMirrors).get(INTERCEPTORS);
        if (annotationMirror != null) {
            parser.parse(annotationMirror);
        }
        if ((annotationMirror = (AnnotationMirror)this.getHelper().getAnnotationsByType(annotationMirrors).get(INTERCEPTORS_JAKARTA)) != null) {
            parser.parse(annotationMirror);
        }
    }

    static List<AnnotationMirror> getStereotypes(Element element, AnnotationModelHelper helper) {
        LinkedList<AnnotationMirror> result = new LinkedList<AnnotationMirror>();
        List<? extends AnnotationMirror> annotationMirrors = helper.getCompilationController().getElements().getAllAnnotationMirrors(element);
        StereotypeChecker checker = new StereotypeChecker(helper.getHelper());
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (annotationElement == null || !WebBeansModelProviderImpl.isStereotype(annotationElement, checker)) continue;
            result.add(annotationMirror);
        }
        return result;
    }

    private AnnotationModelHelper getHelper() {
        return this.myHelper;
    }

    private CompilationController getController() {
        return this.getHelper().getCompilationController();
    }
}

