/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.versioning.util.projects.ProjectOpener;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ProjectUtilities {
    private static final String ProjectTab_ID_LOGICAL = "projectTabLogical_tc";
    public static final Logger LOG = Logger.getLogger(ProjectUtilities.class.getName());

    public static void openExportedProjects(Map<Project, Set<Project>> checkedOutProjects, File workingFolder) {
        ProjectOpener opener = new ProjectOpener(ProjectOpener.ProjectOpenerType.EXPORT, checkedOutProjects, workingFolder);
        opener.openProjects();
    }

    public static void openCheckedOutProjects(Map<Project, Set<Project>> checkedOutProjects, File workingFolder) {
        ProjectOpener opener = new ProjectOpener(ProjectOpener.ProjectOpenerType.CHECKOUT, checkedOutProjects, workingFolder);
        opener.openProjects();
    }

    public static void openClonedOutProjects(Map<Project, Set<Project>> checkedOutProjects, File workingFolder) {
        ProjectOpener opener = new ProjectOpener(ProjectOpener.ProjectOpenerType.CLONE, checkedOutProjects, workingFolder);
        opener.openProjects();
    }

    public static void selectAndExpandProject(final Project project) {
        SwingUtilities.invokeLater(new Runnable(){
            final TopComponent ptLogicalTC = ProjectUtilities.findDefault("projectTabLogical_tc");
            final ExplorerManager.Provider ptLogicalExplorerManager = (ExplorerManager.Provider)this.ptLogicalTC;

            @Override
            public void run() {
                if (this.ptLogicalExplorerManager == null) {
                    Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Cannot find Project widnow, aborting.");
                    return;
                }
                Node root = this.ptLogicalExplorerManager.getExplorerManager().getRootContext();
                for (Node projNode : root.getChildren().getNodes()) {
                    Project p = (Project)projNode.getLookup().lookup(Project.class);
                    if (p == null || !p.getProjectDirectory().equals(project.getProjectDirectory())) continue;
                    try {
                        this.ptLogicalExplorerManager.getExplorerManager().setSelectedNodes(new Node[]{projNode});
                        this.ptLogicalTC.requestActive();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private static synchronized TopComponent findDefault(String tcID) {
        TopComponent tc = WindowManager.getDefault().findTopComponent(tcID);
        return tc;
    }

    public static void newProjectWizard(File workingDirectory) {
        Action action = CommonProjectActions.newProjectAction();
        if (action != null) {
            File original = ProjectChooser.getProjectsFolder();
            ProjectChooser.setProjectsFolder((File)workingDirectory);
            FileObject workingFolder = FileUtil.toFileObject((File)workingDirectory);
            action.putValue("existingSourcesFolder", workingFolder);
            ProjectUtilities.performAction(action);
        }
    }

    public static void scanForProjects(FileObject scanRoot, Map<Project, Set<Project>> foundProjects) {
        ProjectManager.getDefault().clearNonProjectCache();
        assert (foundProjects.get(null) != null);
        ProjectUtilities.scanForProjectsRecursively(scanRoot, foundProjects, null, 5);
    }

    private static void scanForProjectsRecursively(FileObject scanRoot, Map<Project, Set<Project>> projects, Project parentProject, int deep) {
        if (deep <= 0) {
            return;
        }
        ProjectManager projectManager = ProjectManager.getDefault();
        if (scanRoot.isFolder() && projectManager.isProject(scanRoot)) {
            try {
                Project prj = projectManager.findProject(scanRoot);
                if (prj != null) {
                    Set<Project> siblings = projects.get(parentProject);
                    assert (siblings != null);
                    parentProject = prj;
                    siblings.add(prj);
                    projects.put(prj, new HashSet());
                }
            }
            catch (IOException e) {
                LOG.log(Level.INFO, " ignoring suspicious project folder...", e);
            }
        }
        Enumeration en = scanRoot.getChildren(false);
        while (en.hasMoreElements()) {
            FileObject fo = (FileObject)en.nextElement();
            if (!fo.isFolder()) continue;
            ProjectUtilities.scanForProjectsRecursively(fo, projects, parentProject, deep - 1);
        }
    }

    private static boolean performAction(Action a) {
        if (a == null) {
            return false;
        }
        ActionEvent ae = new ActionEvent(ProjectUtilities.class, 1001, "command");
        try {
            a.actionPerformed(ae);
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, null, e);
            return false;
        }
    }

    private ProjectUtilities() {
    }

    public static Set<? extends Project> getSubProjects(Project p) {
        Set subprojects = null;
        SubprojectProvider spp = (SubprojectProvider)p.getLookup().lookup(SubprojectProvider.class);
        subprojects = spp != null ? spp.getSubprojects() : Collections.emptySet();
        return subprojects;
    }

    public static void addSubprojects(Project p, Set<Project> result, Map<Project, Set<? extends Project>> cache) {
        Set<Object> subprojects = cache.get(p);
        if (subprojects == null) {
            SubprojectProvider spp = (SubprojectProvider)p.getLookup().lookup(SubprojectProvider.class);
            subprojects = spp != null ? spp.getSubprojects() : Collections.emptySet();
            cache.put(p, (Set<? extends Project>)subprojects);
            for (Project project : subprojects) {
                result.add(project);
                ProjectUtilities.addSubprojects(project, result, cache);
            }
        }
    }

    public static void sortProjectsByParents(List<Project> rootProjects, Map<Project, Set<Project>> sortedProjects) {
        ArrayList<Project> sortedList = new ArrayList<Project>(rootProjects.size());
        sortedList.sort(new Comparator<Project>(){

            @Override
            public int compare(Project o1, Project o2) {
                String p1 = o1.getProjectDirectory().getPath();
                String p2 = o2.getProjectDirectory().getPath();
                return p1.compareTo(p2);
            }
        });
    }
}

