/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class RecentFiles {
    static final String PROPERTY_RECENT_FILES = "RecentFiles";
    private static List<HistoryItem> history = new ArrayList<HistoryItem>();
    private static RequestProcessor RP = new RequestProcessor(RecentFiles.class);
    private static Preferences prefs;
    private static final Object HISTORY_LOCK;
    private static final String PREFS_NODE = "RecentFilesHistory";
    private static final String PROP_URL_PREFIX = "RecentFilesURL.";
    private static final String PROP_ICON_PREFIX = "RecentFilesIcon.";
    static final int MAX_HISTORY_ITEMS = 15;
    private static PropertyChangeListener windowRegistryListener;
    private static final Logger LOG;
    private static final String RECENT_FILE_KEY = "nb.recent.file.path";
    private static final PropertyChangeSupport PCH_SUPPORT;
    private static volatile boolean historyProbablyValid;

    private RecentFiles() {
    }

    public static void addPropertyChangeListener(PropertyChangeListener l) {
        PCH_SUPPORT.addPropertyChangeListener(l);
    }

    public static void removePropertyChangeListener(PropertyChangeListener l) {
        PCH_SUPPORT.removePropertyChangeListener(l);
    }

    public static void init() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<HistoryItem> loaded = RecentFiles.load();
                Object object = HISTORY_LOCK;
                synchronized (object) {
                    history.addAll(0, loaded);
                    PCH_SUPPORT.firePropertyChange(RecentFiles.PROPERTY_RECENT_FILES, null, null);
                    if (windowRegistryListener == null) {
                        windowRegistryListener = new WindowRegistryL();
                        TopComponent.getRegistry().addPropertyChangeListener(windowRegistryListener);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HistoryItem> getRecentFiles() {
        Object object = HISTORY_LOCK;
        synchronized (object) {
            RecentFiles.checkHistory();
            return Collections.unmodifiableList(history);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasRecentFiles() {
        if (!historyProbablyValid) {
            Object object = HISTORY_LOCK;
            synchronized (object) {
                RecentFiles.checkHistory();
                return !history.isEmpty();
            }
        }
        return historyProbablyValid;
    }

    static List<HistoryItem> load() {
        String[] keys;
        Preferences _prefs = RecentFiles.getPrefs();
        try {
            keys = _prefs.keys();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(RecentFiles.class.getName()).log(Level.FINE, ex.getMessage(), ex);
            return Collections.emptyList();
        }
        ArrayList<HistoryItem> result = new ArrayList<HistoryItem>();
        for (String curKey : keys) {
            if (curKey.startsWith(PROP_ICON_PREFIX)) continue;
            String value = _prefs.get(curKey, null);
            if (value != null) {
                try {
                    int id = Integer.parseInt(curKey.substring(PROP_URL_PREFIX.length()));
                    HistoryItem hItem = new HistoryItem(id, value, _prefs.getByteArray(PROP_ICON_PREFIX + id, null));
                    int ind = result.indexOf(hItem);
                    if (ind == -1) {
                        result.add(hItem);
                        continue;
                    }
                    _prefs.remove(PROP_URL_PREFIX + Math.max(((HistoryItem)result.get(ind)).id, id));
                    ((HistoryItem)result.get(ind)).id = Math.min(((HistoryItem)result.get(ind)).id, id);
                }
                catch (Exception ex) {
                    Logger.getLogger(RecentFiles.class.getName()).log(Level.FINE, ex.getMessage(), ex);
                    _prefs.remove(curKey);
                }
                continue;
            }
            _prefs.remove(curKey);
        }
        Collections.sort(result);
        RecentFiles.store(result);
        return result;
    }

    static void store() {
        RecentFiles.store(history);
    }

    static void store(List<HistoryItem> history) {
        Preferences _prefs = RecentFiles.getPrefs();
        for (int i = 0; i < history.size(); ++i) {
            HistoryItem hi = history.get(i);
            if (hi.id != i && hi.id >= history.size()) {
                _prefs.remove(PROP_URL_PREFIX + hi.id);
                _prefs.remove(PROP_ICON_PREFIX + hi.id);
            }
            hi.id = i;
            _prefs.put(PROP_URL_PREFIX + i, hi.getPath());
            if (hi.getIconBytes() == null) {
                _prefs.remove(PROP_ICON_PREFIX + i);
                continue;
            }
            _prefs.putByteArray(PROP_ICON_PREFIX + i, hi.getIconBytes());
        }
        LOG.log(Level.FINE, "Stored");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clear() {
        try {
            Object object = HISTORY_LOCK;
            synchronized (object) {
                history.clear();
                PCH_SUPPORT.firePropertyChange(PROPERTY_RECENT_FILES, null, null);
                RecentFiles.getPrefs().clear();
                RecentFiles.getPrefs().flush();
            }
        }
        catch (BackingStoreException ex) {
            LOG.log(Level.WARNING, null, ex);
        }
    }

    static Preferences getPrefs() {
        if (prefs == null) {
            prefs = NbPreferences.forModule(RecentFiles.class).node(PREFS_NODE);
        }
        return prefs;
    }

    private static void addFile(final TopComponent tc) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                RecentFiles.addFile(RecentFiles.obtainPath(tc));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addFile(String path) {
        if (path != null) {
            historyProbablyValid = false;
            Object object = HISTORY_LOCK;
            synchronized (object) {
                HistoryItem hItem = null;
                while (history.remove(hItem = RecentFiles.findHistoryItem(path))) {
                }
                HistoryItem newItem = new HistoryItem(0, path);
                history.add(0, newItem);
                for (int i = 15; i < history.size(); ++i) {
                    history.remove(i);
                }
                newItem.setIcon(RecentFiles.findIconForPath(newItem.getPath()));
                PCH_SUPPORT.firePropertyChange(PROPERTY_RECENT_FILES, null, null);
                RecentFiles.store();
            }
        }
    }

    private static void removeFile(final TopComponent tc) {
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                historyProbablyValid = false;
                String path = RecentFiles.obtainPath(tc);
                if (path != null) {
                    Object object = HISTORY_LOCK;
                    synchronized (object) {
                        HistoryItem hItem = RecentFiles.findHistoryItem(path);
                        if (hItem != null) {
                            history.remove(hItem);
                            PCH_SUPPORT.firePropertyChange(RecentFiles.PROPERTY_RECENT_FILES, null, null);
                        }
                        RecentFiles.store();
                    }
                }
            }
        });
    }

    private static Icon findIconForPath(String path) {
        ImageIcon i;
        FileObject fo = RecentFiles.convertPath2File(path);
        if (fo == null) {
            i = null;
        } else {
            DataObject dObj;
            try {
                dObj = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException e) {
                dObj = null;
            }
            i = dObj == null ? null : new ImageIcon(dObj.getNodeDelegate().getIcon(1));
        }
        return i;
    }

    private static String obtainPath(TopComponent tc) {
        FileObject fo;
        DataObject dObj;
        Object file = tc.getClientProperty((Object)RECENT_FILE_KEY);
        if (file instanceof File) {
            return ((File)file).getPath();
        }
        if (tc instanceof CloneableTopComponent && (dObj = (DataObject)tc.getLookup().lookup(DataObject.class)) != null && (fo = dObj.getPrimaryFile()) != null) {
            return RecentFiles.convertFile2Path(fo);
        }
        return null;
    }

    private static HistoryItem findHistoryItem(String path) {
        for (HistoryItem hItem : history) {
            if (!path.equals(hItem.getPath())) continue;
            return hItem;
        }
        return null;
    }

    static String convertFile2Path(FileObject fo) {
        File f = FileUtil.toFile((FileObject)fo);
        return f == null ? null : f.getPath();
    }

    static FileObject convertPath2File(String path) {
        File f = new File(path);
        return (f = FileUtil.normalizeFile((File)f)) == null ? null : FileUtil.toFileObject((File)f);
    }

    private static void checkHistory() {
        assert (Thread.holdsLock(HISTORY_LOCK));
        historyProbablyValid = !history.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static byte[] iconToBytes(Icon icon) {
        if (icon == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(out);
        Icon icn = icon;
        if (!(icn instanceof Serializable)) {
            icn = new ImageIcon(ImageUtilities.icon2Image((Icon)icn));
        }
        objOut.writeObject(icn);
        byte[] byArray = out.toByteArray();
        objOut.close();
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        objOut.close();
                        throw throwable;
                    }
                    catch (IOException ex) {
                        byte[] byArray2 = null;
                        return byArray2;
                    }
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Icon bytesToIcon(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ObjectInputStream objin = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            objin = new ObjectInputStream(in);
            Object obj = objin.readObject();
            Icon icon = obj instanceof Icon ? (Icon)obj : null;
            return icon;
        }
        catch (Exception ex) {
            Icon icon = null;
            return icon;
        }
        finally {
            try {
                if (objin != null) {
                    objin.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pruneHistory() {
        Object object = HISTORY_LOCK;
        synchronized (object) {
            Iterator<HistoryItem> it = history.iterator();
            while (it.hasNext()) {
                HistoryItem historyItem = it.next();
                File f = new File(historyItem.getPath());
                if (f.exists()) continue;
                it.remove();
            }
        }
    }

    static {
        HISTORY_LOCK = new Object();
        LOG = Logger.getLogger(RecentFiles.class.getName());
        PCH_SUPPORT = new PropertyChangeSupport(PROPERTY_RECENT_FILES);
    }

    public static final class HistoryItem
    implements Comparable<HistoryItem> {
        private int id;
        private String path;
        private String fileName;
        private Icon icon = null;

        HistoryItem(int id, String path) {
            this(id, path, null);
        }

        HistoryItem(int id, String path, byte[] iconBytes) {
            this.path = path;
            this.id = id;
            this.icon = RecentFiles.bytesToIcon(iconBytes);
        }

        public String getPath() {
            return this.path;
        }

        public String getFileName() {
            if (this.fileName == null) {
                int pos = this.path.lastIndexOf(File.separatorChar);
                this.fileName = pos != -1 && pos < this.path.length() ? this.path.substring(pos + 1) : this.path;
            }
            return this.fileName;
        }

        public Icon getIcon() {
            return this.icon == null ? ImageUtilities.loadImageIcon((String)"org/openide/resources/actions/empty.gif", (boolean)false) : this.icon;
        }

        void setIcon(Icon icon) {
            this.icon = icon;
        }

        byte[] getIconBytes() {
            return RecentFiles.iconToBytes(this.icon);
        }

        @Override
        public int compareTo(HistoryItem o) {
            return this.id - o.id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof HistoryItem) {
                return ((HistoryItem)obj).getPath().equals(this.path);
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + (this.path != null ? this.path.hashCode() : 0);
            return hash;
        }
    }

    public static final class NonPersistentDocumentsAdder
    implements Runnable {
        @Override
        public void run() {
            for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
                if (2 != tc.getPersistenceType()) continue;
                RecentFiles.addFile(tc);
            }
        }
    }

    private static class WindowRegistryL
    implements PropertyChangeListener {
        private WindowRegistryL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if ("tcClosed".equals(name)) {
                RecentFiles.addFile((TopComponent)evt.getNewValue());
            }
            if ("tcOpened".equals(name)) {
                RecentFiles.removeFile((TopComponent)evt.getNewValue());
            }
        }
    }
}

