/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.team.commons.treelist;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.team.commons.ColorManager;

public class LinkButton
extends JButton {
    private final boolean handlePopupEvents;
    private boolean underlined;

    public LinkButton(Icon icon, Action a) {
        this.setIcon(icon);
        this.setPressedIcon(icon);
        this.handlePopupEvents = true;
        this.underlined = true;
        this.init(a);
    }

    public LinkButton(String text, Icon icon, Action a, boolean underlined) {
        super(text);
        this.underlined = underlined;
        this.setIcon(icon);
        this.setPressedIcon(icon);
        Object tooltip = a.getValue("ShortDescription");
        if (null != tooltip) {
            this.setToolTipText(tooltip.toString());
        }
        this.handlePopupEvents = true;
        this.init(a);
    }

    public LinkButton(String text, Action a) {
        this(text, a, true);
    }

    public LinkButton(String text, Action a, boolean underlined) {
        this(text, true, a, underlined);
    }

    public LinkButton(String text, boolean handlePopupEvents, Action a) {
        this(text, handlePopupEvents, a, true);
    }

    public LinkButton(String text, boolean handlePopupEvents, Action a, boolean underlined) {
        super(text);
        this.handlePopupEvents = handlePopupEvents;
        this.underlined = underlined;
        if (null != a) {
            Object tooltip;
            Icon icon = (Icon)a.getValue("SmallIcon");
            if (null != icon) {
                this.setIcon(icon);
                this.setPressedIcon(icon);
            }
            if (null != (tooltip = a.getValue("ShortDescription"))) {
                this.setToolTipText(tooltip.toString());
            }
        }
        this.init(a);
    }

    boolean isHandlingPopupEvents() {
        return this.handlePopupEvents;
    }

    public void setForeground(Color foreground, boolean isSelected) {
        if (isSelected) {
            if (foreground instanceof UIResource) {
                foreground = new Color(foreground.getRGB());
            }
            this.setForeground(foreground);
        } else if (this.isEnabled()) {
            this.setForeground(ColorManager.getDefault().getLinkColor());
        } else {
            this.setForeground(ColorManager.getDefault().getDisabledColor());
        }
    }

    private void init(Action al) {
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setFocusable(false);
        this.setContentAreaFilled(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setModel(new Model());
        if (null != al) {
            this.addActionListener(al);
            this.setForeground(ColorManager.getDefault().getLinkColor());
        } else {
            this.setEnabled(false);
            this.setForeground(ColorManager.getDefault().getDisabledColor());
        }
        Font font = UIManager.getFont("Tree.font");
        if (this.underlined) {
            HashMap<TextAttribute, Integer> map = new HashMap<TextAttribute, Integer>();
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
            font = font.deriveFont(map);
        }
        this.setFont(font);
    }

    private static class Model
    extends DefaultButtonModel {
        private Model() {
        }

        @Override
        public boolean isPressed() {
            return false;
        }
    }
}

