/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.commons;

import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.bugtracking.commons.AutoupdatePanel;
import org.netbeans.modules.bugtracking.commons.Bundle;
import org.netbeans.modules.bugtracking.commons.Support;
import org.netbeans.modules.bugtracking.commons.Util;
import org.netbeans.modules.team.ide.spi.IDEServices;

public final class AutoupdateSupport {
    private static final String CHECK_UPDATES = ".check_updates";
    private static final Logger LOG = Logger.getLogger(AutoupdateSupport.class.getName());
    private Map<String, Long> lastChecks = null;
    private Set<String> loggedUrls;
    private final Callback callback;
    private final String cnb;
    private final String pluginName;

    public AutoupdateSupport(Callback callback, String cnb, String pluginName) {
        this.callback = callback;
        this.cnb = cnb;
        this.pluginName = pluginName;
    }

    boolean getCheckUpdates() {
        Support.getInstance();
        return Support.getPreferences().getBoolean(this.cnb + CHECK_UPDATES, true);
    }

    void setCheckUpdates(boolean b) {
        Support.getInstance();
        Support.getPreferences().putBoolean(this.cnb + CHECK_UPDATES, b);
    }

    String getPluginName() {
        return this.pluginName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndNotify(String url) {
        LOG.log(Level.FINEST, "{0} AutoupdateSupport.checkAndNotify start", this.pluginName);
        IDEServices ideServices = Support.getInstance().getIDEServices();
        if (ideServices == null || !ideServices.providesPluginUpdate()) {
            return;
        }
        try {
            if (this.wasCheckedToday(this.getLastCheck(url))) {
                return;
            }
            if (!this.getCheckUpdates()) {
                return;
            }
            String serverVersion = this.callback.getServerVersion(url);
            if (serverVersion != null && !this.callback.isSupportedVersion(serverVersion)) {
                AutoupdatePanel panel;
                IDEServices.Plugin plugin;
                boolean alreadyLogged;
                boolean bl = alreadyLogged = this.loggedUrls != null && this.loggedUrls.contains(url);
                if (!alreadyLogged) {
                    LOG.log(Level.INFO, "{0} repository [{1}] has version {2}. ", new Object[]{this.pluginName, url, serverVersion});
                    if (this.loggedUrls == null) {
                        this.loggedUrls = new HashSet<String>();
                    }
                    this.loggedUrls.add(url);
                }
                if ((plugin = this.checkNewPluginAvailable()) != null && Util.show(panel = new AutoupdatePanel(this), Bundle.CTL_AutoupdateTitle(this.pluginName), Bundle.CTL_Yes())) {
                    plugin.installOrUpdate();
                }
            }
        }
        finally {
            LOG.log(Level.FINEST, "{0} AutoupdateSupport.checkAndNotify finish", this.pluginName);
        }
    }

    public IDEServices.Plugin checkNewPluginAvailable() {
        IDEServices ideServices = Support.getInstance().getIDEServices();
        IDEServices.Plugin plugin = ideServices.getPluginUpdates(this.cnb, this.pluginName);
        if (plugin != null && this.callback.checkIfShouldDownload(plugin.getDescription())) {
            return plugin;
        }
        return null;
    }

    boolean wasCheckedToday(long lastCheck) {
        if (lastCheck < 0L) {
            return false;
        }
        Calendar c = Calendar.getInstance();
        c.add(13, c.get(13) * -1);
        c.add(12, c.get(12) * -1);
        c.add(10, c.get(10) * -1);
        return lastCheck > c.getTime().getTime();
    }

    private long getLastCheck(String url) {
        Long l;
        if (this.lastChecks == null) {
            this.lastChecks = new HashMap<String, Long>(1);
        }
        if ((l = this.lastChecks.get(url)) == null) {
            this.lastChecks.put(url, System.currentTimeMillis());
            return -1L;
        }
        return l;
    }

    public static interface Callback {
        public String getServerVersion(String var1);

        public boolean isSupportedVersion(String var1);

        public boolean checkIfShouldDownload(String var1);
    }
}

