/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ClientCheckSupport {
    private static ClientCheckSupport instance;
    private final RequestProcessor rp = new RequestProcessor("SvnClientCheckRP", 1, true);
    private static final Logger LOG;

    public static synchronized ClientCheckSupport getInstance() {
        if (instance == null) {
            instance = new ClientCheckSupport();
        }
        return instance;
    }

    private ClientCheckSupport() {
    }

    public void runInAWTIfAvailable(final String progressName, final Runnable runnable) {
        SvnProgressSupport supp = new SvnProgressSupport(){

            @Override
            protected void perform() {
                this.setDisplayName(NbBundle.getMessage(ClientCheckSupport.class, (String)"MSG_ClientCheckSupport.progressDescription"));
                if (!Subversion.getInstance().checkClientAvailable()) {
                    LOG.log(Level.FINE, "Client is unavailable, cannot perform {0}", progressName);
                    return;
                }
                if (!this.isCanceled()) {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        };
        supp.start(this.rp, null, progressName == null ? NbBundle.getMessage(ClientCheckSupport.class, (String)"MSG_ClientCheckSupport.progressDescription") : progressName);
    }

    static {
        LOG = Logger.getLogger(ClientCheckSupport.class.getName());
    }
}

