/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ListPropertiesCommand
extends SvnCommand {
    private List<String> output = new ArrayList<String>();
    private final File file;
    private final boolean rec;
    private final SVNUrl url;
    private final String rev;
    private final ListType type;

    public ListPropertiesCommand(File file, boolean rec) {
        this.file = file;
        this.rec = rec;
        this.url = null;
        this.rev = null;
        this.type = ListType.file;
    }

    public ListPropertiesCommand(SVNUrl url, boolean rec) {
        this(url, null, rec);
    }

    public ListPropertiesCommand(SVNUrl url, String revision, boolean rec) {
        this.url = url;
        this.rec = rec;
        this.file = null;
        this.rev = revision;
        this.type = ListType.url;
    }

    @Override
    protected boolean notifyOutput() {
        return false;
    }

    @Override
    protected int getCommand() {
        return 21;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("proplist");
        if (this.rec) {
            arguments.add("-R");
        }
        switch (this.type) {
            case file: {
                arguments.add(this.file);
                break;
            }
            case url: {
                arguments.add(this.url);
                if (this.rev == null) break;
                arguments.add("-r");
                arguments.add(this.rev);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal gettype: " + (Object)((Object)this.type));
            }
        }
    }

    @Override
    public void outputText(String lineString) {
        if (lineString == null || lineString.trim().equals("") || lineString.startsWith("Properties on '")) {
            return;
        }
        this.output.add(lineString.trim());
    }

    public List<String> getPropertyNames() throws SVNClientException {
        return this.output;
    }

    private static enum ListType {
        url,
        file;

    }
}

