/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.update.UpdateAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.nodes.Node;

public class UpdateWithDependenciesAction
extends ContextAction {
    private boolean running;

    @Override
    protected int getFileEnabledStatus() {
        return 86008;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_UpdateWithDependencies";
    }

    @Override
    protected boolean enable(Node[] nodes) {
        boolean enabled;
        boolean bl = enabled = !this.running && super.enable(nodes);
        if (enabled) {
            for (int i = 0; i < nodes.length; ++i) {
                Node node = nodes[i];
                if (SvnUtils.isVersionedProject(node, false)) continue;
                enabled = false;
                break;
            }
        }
        return enabled;
    }

    @Override
    protected void performContextAction(final Node[] nodes) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        this.running = true;
        Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                try {
                    UpdateWithDependenciesAction.this.updateWithDependencies(nodes);
                }
                finally {
                    UpdateWithDependenciesAction.this.running = false;
                }
            }
        });
    }

    private void updateWithDependencies(Node[] nodes) {
        HashSet<Project> projectsToUpdate = new HashSet<Project>(nodes.length * 2);
        for (Node node : nodes) {
            if (!SvnUtils.isVersionedProject(node, true)) continue;
            Project project = (Project)node.getLookup().lookup(Project.class);
            projectsToUpdate.add(project);
            SubprojectProvider deps = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
            if (deps == null) continue;
            Set children = deps.getSubprojects();
            for (Project child : children) {
                if (!SvnUtils.isVersionedProject(child, true)) continue;
                projectsToUpdate.add(child);
            }
        }
        Context context = SvnUtils.getProjectsContext(projectsToUpdate.toArray(new Project[projectsToUpdate.size()]));
        UpdateAction.performUpdate(context, this.getContextDisplayName(nodes));
    }
}

