/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class CatCommand
extends SvnCommand {
    private final CatType type;
    private SVNUrl url;
    private File file;
    private SVNRevision rev;
    private final SVNRevision pegRevision;
    private byte[] bytes;

    public CatCommand(SVNUrl url, SVNRevision rev, SVNRevision pegRevision) {
        this.url = url;
        this.rev = rev;
        this.file = null;
        this.pegRevision = pegRevision;
        this.type = CatType.url;
    }

    public CatCommand(File file, SVNRevision rev) {
        this.file = file;
        this.rev = rev;
        this.url = null;
        this.pegRevision = null;
        this.type = CatType.file;
    }

    public InputStream getOutput() {
        return new ByteArrayInputStream(this.bytes == null ? new byte[]{} : this.bytes);
    }

    @Override
    protected boolean hasBinaryOutput() {
        return true;
    }

    @Override
    protected boolean notifyOutput() {
        return false;
    }

    @Override
    public void output(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    protected int getCommand() {
        return 18;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("cat");
        switch (this.type) {
            case url: {
                if (this.pegRevision == null) {
                    arguments.add(this.url);
                    break;
                }
                arguments.add(this.url, this.pegRevision);
                break;
            }
            case file: {
                arguments.add(this.file);
                this.setCommandWorkingDirectory(this.file);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal cattype: " + (Object)((Object)this.type));
            }
        }
        arguments.add(this.rev);
    }

    private static enum CatType {
        url,
        file;

    }
}

