/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.webmvc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.spring.api.SpringUtilities;
import org.netbeans.modules.spring.webmvc.Bundle;
import org.netbeans.modules.spring.webmvc.SpringWebModuleExtender;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SpringConfigPanelVisual
extends JPanel {
    private static final Logger LOG = Logger.getLogger(SpringConfigPanelVisual.class.getName());
    private static final long serialVersionUID = 1L;
    private boolean libsInitialized = false;
    private List<SpringLibrary> springLibs = new ArrayList<SpringLibrary>();
    private SpringLibrary springLibrary;
    private final SpringWebModuleExtender extender;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final DocumentListener docListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            SpringConfigPanelVisual.this.fireChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SpringConfigPanelVisual.this.fireChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SpringConfigPanelVisual.this.fireChange();
        }
    };
    private JComboBox cbSpringVersion;
    private JLabel dispatcherMappingLabel;
    private JTextField dispatcherMappingText;
    private JLabel dispatcherNameLabel;
    private JTextField dispatcherNameText;
    private JCheckBox includeJstlCheckBox;
    private JPanel libPanel;
    private JLabel springVersionLabel;
    private JPanel standardPanel;
    private JTabbedPane tabbedPanel;

    public SpringConfigPanelVisual(SpringWebModuleExtender extender) {
        this.extender = extender;
        this.initComponents();
        this.dispatcherNameText.setText(extender.getDispatcherName());
        this.dispatcherNameText.getDocument().addDocumentListener(this.docListener);
        this.dispatcherMappingText.setText(extender.getDispatcherMapping());
        this.dispatcherMappingText.getDocument().addDocumentListener(this.docListener);
        this.includeJstlCheckBox.setSelected(extender.getIncludeJstl());
        this.changeSupport.addChangeListener((ChangeListener)extender);
        this.initLibraries();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.tabbedPanel.setEnabled(enabled);
        this.dispatcherNameText.setEnabled(enabled);
        this.dispatcherMappingText.setEnabled(enabled);
        this.includeJstlCheckBox.setEnabled(enabled);
        this.springVersionLabel.setEnabled(enabled);
        this.cbSpringVersion.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public String getDispatcherName() {
        return this.dispatcherNameText.getText();
    }

    public String getDispatcherMapping() {
        return this.dispatcherMappingText.getText();
    }

    public boolean getIncludeJstl() {
        return this.includeJstlCheckBox.isSelected();
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.tabbedPanel = new JTabbedPane();
        this.libPanel = new JPanel();
        this.includeJstlCheckBox = new JCheckBox();
        this.springVersionLabel = new JLabel();
        this.cbSpringVersion = new JComboBox();
        this.standardPanel = new JPanel();
        this.dispatcherNameText = new JTextField();
        this.dispatcherNameLabel = new JLabel();
        this.dispatcherMappingLabel = new JLabel();
        this.dispatcherMappingText = new JTextField();
        this.setLayout(new BorderLayout());
        this.libPanel.setAlignmentX(0.2f);
        this.libPanel.setAlignmentY(0.2f);
        Mnemonics.setLocalizedText((AbstractButton)this.includeJstlCheckBox, (String)NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"LBL_IncludeJstl"));
        this.includeJstlCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpringConfigPanelVisual.this.includeJstlCheckBoxActionPerformed(evt);
            }
        });
        this.springVersionLabel.setLabelFor(this.cbSpringVersion);
        Mnemonics.setLocalizedText((JLabel)this.springVersionLabel, (String)NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"SpringConfigPanelVisual.springVersionLabel.text"));
        this.cbSpringVersion.setModel(SpringConfigPanelVisual.getLibrariesComboBoxModel());
        this.cbSpringVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpringConfigPanelVisual.this.cbSpringVersionActionPerformed(evt);
            }
        });
        GroupLayout libPanelLayout = new GroupLayout(this.libPanel);
        this.libPanel.setLayout(libPanelLayout);
        libPanelLayout.setHorizontalGroup(libPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(libPanelLayout.createSequentialGroup().addContainerGap().addGroup(libPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(libPanelLayout.createSequentialGroup().addComponent(this.springVersionLabel).addGap(18, 18, 18).addComponent(this.cbSpringVersion, 0, 450, Short.MAX_VALUE)).addGroup(libPanelLayout.createSequentialGroup().addComponent(this.includeJstlCheckBox).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        libPanelLayout.setVerticalGroup(libPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(libPanelLayout.createSequentialGroup().addContainerGap().addGroup(libPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.springVersionLabel).addComponent(this.cbSpringVersion, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.includeJstlCheckBox).addContainerGap(313, Short.MAX_VALUE)));
        this.includeJstlCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"SpringConfigPanelVisual.includeJstlCheckBox.AccessibleContext.accessibleDescription"));
        this.tabbedPanel.addTab(NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"LBL_Libraries"), this.libPanel);
        Mnemonics.setLocalizedText((JLabel)this.dispatcherNameLabel, (String)NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"LBL_DispatcherName"));
        Mnemonics.setLocalizedText((JLabel)this.dispatcherMappingLabel, (String)NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"LBL_DispatcherMapping"));
        GroupLayout standardPanelLayout = new GroupLayout(this.standardPanel);
        this.standardPanel.setLayout(standardPanelLayout);
        standardPanelLayout.setHorizontalGroup(standardPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(standardPanelLayout.createSequentialGroup().addContainerGap().addGroup(standardPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dispatcherNameLabel).addComponent(this.dispatcherMappingLabel)).addGap(8, 8, 8).addGroup(standardPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dispatcherNameText, -1, 418, Short.MAX_VALUE).addComponent(this.dispatcherMappingText, -1, 416, Short.MAX_VALUE)).addContainerGap()));
        standardPanelLayout.setVerticalGroup(standardPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(standardPanelLayout.createSequentialGroup().addContainerGap().addGroup(standardPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dispatcherNameLabel).addComponent(this.dispatcherNameText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(standardPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dispatcherMappingLabel).addComponent(this.dispatcherMappingText, -2, -1, -2)).addContainerGap(334, Short.MAX_VALUE)));
        this.tabbedPanel.addTab(NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"LBL_Configuration"), this.standardPanel);
        this.add((Component)this.tabbedPanel, "Center");
        this.tabbedPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"SpringConfigPanelVisual.tabbedPanel.AccessibleContext.accessibleName"));
    }

    private void includeJstlCheckBoxActionPerformed(ActionEvent evt) {
        this.fireChange();
    }

    private void cbSpringVersionActionPerformed(ActionEvent evt) {
        this.springLibrary = this.springLibs.get(this.cbSpringVersion.getSelectedIndex());
    }

    public void enableComponents(boolean enabled) {
        this.standardPanel.setEnabled(enabled);
        this.dispatcherMappingLabel.setEnabled(enabled);
        this.dispatcherMappingText.setEnabled(enabled);
        this.dispatcherNameLabel.setEnabled(enabled);
        this.dispatcherNameText.setEnabled(enabled);
        this.tabbedPanel.setEnabled(enabled);
        this.springVersionLabel.setEnabled(enabled);
        this.cbSpringVersion.setEnabled(enabled);
    }

    public Library getSpringLibrary() {
        if (this.springLibrary == null) {
            return null;
        }
        return this.springLibrary.getLibrary();
    }

    public String getSpringLibraryVersion() {
        return this.springLibrary.getVersion();
    }

    private static ComboBoxModel getLibrariesComboBoxModel() {
        return new DefaultComboBoxModel<String>(new String[]{Bundle.JSFConfigurationPanelVisual_lbl_searching_libraries()});
    }

    private synchronized void initLibraries() {
        if (this.libsInitialized) {
            return;
        }
        this.springLibs.clear();
        RequestProcessor.getDefault().submit(new Runnable(){

            @Override
            public void run() {
                long startTime = System.currentTimeMillis();
                final ArrayList<String> items = new ArrayList<String>();
                for (Library library : LibraryManager.getDefault().getLibraries()) {
                    if (!SpringUtilities.isSpringLibrary((Library)library)) continue;
                    items.add(library.getDisplayName());
                    SpringConfigPanelVisual.this.springLibs.add(new SpringLibrary(library));
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpringConfigPanelVisual.this.cbSpringVersion.setModel(new DefaultComboBoxModel<String>(items.toArray(new String[items.size()])));
                        int selectedIndex = SpringConfigPanelVisual.this.cbSpringVersion.getSelectedIndex();
                        if (selectedIndex < SpringConfigPanelVisual.this.springLibs.size()) {
                            SpringConfigPanelVisual.this.springLibrary = (SpringLibrary)SpringConfigPanelVisual.this.springLibs.get(selectedIndex);
                            SpringConfigPanelVisual.this.libsInitialized = true;
                            SpringConfigPanelVisual.this.repaint();
                            SpringConfigPanelVisual.this.fireChange();
                        }
                    }
                });
                LOG.log(Level.FINEST, "Time spent in {0} initLibraries = {1} ms", new Object[]{this.getClass().getName(), System.currentTimeMillis() - startTime});
            }
        });
    }

    private class SpringLibrary {
        private Library springLibrary;
        private String version;

        public SpringLibrary(Library springLibrary) {
            this.springLibrary = springLibrary;
        }

        public String getVersion() {
            if (this.version == null) {
                this.version = SpringUtilities.getSpringLibraryVersion((Library)this.springLibrary);
            }
            return this.version;
        }

        public Library getLibrary() {
            return this.springLibrary;
        }

        public String toString() {
            return this.springLibrary.getDisplayName();
        }
    }
}

