/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.beans.ConfigFileManagerImplementation;
import org.netbeans.modules.spring.util.ConfigFiles;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProjectConfigFileManagerImpl
implements ConfigFileManagerImplementation {
    private static final Logger LOGGER = Logger.getLogger(ProjectConfigFileManagerImpl.class.getName());
    private static final String SPRING_DATA = "spring-data";
    private static final String CONFIG_FILES = "config-files";
    private static final String CONFIG_FILE_GROUPS = "config-file-groups";
    private static final String CONFIG_FILE_GROUP = "config-file-group";
    private static final String NAME = "name";
    private static final String CONFIG_FILE = "config-file";
    private static final String SPRING_DATA_NS = "http://www.netbeans.org/ns/spring-data/1";
    private final Project project;
    private final AuxiliaryConfiguration auxConfig;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private List<File> files;
    private List<ConfigFileGroup> groups;

    public ProjectConfigFileManagerImpl(Project project) {
        this.project = project;
        this.auxConfig = ProjectUtils.getAuxiliaryConfiguration((Project)project);
    }

    @Override
    public Mutex mutex() {
        return ProjectManager.mutex();
    }

    @Override
    public List<File> getConfigFiles() {
        return (List)this.mutex().readAccess((Mutex.Action)new Mutex.Action<List<File>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<File> run() {
                ProjectConfigFileManagerImpl projectConfigFileManagerImpl = ProjectConfigFileManagerImpl.this;
                synchronized (projectConfigFileManagerImpl) {
                    if (ProjectConfigFileManagerImpl.this.files == null) {
                        ProjectConfigFileManagerImpl.this.readConfiguration();
                    }
                    assert (ProjectConfigFileManagerImpl.this.files != null);
                }
                ArrayList<File> result = new ArrayList<File>();
                for (File file : ProjectConfigFileManagerImpl.this.files) {
                    if (!file.exists()) continue;
                    result.add(file);
                }
                return result;
            }
        });
    }

    @Override
    public List<ConfigFileGroup> getConfigFileGroups() {
        return (List)this.mutex().readAccess((Mutex.Action)new Mutex.Action<List<ConfigFileGroup>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<ConfigFileGroup> run() {
                ProjectConfigFileManagerImpl projectConfigFileManagerImpl = ProjectConfigFileManagerImpl.this;
                synchronized (projectConfigFileManagerImpl) {
                    if (ProjectConfigFileManagerImpl.this.groups == null) {
                        ProjectConfigFileManagerImpl.this.readConfiguration();
                    }
                    assert (ProjectConfigFileManagerImpl.this.groups != null);
                }
                ArrayList<ConfigFileGroup> result = new ArrayList<ConfigFileGroup>(ProjectConfigFileManagerImpl.this.groups.size());
                result.addAll(ProjectConfigFileManagerImpl.this.groups);
                ProjectConfigFileManagerImpl.this.removeUnknownFiles(result, new HashSet(ProjectConfigFileManagerImpl.this.files));
                return result;
            }
        });
    }

    @Override
    public void putConfigFilesAndGroups(List<File> newFiles, List<ConfigFileGroup> newGroups) {
        assert (this.mutex().isWriteAccess());
        this.writeConfiguration(newFiles, newGroups);
        this.files = new ArrayList<File>(newFiles.size());
        this.files.addAll(newFiles);
        this.groups = new ArrayList<ConfigFileGroup>(newGroups.size());
        this.groups.addAll(newGroups);
        this.changeSupport.fireChange();
    }

    @Override
    public void save() throws IOException {
        assert (this.mutex().isWriteAccess());
        ProjectManager.getDefault().saveProject(this.project);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    private void readConfiguration() {
        assert (this.mutex().isReadAccess());
        File projectDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        if (projectDir == null) {
            LOGGER.warning("The directory of project " + this.project + "is null");
            this.files = Collections.emptyList();
            this.groups = Collections.emptyList();
        }
        List<File> newFiles = new ArrayList<File>();
        ArrayList<ConfigFileGroup> newGroups = new ArrayList<ConfigFileGroup>();
        Element springConfigEl = this.auxConfig.getConfigurationFragment(SPRING_DATA, SPRING_DATA_NS, true);
        if (springConfigEl != null) {
            List<File> modifiedList;
            NodeList list = springConfigEl.getElementsByTagNameNS(SPRING_DATA_NS, CONFIG_FILES);
            if (list.getLength() > 0) {
                Element configFilesEl = (Element)list.item(0);
                list = configFilesEl.getElementsByTagNameNS(SPRING_DATA_NS, CONFIG_FILE);
                this.readFiles(list, projectDir, newFiles);
            }
            if ((list = springConfigEl.getElementsByTagNameNS(SPRING_DATA_NS, CONFIG_FILE_GROUPS)).getLength() > 0) {
                Element configFileGroupsEl = (Element)list.item(0);
                list = configFileGroupsEl.getElementsByTagNameNS(SPRING_DATA_NS, CONFIG_FILE_GROUP);
                this.readGroups(list, projectDir, newGroups);
            }
            if ((modifiedList = this.removeUnknownFiles(newGroups, new HashSet<File>(newFiles))).size() > 0) {
                newFiles = modifiedList;
            }
        }
        this.files = newFiles;
        this.groups = newGroups;
    }

    private void readFiles(NodeList configFileEls, File basedir, List<File> files) {
        HashSet<File> addedFiles = new HashSet<File>();
        for (int i = 0; i < configFileEls.getLength(); ++i) {
            Element configFileEl = (Element)configFileEls.item(i);
            File file = ConfigFiles.resolveFile(basedir, configFileEl.getTextContent());
            if (file == null || !addedFiles.add(file)) continue;
            files.add(file);
        }
    }

    private void readGroups(NodeList configFileGroupEls, File basedir, List<ConfigFileGroup> groups) {
        for (int i = 0; i < configFileGroupEls.getLength(); ++i) {
            Element configFileGroupEl = (Element)configFileGroupEls.item(i);
            String name = configFileGroupEl.getAttribute(NAME);
            NodeList configFileEls = configFileGroupEl.getElementsByTagNameNS(SPRING_DATA_NS, CONFIG_FILE);
            ArrayList<File> configFiles = new ArrayList<File>(configFileEls.getLength());
            this.readFiles(configFileEls, basedir, configFiles);
            groups.add(ConfigFileGroup.create(name, configFiles));
        }
    }

    private List<File> removeUnknownFiles(List<ConfigFileGroup> newGroups, Set<File> knownFiles) {
        boolean modified = false;
        ArrayList<File> fileList = new ArrayList<File>();
        for (int i = 0; i < newGroups.size(); ++i) {
            ConfigFileGroup group = newGroups.get(i);
            for (File file : group.getFiles()) {
                if (!file.exists()) {
                    knownFiles.remove(file);
                    modified = true;
                }
                if (knownFiles.contains(file)) continue;
                ArrayList<File> newGroupFiles = new ArrayList<File>(group.getFiles().size());
                for (File each : group.getFiles()) {
                    if (!knownFiles.contains(each)) continue;
                    newGroupFiles.add(each);
                }
                newGroups.set(i, ConfigFileGroup.create(group.getName(), newGroupFiles));
            }
        }
        if (modified) {
            for (File file : knownFiles) {
                fileList.add(file);
            }
        }
        return fileList;
    }

    private void writeConfiguration(List<File> files, List<ConfigFileGroup> groups) {
        assert (this.mutex().isWriteAccess());
        File projectDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        if (projectDir == null) {
            LOGGER.log(Level.WARNING, "The directory of project {0} is null", this.project);
            return;
        }
        if (this.differingFiles(files) || this.differingGroups(groups)) {
            if (!files.isEmpty() || !groups.isEmpty()) {
                Document doc = XMLUtil.createDocument((String)SPRING_DATA, (String)SPRING_DATA_NS, null, null);
                Element springConfigEl = doc.getDocumentElement();
                Element configFilesEl = springConfigEl.getOwnerDocument().createElementNS(SPRING_DATA_NS, CONFIG_FILES);
                springConfigEl.appendChild(configFilesEl);
                this.writeFiles(files, projectDir, configFilesEl);
                Element configFileGroupsEl = springConfigEl.getOwnerDocument().createElementNS(SPRING_DATA_NS, CONFIG_FILE_GROUPS);
                springConfigEl.appendChild(configFileGroupsEl);
                this.writeGroups(groups, projectDir, configFileGroupsEl);
                this.auxConfig.putConfigurationFragment(springConfigEl, true);
            } else {
                this.auxConfig.removeConfigurationFragment(SPRING_DATA, SPRING_DATA_NS, true);
            }
        }
    }

    private boolean differingFiles(List<File> files) {
        if (this.files.size() == files.size()) {
            return !Arrays.equals(this.files.toArray(new File[this.files.size()]), files.toArray(new File[files.size()]));
        }
        return true;
    }

    private boolean differingGroups(List<ConfigFileGroup> groups) {
        if (this.groups.size() == groups.size()) {
            return !Arrays.equals(this.groups.toArray(new ConfigFileGroup[this.groups.size()]), groups.toArray(new ConfigFileGroup[groups.size()]));
        }
        return true;
    }

    private void writeFiles(List<File> files, File basedir, Element parentEl) {
        for (File file : files) {
            Element configFileEl = parentEl.getOwnerDocument().createElementNS(SPRING_DATA_NS, CONFIG_FILE);
            configFileEl.appendChild(configFileEl.getOwnerDocument().createTextNode(ConfigFiles.getRelativePath(basedir, file)));
            parentEl.appendChild(configFileEl);
        }
    }

    private void writeGroups(List<ConfigFileGroup> groups, File basedir, Element configFileGroupsEl) {
        for (ConfigFileGroup group : groups) {
            Element configFileGroupEl = configFileGroupsEl.getOwnerDocument().createElementNS(SPRING_DATA_NS, CONFIG_FILE_GROUP);
            String name = group.getName();
            if (name != null && name.length() > 0) {
                configFileGroupEl.setAttribute(NAME, name);
            }
            this.writeFiles(group.getFiles(), basedir, configFileGroupEl);
            configFileGroupsEl.appendChild(configFileGroupEl);
        }
    }
}

