/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.refactoring.spi.ModificationResult;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

public final class Modifications
implements ModificationResult {
    private final Map<FileObject, List<Difference>> diffs = new HashMap<FileObject, List<Difference>>();

    public void addDifference(FileObject fileObject, Difference difference) {
        List<Difference> differences = this.diffs.get(fileObject);
        if (differences == null) {
            differences = new ArrayList<Difference>();
            differences.add(difference);
            this.diffs.put(fileObject, differences);
        } else {
            differences.add(difference);
        }
    }

    public Set<? extends FileObject> getModifiedFileObjects() {
        return this.diffs.keySet();
    }

    public void commit() throws IOException {
        for (Map.Entry<FileObject, List<Difference>> me : this.diffs.entrySet()) {
            this.commit(me.getKey(), me.getValue(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void commit(FileObject fileObject, List<Difference> differences, Writer outWriter) throws IOException {
        StyledDocument doc;
        EditorCookie editorCookie;
        DataObject dataObj = DataObject.find((FileObject)fileObject);
        EditorCookie editorCookie2 = editorCookie = dataObj != null ? (EditorCookie)dataObj.getCookie(EditorCookie.class) : null;
        if (editorCookie != null && outWriter == null && (doc = editorCookie.getDocument()) != null) {
            if (doc instanceof BaseDocument) {
                ((BaseDocument)doc).atomicLock();
            }
            try {
                for (Difference diff : differences) {
                    if (diff.isExcluded()) continue;
                    try {
                        switch (diff.getKind()) {
                            case INSERT: {
                                doc.insertString(diff.getStartPosition().getOffset(), diff.getNewText(), null);
                                break;
                            }
                            case REMOVE: {
                                doc.remove(diff.getStartPosition().getOffset(), diff.getEndPosition().getOffset() - diff.getStartPosition().getOffset());
                                break;
                            }
                            case CHANGE: {
                                doc.remove(diff.getStartPosition().getOffset(), diff.getEndPosition().getOffset() - diff.getStartPosition().getOffset());
                                doc.insertString(diff.getStartPosition().getOffset(), diff.getNewText(), null);
                            }
                        }
                    }
                    catch (BadLocationException ex) {
                        IOException ioe = new IOException();
                        ioe.initCause(ex);
                        throw ioe;
                        return;
                    }
                }
            }
            finally {
                if (doc instanceof BaseDocument) {
                    ((BaseDocument)doc).atomicUnlock();
                }
            }
        }
        InputStream ins = null;
        ByteArrayOutputStream baos = null;
        Reader inputReader = null;
        try {
            int count;
            Charset encoding = FileEncodingQuery.getEncoding((FileObject)fileObject);
            ins = fileObject.getInputStream();
            baos = new ByteArrayOutputStream();
            FileUtil.copy((InputStream)ins, (OutputStream)baos);
            ins.close();
            ins = null;
            byte[] arr = baos.toByteArray();
            int arrLength = this.convertToLF(arr);
            baos.close();
            baos = null;
            inputReader = new InputStreamReader((InputStream)new ByteArrayInputStream(arr, 0, arrLength), encoding);
            if (outWriter == null) {
                outWriter = new OutputStreamWriter(fileObject.getOutputStream(), encoding);
            }
            int offset = 0;
            Difference[] aDifferences = differences.toArray(new Difference[differences.size()]);
            Arrays.sort(aDifferences, new Comparator<Difference>(){

                @Override
                public int compare(Difference diff1, Difference diff2) {
                    int result = 0;
                    if (diff1.getStartPosition().getOffset() < diff2.getStartPosition().getOffset()) {
                        result = -1;
                    } else if (diff1.getStartPosition().getOffset() > diff2.getStartPosition().getOffset()) {
                        result = 1;
                    }
                    return result;
                }
            });
            block19: for (Difference diff : aDifferences) {
                int length;
                if (diff.isExcluded()) continue;
                int pos = diff.getStartPosition().getOffset();
                int toread = pos - offset;
                char[] buff = new char[toread];
                int rcounter = 0;
                while ((length = inputReader.read(buff, 0, toread - rcounter)) > 0 && rcounter < toread) {
                    outWriter.write(buff, 0, length);
                    rcounter += length;
                    offset += length;
                }
                switch (diff.getKind()) {
                    case INSERT: {
                        outWriter.write(diff.getNewText());
                        continue block19;
                    }
                    case REMOVE: {
                        int len = diff.getEndPosition().getOffset() - diff.getStartPosition().getOffset();
                        inputReader.skip(len);
                        offset += len;
                        continue block19;
                    }
                    case CHANGE: {
                        int len = diff.getEndPosition().getOffset() - diff.getStartPosition().getOffset();
                        inputReader.skip(len);
                        offset += len;
                        outWriter.write(diff.getNewText());
                    }
                }
            }
            char[] buff = new char[1024];
            while ((count = inputReader.read(buff)) > 0) {
                outWriter.write(buff, 0, count);
            }
            return;
        }
        finally {
            if (ins != null) {
                ins.close();
            }
            if (baos != null) {
                baos.close();
            }
            if (inputReader != null) {
                inputReader.close();
            }
            if (outWriter != null) {
                outWriter.close();
            }
        }
    }

    private int convertToLF(byte[] buff) {
        int index = 0;
        for (int i = 0; i < buff.length; ++i) {
            if (buff[i] == 13) continue;
            buff[index++] = buff[i];
        }
        return index;
    }

    public String getResultingSource(FileObject fileObject) throws IOException {
        assert (fileObject != null) : "Provided fileObject is null";
        StringWriter writer = new StringWriter();
        this.commit(fileObject, this.diffs.get(fileObject), writer);
        return writer.toString();
    }

    public Collection<? extends File> getNewFiles() {
        return Collections.EMPTY_LIST;
    }

    public static final class Difference {
        private final Kind kind;
        private final PositionBounds position;
        private final String newText;
        private boolean excluded;

        public Difference(Kind kind, PositionBounds position, String newText) {
            this.kind = kind;
            this.position = position;
            this.newText = newText;
            this.excluded = false;
        }

        public Kind getKind() {
            return this.kind;
        }

        public PositionRef getStartPosition() {
            return this.position.getBegin();
        }

        public PositionRef getEndPosition() {
            return this.position.getEnd();
        }

        public String getNewText() {
            return this.newText;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public void setExcluded(boolean excluded) {
            this.excluded = excluded;
        }

        public String toString() {
            return (Object)((Object)this.kind) + "<" + this.getStartPosition() + ", " + this.getEndPosition() + "> -> " + this.newText;
        }

        public static enum Kind {
            INSERT,
            REMOVE,
            CHANGE;

        }
    }
}

