/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectapi.nb;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.EventListener;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.spi.project.ProjectIconAnnotator;
import org.netbeans.spi.project.ProjectInformationProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public final class NbProjectInformationProvider
implements ProjectInformationProvider {
    private static final Logger LOGGER = Logger.getLogger(NbProjectInformationProvider.class.getName());

    @NonNull
    public ProjectInformation getProjectInformation(Project project) {
        ProjectInformation pi = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        return new AnnotateIconProxyProjectInformation((ProjectInformation)(pi != null ? pi : new BasicInformation(project)));
    }

    private static final class AnnotateIconProxyProjectInformation
    implements ProjectInformation,
    PropertyChangeListener,
    ChangeListener,
    LookupListener {
        private final ProjectInformation pinfo;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final Set<ProjectIconAnnotator> annotators = Collections.newSetFromMap(new WeakHashMap());
        private boolean annotatorsInitialized = false;
        private boolean addedPropertyListener = false;
        private final Object LOCK = new Object();
        private Lookup.Result<ProjectIconAnnotator> annotatorResult;
        private Icon icon;

        public AnnotateIconProxyProjectInformation(ProjectInformation pi) {
            this.pinfo = pi;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void annotatorsChanged() {
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.annotatorsInitialized) {
                    this.annotatorResult = Lookup.getDefault().lookupResult(ProjectIconAnnotator.class);
                    this.annotatorResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.annotatorResult));
                    this.annotatorsInitialized = true;
                }
                for (ProjectIconAnnotator pa : this.annotatorResult.allInstances()) {
                    if (!this.annotators.add(pa)) continue;
                    pa.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)pa));
                }
            }
        }

        public void resultChanged(LookupEvent ev) {
            this.annotatorsChanged();
            this.updateIcon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("icon".equals(evt.getPropertyName())) {
                Object object = this.LOCK;
                synchronized (object) {
                    if (!this.annotatorsInitialized) {
                        this.annotatorsChanged();
                    }
                }
                this.updateIcon(true);
            } else {
                this.pcs.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateIcon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateIcon(boolean fireChange) {
            Icon newOne;
            Icon original = this.pinfo.getIcon();
            if (original == null) {
                LOGGER.log(Level.WARNING, "no icon for {0}", this.pinfo);
                return;
            }
            Image _icon = ImageUtilities.icon2Image((Icon)original);
            Project prj = this.getProject();
            assert (prj != null) : "ProjectIformation.getProject() == null for " + this.pinfo;
            if (prj != null) {
                for (ProjectIconAnnotator pa : this.annotatorResult.allInstances()) {
                    _icon = pa.annotateIcon(prj, _icon, false);
                }
            }
            Icon old = this.icon;
            Object object = this.LOCK;
            synchronized (object) {
                newOne = this.icon = ImageUtilities.image2Icon((Image)_icon);
            }
            if (fireChange) {
                this.pcs.firePropertyChange("icon", old, newOne);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Icon getIcon() {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.icon == null) {
                    if (!this.annotatorsInitialized) {
                        this.annotatorsChanged();
                    }
                    this.updateIcon(false);
                }
                return this.icon;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.addedPropertyListener) {
                    this.pinfo.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.pinfo));
                    this.addedPropertyListener = true;
                }
            }
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        public Project getProject() {
            return this.pinfo.getProject();
        }

        public String getName() {
            return this.pinfo.getName();
        }

        public String getDisplayName() {
            return this.pinfo.getDisplayName();
        }
    }

    private static final class BasicInformation
    implements ProjectInformation {
        private final Project p;

        public BasicInformation(Project p) {
            this.p = p;
        }

        public String getName() {
            return this.getProjectDirectory().toURL().toExternalForm();
        }

        public String getDisplayName() {
            return this.getProjectDirectory().getNameExt();
        }

        public Icon getIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/projectapi/resources/empty.gif", (boolean)false);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        public Project getProject() {
            return this.p;
        }

        @NonNull
        private FileObject getProjectDirectory() {
            FileObject pd = this.p.getProjectDirectory();
            if (pd == null) {
                throw new IllegalStateException(String.format("Project: %s returned null project directory.", this.p));
            }
            return pd;
        }
    }
}

