/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.oql.language.ui;

import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.profiler.oql.language.OQLTokenId;
import org.netbeans.modules.profiler.oql.spi.OQLEditorImpl;

public class OQLEditor
extends OQLEditorImpl {
    private JEditorPane createEditor() {
        String mimeType = "text/x-oql";
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditorKit((EditorKit)MimeLookup.getLookup((String)mimeType).lookup(EditorKit.class));
        TokenHierarchy th = TokenHierarchy.get((Document)editorPane.getDocument());
        th.addTokenHierarchyListener((TokenHierarchyListener)new TokenChangeListener(editorPane.getDocument()));
        return editorPane;
    }

    public synchronized JEditorPane getEditorPane() {
        return this.createEditor();
    }

    private static final class TokenChangeListener
    implements TokenHierarchyListener {
        volatile boolean validFlag;
        private final Document document;

        public TokenChangeListener(Document document) {
            this.document = document;
        }

        public void tokenHierarchyChanged(TokenHierarchyEvent evt) {
            TokenSequence ts = evt.tokenHierarchy().tokenSequence();
            this.validFlag = true;
            if (ts.tokenCount() == 0) {
                this.validFlag = false;
            } else {
                while (ts.moveNext()) {
                    if (ts.token().id() != OQLTokenId.ERROR) continue;
                    this.validFlag = false;
                    break;
                }
            }
            OQLEditor.getValidationCallback((Document)this.document).callback(this.validFlag);
        }
    }
}

